/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class IteRemover
extends NonCoreBooleanSubTermTransformer {
    private final ManagedScript mScript;

    public IteRemover(ManagedScript script) {
        this.mScript = script;
    }

    @Override
    protected Term transformNonCoreBooleanSubterm(Term term) {
        assert (SmtSortUtils.isBoolSort(term.getSort()));
        Term result = term;
        Set<ApplicationTerm> iteSubterms = new ApplicationTermFinder("ite", false).findMatchingSubterms(result);
        while (!iteSubterms.isEmpty()) {
            result = this.removeIteTerm(result, iteSubterms.iterator().next());
            iteSubterms = new ApplicationTermFinder("ite", false).findMatchingSubterms(result);
        }
        assert (this.doesNotContainIteTerm(result)) : "not all ite terms were removed";
        assert (Util.checkSat((Script)this.mScript.getScript(), (Term)this.mScript.getScript().term("distinct", new Term[]{term, result})) != Script.LBool.SAT);
        return result;
    }

    private boolean doesNotContainIteTerm(Term term) {
        return new ApplicationTermFinder("ite", true).findMatchingSubterms(term).isEmpty();
    }

    private Term removeIteTerm(Term term, ApplicationTerm iteTerm) {
        assert (iteTerm.getFunction().getName().equals("ite"));
        assert (iteTerm.getParameters().length == 3);
        Term condition = iteTerm.getParameters()[0];
        Term ifTerm = iteTerm.getParameters()[1];
        Term elseTerm = iteTerm.getParameters()[2];
        Map<ApplicationTerm, Term> substitutionMapping = Collections.singletonMap(iteTerm, ifTerm);
        Term replacedWithIf = Substitution.apply(this.mScript, substitutionMapping, term);
        Map<ApplicationTerm, Term> substitutionMapping2 = Collections.singletonMap(iteTerm, elseTerm);
        Term replacedWithElse = Substitution.apply(this.mScript, substitutionMapping2, term);
        Term withoutThisIte = SmtUtils.or(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), condition, replacedWithIf), SmtUtils.and(this.mScript.getScript(), SmtUtils.not(this.mScript.getScript(), condition), replacedWithElse));
        return withoutThisIte;
    }
}

