/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ManagedScript {
    private static final String MANAGED_SCRIPT_LOCKED_BY = "ManagedScript locked by ";
    protected final IUltimateServiceProvider mServices;
    protected final Script mScript;
    protected final ILogger mLogger;
    protected final VariableManager mVariableManager;
    private final SkolemFunctionManager mSkolemFunctionManager;
    private Object mLockOwner;

    public ManagedScript(IUltimateServiceProvider services, Script script) {
        this.mServices = services;
        this.mScript = script;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mVariableManager = new VariableManager();
        this.mSkolemFunctionManager = new SkolemFunctionManager();
    }

    public void lock(Object lockOwner) {
        if (lockOwner == null) {
            throw new IllegalArgumentException("cannot be locked by null");
        }
        if (this.mLockOwner == null) {
            this.mLockOwner = lockOwner;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(MANAGED_SCRIPT_LOCKED_BY + lockOwner.toString()));
            }
        } else {
            throw new IllegalStateException("ManagedScript already locked by " + this.mLockOwner.toString());
        }
    }

    public void unlock(Object lockOwner) {
        if (this.mLockOwner == null) {
            throw new IllegalStateException("ManagedScript not locked");
        }
        if (this.mLockOwner == lockOwner) {
            this.mLockOwner = null;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("ManagedScript unlocked by " + lockOwner.toString()));
            }
        } else {
            throw new IllegalStateException(MANAGED_SCRIPT_LOCKED_BY + this.mLockOwner.toString());
        }
    }

    public boolean isLocked() {
        return this.mLockOwner != null;
    }

    public boolean requestLockRelease() {
        if (this.mLockOwner == null) {
            throw new IllegalStateException("ManagedScript not locked");
        }
        if (this.mLockOwner instanceof ILockHolderWithVoluntaryLockRelease) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Asking " + this.mLockOwner + " to release lock"));
            }
            ((ILockHolderWithVoluntaryLockRelease)this.mLockOwner).releaseLock();
            return true;
        }
        return false;
    }

    public boolean isLockOwner(Object allegedLockOwner) {
        return allegedLockOwner == this.mLockOwner;
    }

    public void push(Object lockOwner, int levels) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        this.mScript.push(levels);
    }

    public void pop(Object lockOwner, int levels) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        this.mScript.pop(levels);
    }

    public Script.LBool assertTerm(Object lockOwner, Term term) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.assertTerm(term);
    }

    public Script.LBool checkSat(Object lockOwner) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.checkSat();
    }

    public Term[] getUnsatCore(Object lockOwner) throws SMTLIBException, UnsupportedOperationException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.getUnsatCore();
    }

    public Term annotate(Object lockOwner, Term t, Annotation ... annotations) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.annotate(t, annotations);
    }

    public Term term(Object lockOwner, String funcname, Term ... params) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.term(funcname, params);
    }

    public Term term(Object lockOwner, String funcname, String[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.term(funcname, indices, returnSort, params);
    }

    public Term let(Object lockOwner, TermVariable[] vars, Term[] values, Term body) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.let(vars, values, body);
    }

    public void declareFun(Object lockOwner, String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        this.mScript.declareFun(fun, paramSorts, resultSort);
    }

    public QuotedObject echo(Object lockOwner, QuotedObject msg) {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.echo(msg);
    }

    public Map<Term, Term> getValue(Object lockOwner, Term[] terms) {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.getValue(terms);
    }

    public Script getScript() {
        return this.mScript;
    }

    public Term[] getInterpolants(Object lockOwner, Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.getInterpolants(partition);
    }

    public Term[] getInterpolants(Object lockOwner, Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        assert (lockOwner == this.mLockOwner) : ManagedScript.generateLockErrorMessage(lockOwner, this.mLockOwner);
        return this.mScript.getInterpolants(partition, startOfSubtree);
    }

    private static String generateLockErrorMessage(Object expectedLockOwner, Object actualLockOwner) {
        if (actualLockOwner == null) {
            return "A " + expectedLockOwner.getClass().getSimpleName() + " wants to use this ManagedScript without locking";
        }
        return "A " + expectedLockOwner.getClass().getSimpleName() + " wants to use this ManagedScript but it is locked by some " + actualLockOwner.getClass().getSimpleName();
    }

    public TermVariable constructFreshTermVariable(String name, Sort sort) {
        return this.mVariableManager.constructFreshTermVariable(name, sort);
    }

    public TermVariable constructFreshCopy(TermVariable tv) {
        return this.mVariableManager.constructFreshCopy(tv);
    }

    public Map<TermVariable, TermVariable> constructFreshCopies(Set<TermVariable> tvs) {
        LinkedHashMap<TermVariable, TermVariable> result = new LinkedHashMap<TermVariable, TermVariable>();
        for (TermVariable tv : tvs) {
            result.put(tv, this.constructFreshCopy(tv));
        }
        return result;
    }

    public TermVariable variable(String varname, Sort sort) {
        return this.mVariableManager.variable(varname, sort);
    }

    public String constructFreshSkolemFunctionName(Sort[] parameterSorts, Sort resultSort) {
        return this.mSkolemFunctionManager.constructFreshSkolemFunctionName(parameterSorts, resultSort);
    }

    @FunctionalInterface
    public static interface ILockHolderWithVoluntaryLockRelease {
        public void releaseLock();
    }

    private class SkolemFunctionManager {
        private static final String SKOLEM_PREFIX = "skolem";
        private int counter;

        private SkolemFunctionManager() {
        }

        public String constructFreshSkolemFunctionName(Sort[] parameterSorts, Sort resultSort) {
            return SKOLEM_PREFIX + this.counter++;
        }
    }

    private class VariableManager {
        private final MultiElementCounter<String> mTvForBasenameCounter = new MultiElementCounter();
        private final Map<TermVariable, String> mTv2Basename = new HashMap<TermVariable, String>();
        private final Set<String> mVariableNames = new HashSet<String>();

        private VariableManager() {
        }

        public TermVariable constructFreshTermVariable(String name, Sort sort) {
            if (name.contains("|")) {
                throw new IllegalArgumentException("Name contains SMT quote characters " + name);
            }
            Integer newIndex = this.mTvForBasenameCounter.increment((Object)name);
            TermVariable result = ManagedScript.this.mScript.variable("v_" + name + "_" + newIndex, sort);
            this.mTv2Basename.put(result, name);
            return result;
        }

        public TermVariable constructFreshCopy(TermVariable tv) {
            String basename = this.mTv2Basename.get(tv);
            if (basename == null) {
                ManagedScript.this.mLogger.warn((Object)("TermVariable " + tv + " not constructed by VariableManager. Cannot ensure absence of name clashes."));
                basename = SmtUtils.removeSmtQuoteCharacters(tv.getName());
            }
            TermVariable result = this.constructFreshTermVariable(basename, tv.getSort());
            return result;
        }

        public TermVariable variable(String varname, Sort sort) {
            if (this.mVariableNames.contains(varname)) {
                throw new IllegalArgumentException("A variable with that name was already constructed: " + varname);
            }
            TermVariable result = ManagedScript.this.mScript.variable(varname, sort);
            this.mTv2Basename.put(result, varname);
            return result;
        }
    }
}

