/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;

public abstract class NonCoreBooleanSubTermTransformer {
    private NonCoreBooleanSubtermTransformerHelper mTransformerHelper;

    public Term transform(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            throw new IllegalArgumentException("Input term of sort Bool");
        }
        this.mTransformerHelper = new NonCoreBooleanSubtermTransformerHelper();
        Term result = this.mTransformerHelper.transform(term);
        return result;
    }

    private static boolean hasBooleanParams(Term[] parameters) {
        Term[] termArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (!SmtSortUtils.isBoolSort(term.getSort())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isCoreBooleanConnective(String fun) {
        return fun.equals("=") || fun.equals("not") || fun.equals("and") || fun.equals("or") || fun.equals("=>") || fun.equals("xor") || fun.equals("distinct") || fun.equals("ite");
    }

    public static boolean isCoreBooleanNonAtom(ApplicationTerm appTerm) {
        String funName = appTerm.getFunction().getName();
        return NonCoreBooleanSubTermTransformer.isCoreBooleanConnective(funName) && NonCoreBooleanSubTermTransformer.hasBooleanParams(appTerm.getParameters());
    }

    protected abstract Term transformNonCoreBooleanSubterm(Term var1);

    private class NonCoreBooleanSubtermTransformerHelper
    extends TermTransformer {
        private NonCoreBooleanSubtermTransformerHelper() {
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void convert(Term term) {
            assert (SmtSortUtils.isBoolSort(term.getSort())) : "not Bool";
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                if (!NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(appTerm)) {
                    Term transformed = NonCoreBooleanSubTermTransformer.this.transformNonCoreBooleanSubterm(term);
                    this.setResult(transformed);
                    return;
                }
                super.convert(term);
            } else {
                if (term instanceof LetTerm) {
                    throw new UnsupportedOperationException(String.valueOf(NonCoreBooleanSubTermTransformer.class.getSimpleName()) + " does not support " + LetTerm.class.getSimpleName());
                }
                if (term instanceof AnnotatedTerm) {
                    throw new UnsupportedOperationException(String.valueOf(NonCoreBooleanSubTermTransformer.class.getSimpleName()) + " does not support " + AnnotatedTerm.class.getSimpleName());
                }
            }
            super.convert(term);
        }
    }
}

