/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Set;

public abstract class NonTheorySymbol<SYMBOL> {
    private final SYMBOL mSymbol;

    private NonTheorySymbol(SYMBOL symbol) {
        this.mSymbol = symbol;
    }

    public SYMBOL getSymbol() {
        return this.mSymbol;
    }

    public final int hashCode() {
        int result = 1;
        result = 31 * result + (this.mSymbol == null ? 0 : this.mSymbol.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NonTheorySymbol other = (NonTheorySymbol)obj;
        return !(this.mSymbol == null ? other.mSymbol != null : !this.mSymbol.equals(other.mSymbol));
    }

    public final String toString() {
        return this.mSymbol.toString();
    }

    public static Set<NonTheorySymbol<?>> extractNonTheorySymbols(Term term) {
        return new NonTheorySymbolFinder().findNonTheorySymbols(term);
    }

    public static class Constant
    extends NonTheorySymbol<ApplicationTerm> {
        public Constant(ApplicationTerm constant) {
            super(constant);
            if (constant.getParameters().length > 0) {
                throw new IllegalArgumentException("this is no constant");
            }
            if (constant.getFunction().isIntern()) {
                throw new IllegalArgumentException("this is not a non-theory symbol");
            }
        }
    }

    public static class Function
    extends NonTheorySymbol<FunctionSymbol> {
        public Function(FunctionSymbol functionSymbol) {
            super(functionSymbol);
            if (functionSymbol.isIntern()) {
                throw new IllegalArgumentException("this is not a non-theory symbol");
            }
        }
    }

    public static class Variable
    extends NonTheorySymbol<TermVariable> {
        public Variable(TermVariable tv) {
            super(tv);
        }
    }
}

