/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermContextTransformationEngine;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolyPoNeUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisDepthCodeGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.List;

public class PolyPacSimplificationTermWalker
extends TermContextTransformationEngine.TermWalker<Term> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private static final boolean DEBUG_CHECK_RESULT = false;

    private PolyPacSimplificationTermWalker(IUltimateServiceProvider services, ManagedScript mgdScript) {
        this.mServices = services;
        this.mMgdScript = mgdScript;
    }

    @Override
    protected Term constructContextForApplicationTerm(Term context, FunctionSymbol symb, List<Term> allParams, int selectedParam) {
        return Context.buildCriticalConstraintForConDis(this.mServices, this.mMgdScript, context, symb, allParams, selectedParam, Context.CcTransformation.TO_NNF);
    }

    @Override
    protected Term constructContextForQuantifiedFormula(Term context, int quant, List<TermVariable> vars) {
        return Context.buildCriticalContraintForQuantifiedFormula(this.mMgdScript.getScript(), context, vars, Context.CcTransformation.TO_NNF);
    }

    @Override
    protected TermContextTransformationEngine.DescendResult convert(Term context, Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (appTerm.getFunction().getName().equals("and") || appTerm.getFunction().getName().equals("or")) {
                if (SmtUtils.isFalseLiteral(context)) {
                    Term result;
                    if (appTerm.getFunction().getName().equals("and")) {
                        result = this.mMgdScript.getScript().term("true", new Term[0]);
                    } else if (appTerm.getFunction().getName().equals("or")) {
                        result = this.mMgdScript.getScript().term("false", new Term[0]);
                    } else {
                        throw new AssertionError();
                    }
                    return new TermContextTransformationEngine.FinalResultForAscend(result);
                }
                return new TermContextTransformationEngine.IntermediateResultForDescend(term);
            }
        } else if (term instanceof QuantifiedFormula) {
            return new TermContextTransformationEngine.IntermediateResultForDescend(term);
        }
        return new TermContextTransformationEngine.FinalResultForAscend(term);
    }

    @Override
    protected Term constructResultForApplicationTerm(Term context, ApplicationTerm originalApplicationTerm, Term[] resultParams) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            CondisDepthCodeGenerator.CondisDepthCode contextCdc = CondisDepthCodeGenerator.CondisDepthCode.of(context);
            throw new ToolchainCanceledException(this.getClass(), String.format("simplifying %s xjuncts wrt. a %s context", resultParams.length, contextCdc));
        }
        if (originalApplicationTerm.getFunction().getName().equals("and")) {
            return PolyPoNeUtils.and(this.mMgdScript.getScript(), context, Arrays.asList(resultParams));
        }
        if (originalApplicationTerm.getFunction().getName().equals("or")) {
            return PolyPoNeUtils.or(this.mMgdScript.getScript(), context, Arrays.asList(resultParams));
        }
        throw new AssertionError();
    }

    public static Term simplify(IUltimateServiceProvider services, ManagedScript mgdScript, Term term) {
        Term result = PolyPacSimplificationTermWalker.simplify(services, mgdScript, mgdScript.getScript().term("true", new Term[0]), term);
        return result;
    }

    public static Term simplify(IUltimateServiceProvider services, ManagedScript mgdScript, Term context, Term term) {
        Term result;
        try {
            result = TermContextTransformationEngine.transform(new PolyPacSimplificationTermWalker(services, mgdScript), context, term);
        }
        catch (ToolchainCanceledException tce) {
            CondisDepthCodeGenerator.CondisDepthCode termCdc = CondisDepthCodeGenerator.CondisDepthCode.of(term);
            String taskDescription = String.format("simplifying a %s term", termCdc);
            tce.addRunningTaskInfo(new RunningTaskInfo(PolyPacSimplificationTermWalker.class, taskDescription));
            throw tce;
        }
        return result;
    }

    @Override
    protected Term constructResultForQuantifiedFormula(Term context, QuantifiedFormula originalQuantifiedFormula, Term resultSubformula) {
        return SmtUtils.quantifier(this.mMgdScript.getScript(), originalQuantifiedFormula.getQuantifier(), Arrays.asList(originalQuantifiedFormula.getVariables()), resultSubformula);
    }

    @Override
    protected boolean applyRepeatedlyUntilNoChange() {
        return true;
    }

    @Override
    protected void checkIntermediateResult(Term context, Term input, Term output) {
        Script.LBool lBool = SmtUtils.checkEquivalenceUnderAssumption(input, output, context, this.mMgdScript.getScript());
        switch (lBool) {
            case SAT: {
                throw new AssertionError((Object)String.format("Intermediate result not equivalent. Input: %s Output: %s Assumption: %s", input, output, context));
            }
            case UNKNOWN: {
                ILogger logger = this.mServices.getLoggingService().getLogger(this.getClass());
                logger.info((Object)String.format("Insufficient ressources to check equivalence of intermediate result. Input: %s Output: %s Assumption: %s", input, output, context));
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + lBool));
            }
        }
    }
}

