/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PureSubstitution
extends TermTransformer {
    private final Script mScript;
    protected final ManagedScript mMgdScript;
    private final ScopedHashMap<Term, Term> mScopedSubstitutionMapping;

    public PureSubstitution(Script script, Map<? extends Term, ? extends Term> substitutionMapping) {
        this.mMgdScript = null;
        this.mScript = script;
        this.mScopedSubstitutionMapping = new ScopedHashMap();
        this.mScopedSubstitutionMapping.putAll(substitutionMapping);
    }

    public PureSubstitution(ManagedScript mgdScript, Map<? extends Term, ? extends Term> substitutionMapping) {
        this.mMgdScript = mgdScript;
        this.mScript = mgdScript.getScript();
        this.mScopedSubstitutionMapping = new ScopedHashMap();
        this.mScopedSubstitutionMapping.putAll(substitutionMapping);
    }

    protected void convert(Term term) {
        Term mappedTerm = (Term)this.mScopedSubstitutionMapping.get((Object)term);
        if (mappedTerm != null) {
            this.setResult(mappedTerm);
        } else {
            if (term instanceof QuantifiedFormula) {
                this.mScopedSubstitutionMapping.beginScope();
                QuantifiedFormula qFormula = (QuantifiedFormula)term;
                this.removeQuantifiedVarContainingKeys(qFormula);
                term = this.renameQuantifiedVarsThatOccurInValues(qFormula);
            } else if (term instanceof LetTerm) {
                throw new UnsupportedOperationException("LetTerm not supported");
            }
            super.convert(term);
        }
    }

    private Term renameQuantifiedVarsThatOccurInValues(QuantifiedFormula qFormula) {
        Set<TermVariable> toRename = PureSubstitution.varsOccuringInValues(qFormula.getVariables(), this.mScopedSubstitutionMapping);
        if (toRename.isEmpty()) {
            return qFormula;
        }
        if (this.mMgdScript == null) {
            throw new UnsupportedOperationException("Substitution in quantified formula such that substitute containes quantified variable. This (rare) case is only supported if you call substitution with fresh variable construction.");
        }
        return SmtUtils.renameQuantifiedVariables(this.mMgdScript, qFormula, toRename, "subst");
    }

    private void removeQuantifiedVarContainingKeys(QuantifiedFormula qFormula) {
        Iterator it = this.mScopedSubstitutionMapping.entrySet().iterator();
        while (it.hasNext()) {
            List<TermVariable> occuringVars;
            Map.Entry entry = (Map.Entry)it.next();
            List<TermVariable> quantifiedVars = Arrays.asList(qFormula.getVariables());
            if (Collections.disjoint(quantifiedVars, occuringVars = Arrays.asList(((Term)entry.getKey()).getFreeVars()))) continue;
            it.remove();
        }
    }

    private static Set<TermVariable> varsOccuringInValues(TermVariable[] vars, Map<?, Term> map) {
        Set<TermVariable> result = null;
        for (Term term : map.values()) {
            TermVariable[] termVariableArray = term.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable tv = termVariableArray[n2];
                if (Arrays.asList(vars).contains(tv)) {
                    result = PureSubstitution.addToSet(tv, result);
                }
                ++n2;
            }
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private static Set<TermVariable> addToSet(TermVariable tv, Set<TermVariable> set) {
        if (set == null) {
            set = new HashSet<TermVariable>();
        }
        set.add(tv);
        return set;
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        QuantifiedFormula result;
        TermVariable[] newQuantifiedVars = new TermVariable[old.getVariables().length];
        boolean quantifiedVariablesChanged = false;
        int i = 0;
        while (i < old.getVariables().length) {
            if (this.mScopedSubstitutionMapping.containsKey((Object)old.getVariables()[i])) {
                newQuantifiedVars[i] = old.getVariables()[i];
                quantifiedVariablesChanged = true;
            } else {
                newQuantifiedVars[i] = old.getVariables()[i];
            }
            ++i;
        }
        if (old.getSubformula() == newBody) {
            assert (!quantifiedVariablesChanged);
            result = old;
        } else {
            if (!quantifiedVariablesChanged) {
                newQuantifiedVars = old.getVariables();
            }
            result = this.mScript.quantifier(old.getQuantifier(), newQuantifiedVars, newBody, (Term[][])new Term[0][]);
        }
        this.mScopedSubstitutionMapping.endScope();
        this.setResult((Term)result);
    }

    public String toString() {
        return "Substitution " + this.mScopedSubstitutionMapping.toString();
    }
}

