/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.math.BigInteger;

public final class SmtSortUtils {
    public static final String ARRAY_SORT = "Array";
    public static final String BOOL_SORT = "Bool";
    public static final String INT_SORT = "Int";
    public static final String REAL_SORT = "Real";
    public static final String BITVECTOR_SORT = "BitVec";
    public static final String FLOATINGPOINT_SORT = "FloatingPoint";
    public static final String ROUNDINGMODE_SORT = "RoundingMode";

    private SmtSortUtils() {
    }

    public static boolean isBoolSort(Sort sort) {
        return BOOL_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getBoolSort(Script script) {
        return script.sort(BOOL_SORT, new Sort[0]);
    }

    public static Sort getBoolSort(ManagedScript script) {
        return SmtSortUtils.getBoolSort(script.getScript());
    }

    public static boolean isIntSort(Sort sort) {
        return INT_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getIntSort(Script script) {
        return script.sort(INT_SORT, new Sort[0]);
    }

    public static Sort getIntSort(ManagedScript script) {
        return SmtSortUtils.getIntSort(script.getScript());
    }

    public static boolean isRealSort(Sort sort) {
        return REAL_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isNumericSort(Sort sort) {
        return sort.getRealSort().isNumericSort();
    }

    public static boolean isArraySort(Sort sort) {
        return sort.getRealSort().isArraySort();
    }

    public static boolean isBitvecSort(Sort sort) {
        return BITVECTOR_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isFloatingpointSort(Sort sort) {
        return FLOATINGPOINT_SORT.equals(sort.getRealSort().getName());
    }

    public static boolean isRoundingmodeSort(Sort sort) {
        return ROUNDINGMODE_SORT.equals(sort.getRealSort().getName());
    }

    public static Sort getRoundingmodeSort(Script script) {
        return script.sort(ROUNDINGMODE_SORT, new Sort[0]);
    }

    public static Sort getRoundingmodeSort(ManagedScript script) {
        return SmtSortUtils.getIntSort(script.getScript());
    }

    public static Sort getRealSort(Script script) {
        return script.sort(REAL_SORT, new Sort[0]);
    }

    public static Sort getBitvectorSort(Script script, int size) {
        return SmtSortUtils.getBitvectorSort(script, BigInteger.valueOf(size));
    }

    public static int getBitvectorLength(Sort sort) {
        if (!SmtSortUtils.isBitvecSort(sort)) {
            return -1;
        }
        return Integer.parseInt(sort.getIndices()[0]);
    }

    public static Sort getBitvectorSort(Script script, BigInteger size) {
        return script.sort(BITVECTOR_SORT, new String[]{size.toString()}, new Sort[0]);
    }

    public static Sort getArraySort(Script script, Sort domainSort, Sort rangeSort) {
        return script.sort(ARRAY_SORT, new Sort[]{domainSort, rangeSort});
    }

    public static Sort getNamedSort(Script script, String name) {
        return script.sort(name, new Sort[0]);
    }

    public static Sort getBuiltinSort(Script script, String attributeDefinedIdentifier, String[] indices) {
        return script.sort(attributeDefinedIdentifier, indices, new Sort[0]);
    }

    public static Sort getRealSort(ManagedScript script) {
        return SmtSortUtils.getRealSort(script.getScript());
    }
}

