/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd.SimplifyBdd;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PolyPacSimplificationTermWalker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UndoableWrapperScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryNumericRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.CnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineSubtermNormalizer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyDDAWithTimeout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyQuick;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class SmtUtils {
    private static final String[] EMPTY_INDICES = new String[0];
    private static final BigInteger[] EMPTY_INDICES_BI = new BigInteger[0];
    private static final String ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT = "unknown enum constant ";
    private static final String ERROR_MSG_UNKNOWN_SORT = "unknown sort ";
    private static final boolean BINARY_BITVECTOR_SUM_WORKAROUND = false;
    public static final String FP_TO_IEEE_BV_EXTENSION = "fp.to_ieee_bv";
    private static final boolean EXTENDED_LOCAL_SIMPLIFICATION = true;
    private static final boolean FLATTEN_ARRAY_TERMS = true;
    private static final boolean DEBUG_ASSERT_ULTIMATE_NORMAL_FORM = false;
    private static final boolean DEBUG_CHECK_EVERY_SIMPLIFICATION = false;

    private SmtUtils() {
    }

    public static Term simplify(ManagedScript mgdScript, Term formula, IUltimateServiceProvider services, SimplificationTechnique simplificationTechnique) {
        return SmtUtils.simplify(mgdScript, formula, mgdScript.getScript().term("true", new Term[0]), services, simplificationTechnique);
    }

    public static Term simplify(ManagedScript mgScript, Term formula, Term context, IUltimateServiceProvider services, SimplificationTechnique simplificationTechnique) {
        if (simplificationTechnique == SimplificationTechnique.NONE) {
            return formula;
        }
        Objects.requireNonNull(context);
        ILogger logger = services.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new DebugMessage("simplifying formula of DAG size {0}", new Object[]{new DagSizePrinter(formula)}));
        }
        if (!SmtUtils.isTrueLiteral(context) && simplificationTechnique != SimplificationTechnique.POLY_PAC && simplificationTechnique != SimplificationTechnique.SIMPLIFY_DDA && simplificationTechnique != SimplificationTechnique.NONE) {
            throw new UnsupportedOperationException((Object)((Object)simplificationTechnique) + " does not support simplification with respect to context");
        }
        long startTime = System.nanoTime();
        UndoableWrapperScript undoableScript = new UndoableWrapperScript(mgScript.getScript());
        ManagedScript script = new ManagedScript(services, (Script)undoableScript);
        try {
            long endTime;
            long overallTimeMs;
            Term simplified;
            switch (simplificationTechnique) {
                case SIMPLIFY_BDD_PROP: {
                    simplified = new SimplifyBdd(services, script).transform(formula);
                    break;
                }
                case SIMPLIFY_BDD_FIRST_ORDER: {
                    simplified = new SimplifyBdd(services, script).transformWithImplications(formula);
                    break;
                }
                case SIMPLIFY_DDA: {
                    simplified = new SimplifyDDAWithTimeout(script.getScript(), true, services, context).getSimplifiedTerm(formula);
                    break;
                }
                case SIMPLIFY_QUICK: {
                    simplified = new SimplifyQuick(script.getScript(), services).getSimplifiedTerm(formula);
                    break;
                }
                case NONE: {
                    return formula;
                }
                case POLY_PAC: {
                    simplified = PolyPacSimplificationTermWalker.simplify(services, script, context, formula);
                    break;
                }
                default: {
                    throw new AssertionError((Object)(ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT + (Object)((Object)simplificationTechnique)));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new DebugMessage("DAG size before simplification {0}, DAG size after simplification {1}", new Object[]{new DagSizePrinter(formula), new DagSizePrinter(simplified)}));
            }
            if ((overallTimeMs = ((endTime = System.nanoTime()) - startTime) / 1000000L) >= 5000L) {
                StringBuilder sb = new StringBuilder();
                sb.append("Spent ").append(CoreUtil.humanReadableTime((long)overallTimeMs, (TimeUnit)TimeUnit.MILLISECONDS, (int)2)).append(" on a formula simplification");
                if (formula.equals(simplified)) {
                    sb.append(" that was a NOOP. DAG size: ");
                    sb.append(new DagSizePrinter(formula));
                } else {
                    sb.append(". DAG size of input: ");
                    sb.append(new DagSizePrinter(formula));
                    sb.append(" DAG size of output: ");
                    sb.append(new DagSizePrinter(simplified));
                }
                sb.append(" (called from ").append(ReflectionUtil.getCallerSignatureFiltered(Set.of(SmtUtils.class))).append(")");
                logger.warn((Object)sb);
            }
            undoableScript.restore();
            if (simplified != formula) {
                return new UnfTransformer(mgScript.getScript()).transform(simplified);
            }
            return simplified;
        }
        catch (ToolchainCanceledException t) {
            int dirtyLevels = undoableScript.restore();
            if (dirtyLevels > 0) {
                logger.warn((Object)("Removed " + dirtyLevels + " from assertion stack"));
            }
            throw t;
        }
    }

    public static ExtendedSimplificationResult simplifyWithStatistics(ManagedScript script, Term formula, IUltimateServiceProvider services, SimplificationTechnique simplificationTechnique) {
        return SmtUtils.simplifyWithStatistics(script, formula, script.term(null, "true", new Term[0]), services, simplificationTechnique);
    }

    public static ExtendedSimplificationResult simplifyWithStatistics(ManagedScript script, Term formula, Term context, IUltimateServiceProvider services, SimplificationTechnique simplificationTechnique) {
        long startTime = System.nanoTime();
        long sizeBefore = new DAGSize().treesize(formula);
        Term simplified = SmtUtils.simplify(script, formula, context, services, simplificationTechnique);
        long sizeAfter = new DAGSize().treesize(simplified);
        long endTime = System.nanoTime();
        return new ExtendedSimplificationResult(simplified, endTime - startTime, sizeBefore - sizeAfter, (double)sizeAfter / (double)sizeBefore * 100.0);
    }

    public static Script.LBool checkSatTerm(Script script, Term formula) {
        return Util.checkSat((Script)script, (Term)formula);
    }

    public static Term[] getConjuncts(Term term) {
        ApplicationTerm appTerm;
        if (term instanceof ApplicationTerm && "and".equals((appTerm = (ApplicationTerm)term).getFunction().getName())) {
            return appTerm.getParameters();
        }
        Term[] result = new Term[]{term};
        return result;
    }

    public static Term[] cannibalize(ManagedScript mgnScript, IUltimateServiceProvider services, boolean splitNumericEqualities, Term term) {
        Term cnf = new CnfTransformer(mgnScript, services).transform(term);
        if (splitNumericEqualities) {
            return SmtUtils.splitNumericEqualities(mgnScript.getScript(), SmtUtils.getConjuncts(cnf));
        }
        return SmtUtils.getConjuncts(cnf);
    }

    private static Term[] splitNumericEqualities(Script script, Term[] conjuncts) {
        ArrayList<Term> result = new ArrayList<Term>(conjuncts.length * 2);
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            BinaryNumericRelation bnr = BinaryNumericRelation.convert(conjunct);
            if (bnr == null) {
                result.add(conjunct);
            } else if (bnr.getRelationSymbol() == RelationSymbol.EQ) {
                Term leq = script.term("<=", new Term[]{bnr.getLhs(), bnr.getRhs()});
                result.add(leq);
                Term geq = script.term(">=", new Term[]{bnr.getLhs(), bnr.getRhs()});
                result.add(geq);
            } else {
                result.add(conjunct);
            }
            ++n2;
        }
        return result.toArray(new Term[result.size()]);
    }

    public static Term[] getDisjuncts(Term term) {
        ApplicationTerm appTerm;
        if (term instanceof ApplicationTerm && "or".equals((appTerm = (ApplicationTerm)term).getFunction().getName())) {
            return appTerm.getParameters();
        }
        Term[] result = new Term[]{term};
        return result;
    }

    public static Term binarize(Script script, ApplicationTerm term) {
        FunctionSymbol functionSymbol = term.getFunction();
        if (!functionSymbol.isPairwise() && !functionSymbol.isChainable()) {
            throw new IllegalArgumentException("can only binarize pairwise terms");
        }
        String functionName = functionSymbol.getApplicationString();
        Term[] params = term.getParameters();
        assert (params.length > 1);
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        int i = 0;
        while (i < params.length) {
            int j = i + 1;
            while (j < params.length) {
                conjuncts.add(script.term(functionName, new Term[]{params[i], params[j]}));
                ++j;
            }
            ++i;
        }
        return SmtUtils.and(script, conjuncts.toArray(new Term[conjuncts.size()]));
    }

    public static boolean firstParamIsBool(ApplicationTerm term) {
        Term[] params = term.getParameters();
        return SmtSortUtils.isBoolSort(params[0].getSort());
    }

    public static boolean allParamsAreBool(ApplicationTerm term) {
        return Arrays.stream(term.getParameters()).map(Term::getSort).allMatch(SmtSortUtils::isBoolSort);
    }

    public static Term binaryBooleanEquality(Script script, Term lhs, Term rhs) {
        assert (SmtSortUtils.isBoolSort(lhs.getSort()));
        assert (SmtSortUtils.isBoolSort(rhs.getSort()));
        Term bothTrue = SmtUtils.and(script, lhs, rhs);
        Term bothFalse = SmtUtils.and(script, SmtUtils.not(script, lhs), SmtUtils.not(script, rhs));
        return SmtUtils.or(script, bothTrue, bothFalse);
    }

    public static Term binaryBooleanNotEquals(Script script, Term lhs, Term rhs) {
        assert (SmtSortUtils.isBoolSort(lhs.getSort()));
        assert (SmtSortUtils.isBoolSort(rhs.getSort()));
        Term oneIsTrue = SmtUtils.or(script, lhs, rhs);
        Term oneIsFalse = SmtUtils.or(script, SmtUtils.not(script, lhs), SmtUtils.not(script, rhs));
        return SmtUtils.and(script, oneIsTrue, oneIsFalse);
    }

    public static List<Term> negateElementwise(Script script, List<Term> terms) {
        ArrayList<Term> result = new ArrayList<Term>(terms.size());
        for (Term term : terms) {
            result.add(SmtUtils.not(script, term));
        }
        return result;
    }

    public static Term multiDimensionalSelect(Script script, Term a, ArrayIndex index) {
        assert (a.getSort().isArraySort());
        Term result = a;
        int i = 0;
        while (i < index.size()) {
            result = SmtUtils.select(script, result, index.get(i));
            ++i;
        }
        return result;
    }

    public static Term multiDimensionalStore(Script script, Term a, ArrayIndex index, Term value) {
        assert (!index.isEmpty());
        assert (a.getSort().isArraySort());
        Term result = value;
        int i = index.size() - 1;
        while (i >= 0) {
            Term selectUpToI = SmtUtils.multiDimensionalSelect(script, a, index.getFirst(i));
            result = SmtUtils.store(script, selectUpToI, index.get(i), result);
            --i;
        }
        return result;
    }

    public static <K, V> boolean neitherKeyNorValueIsNull(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public static Term pairwiseEquality(Script script, List<? extends Term> lhs, List<? extends Term> rhs) {
        if (lhs.size() != rhs.size()) {
            throw new IllegalArgumentException("must have same length");
        }
        Term[] equalities = new Term[lhs.size()];
        int i = 0;
        while (i < lhs.size()) {
            equalities[i] = SmtUtils.binaryEquality(script, lhs.get(i), rhs.get(i));
            ++i;
        }
        return SmtUtils.and(script, equalities);
    }

    public static Term indexEqualityImpliesValueEquality(Script script, ArrayIndex index1, ArrayIndex index2, Term value1, Term value2) {
        assert (index1.size() == index2.size());
        Term lhs = SmtUtils.pairwiseEquality(script, index1, index2);
        Term rhs = SmtUtils.binaryEquality(script, value1, value2);
        return SmtUtils.or(script, SmtUtils.not(script, lhs), rhs);
    }

    public static Term sum(Script script, Sort sort, Term ... summands) {
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (summands.length == 0) {
            if (SmtSortUtils.isIntSort(sort) || SmtSortUtils.isRealSort(sort)) {
                return Rational.ZERO.toTerm(sort);
            }
            if (SmtSortUtils.isBitvecSort(sort)) {
                return BitvectorUtils.constructTerm(script, BigInteger.ZERO, sort);
            }
            throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + sort);
        }
        if (summands.length == 1) {
            return summands[0];
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return script.term("+", CommuhashUtils.sortByHashCode(summands));
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + sort);
        }
        return script.term("bvadd", CommuhashUtils.sortByHashCode(summands));
    }

    public static Term binaryBitvectorSum(Script script, Sort sort, Term ... summands) {
        if (summands.length == 0) {
            return BitvectorUtils.constructTerm(script, BigInteger.ZERO, sort);
        }
        if (summands.length == 1) {
            return summands[0];
        }
        Term result = script.term("bvadd", new Term[]{summands[0], summands[1]});
        int i = 2;
        while (i < summands.length) {
            result = script.term("bvadd", new Term[]{result, summands[i]});
            ++i;
        }
        return result;
    }

    public static Term mul(Script script, Rational rational, Term term) {
        if (rational.equals((Object)Rational.ONE)) {
            return term;
        }
        if (rational.equals((Object)Rational.MONE)) {
            return SmtUtils.neg(script, term);
        }
        Term coefficient = SmtUtils.rational2Term(script, rational, term.getSort());
        return SmtUtils.mul(script, term.getSort(), coefficient, term);
    }

    public static Term mul(Script script, Sort sort, Term ... factors) {
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (factors.length == 0) {
            BigInteger one = BigInteger.ONE;
            return SmtUtils.constructIntegerValue(script, sort, one);
        }
        if (factors.length == 1) {
            return factors[0];
        }
        if (SmtSortUtils.isNumericSort(sort)) {
            return script.term("*", CommuhashUtils.sortByHashCode(factors));
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return script.term("bvmul", CommuhashUtils.sortByHashCode(factors));
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + sort);
    }

    public static Term sum(Script script, String funcname, Term ... summands) {
        assert ("+".equals(funcname) || "bvadd".equals(funcname));
        Term sum = script.term(funcname, summands);
        AffineTerm affine = (AffineTerm)new AffineTermTransformer(script).transform(sum);
        if (affine.isErrorTerm()) {
            return sum;
        }
        return affine.toTerm(script);
    }

    public static Term mul(Script script, String funcname, Term ... factors) {
        assert ("*".equals(funcname) || "bvmul".equals(funcname));
        if (factors.length == 0) {
            throw new UnsupportedOperationException("Method does not support empty factors.");
        }
        Term product = factors.length == 1 ? factors[0] : script.term(funcname, CommuhashUtils.sortByHashCode(factors));
        AffineTerm affine = (AffineTerm)new AffineTermTransformer(script).transform(product);
        if (affine.isErrorTerm()) {
            return product;
        }
        return affine.toTerm(script);
    }

    public static Term minus(Script script, Term ... operands) {
        String funcname;
        if (operands.length <= 1) {
            throw new UnsupportedOperationException("use neg for unary minus");
        }
        Term[] newOperands = new Term[operands.length];
        newOperands[0] = operands[0];
        int i = 1;
        while (i < operands.length) {
            newOperands[i] = SmtUtils.neg(script, operands[i]);
            ++i;
        }
        Sort sort = operands[0].getSort();
        if (SmtSortUtils.isNumericSort(sort)) {
            funcname = "+";
        } else if (SmtSortUtils.isBitvecSort(sort)) {
            funcname = "bvadd";
        } else {
            throw new UnsupportedOperationException("unsupported sort " + sort);
        }
        return SmtUtils.sum(script, funcname, newOperands);
    }

    public static Term neg(Script script, Term operand) {
        Sort sort = operand.getSort();
        assert (SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBitvecSort(sort));
        if (SmtSortUtils.isNumericSort(sort)) {
            return SmtUtils.unaryNumericMinus(script, operand);
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return BitvectorUtils.termWithLocalSimplification(script, "bvneg", null, operand);
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + sort);
    }

    public static Term unaryNumericMinus(Script script, Term operand) {
        if (operand instanceof ConstantTerm) {
            ConstantTerm ct = (ConstantTerm)operand;
            Rational value = SmtUtils.toRational(ct);
            return value.negate().toTerm(operand.getSort());
        }
        if (operand instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)operand;
            if (appTerm.getFunction().isIntern()) {
                if (SmtUtils.isUnaryNumericMinus(appTerm.getFunction())) {
                    return appTerm.getParameters()[0];
                }
                if (appTerm.getFunction().getName().equals("+")) {
                    return SmtUtils.sum(script, operand.getSort(), (Term[])Arrays.stream(appTerm.getParameters()).map(x -> SmtUtils.unaryNumericMinus(script, x)).toArray(Term[]::new));
                }
                return script.term("-", new Term[]{operand});
            }
            return script.term("-", new Term[]{operand});
        }
        if (operand instanceof TermVariable) {
            return script.term("-", new Term[]{operand});
        }
        throw new UnsupportedOperationException("cannot apply unary minus to " + operand.getClass().getSimpleName());
    }

    public static Term not(Script script, Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if ("distinct".equals(appTerm.getFunction().getName()) && appTerm.getParameters().length == 2) {
                return SmtUtils.binaryEquality(script, appTerm.getParameters()[0], appTerm.getParameters()[1]);
            }
            return Util.not((Script)script, (Term)term);
        }
        return Util.not((Script)script, (Term)term);
    }

    public static Term implies(Script script, Term lhs, Term rhs) {
        return SmtUtils.or(script, SmtUtils.not(script, lhs), rhs);
    }

    public static Term equality(Script script, Term ... params) {
        if (params.length == 2) {
            return SmtUtils.binaryEquality(script, params[0], params[1]);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(params));
    }

    public static Term binaryEquality(Script script, Term lhs, Term rhs) {
        if (lhs == rhs) {
            return script.term("true", new Term[0]);
        }
        if (lhs.getSort().isNumericSort()) {
            return SmtUtils.numericEquality(script, lhs, rhs);
        }
        if (SmtSortUtils.isBoolSort(lhs.getSort())) {
            return SmtUtils.booleanEquality(script, lhs, rhs);
        }
        if (SmtSortUtils.isBitvecSort(lhs.getSort())) {
            return SmtUtils.bitvectorEquality(script, lhs, rhs);
        }
        if (SmtSortUtils.isArraySort(lhs.getSort())) {
            return SmtUtils.arrayEquality(script, lhs, rhs);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(lhs, rhs));
    }

    public static Term distinct(Script script, Term lhs, Term rhs) {
        return SmtUtils.not(script, SmtUtils.binaryEquality(script, lhs, rhs));
    }

    private static Term booleanEquality(Script script, Term lhs, Term rhs) {
        if (SmtUtils.isTrueLiteral(lhs)) {
            return rhs;
        }
        if (SmtUtils.isFalseLiteral(lhs)) {
            return SmtUtils.not(script, rhs);
        }
        if (SmtUtils.isTrueLiteral(rhs)) {
            return lhs;
        }
        if (SmtUtils.isFalseLiteral(rhs)) {
            return SmtUtils.not(script, lhs);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(lhs, rhs));
    }

    private static Term bitvectorEquality(Script script, Term lhs, Term rhs) {
        if (!SmtSortUtils.isBitvecSort(lhs.getSort())) {
            throw new UnsupportedOperationException("need BitVec sort");
        }
        if (!SmtSortUtils.isBitvecSort(rhs.getSort())) {
            throw new UnsupportedOperationException("need BitVec sort");
        }
        return PolynomialRelation.of(script, RelationSymbol.EQ, lhs, rhs).positiveNormalForm(script);
    }

    private static Term numericEquality(Script script, Term lhs, Term rhs) {
        if (!lhs.getSort().isNumericSort()) {
            throw new UnsupportedOperationException("need numeric sort");
        }
        if (!rhs.getSort().isNumericSort()) {
            throw new UnsupportedOperationException("need numeric sort");
        }
        return PolynomialRelation.of(script, RelationSymbol.EQ, lhs, rhs).positiveNormalForm(script);
    }

    private static Term arrayEquality(Script script, Term lhs, Term rhs) {
        ApplicationTerm appRhs;
        ApplicationTerm appLhs;
        if (!lhs.getSort().isArraySort()) {
            throw new UnsupportedOperationException("need array sort");
        }
        if (!rhs.getSort().isArraySort()) {
            throw new UnsupportedOperationException("need array sort");
        }
        if (lhs instanceof ApplicationTerm && "store".equals((appLhs = (ApplicationTerm)lhs).getFunction().getName()) && appLhs.getParameters()[0] == rhs) {
            return SmtUtils.setArrayCellValue(script, appLhs.getParameters()[0], appLhs.getParameters()[1], appLhs.getParameters()[2]);
        }
        if (rhs instanceof ApplicationTerm && "store".equals((appRhs = (ApplicationTerm)rhs).getFunction().getName()) && appRhs.getParameters()[0] == lhs) {
            return SmtUtils.setArrayCellValue(script, appRhs.getParameters()[0], appRhs.getParameters()[1], appRhs.getParameters()[2]);
        }
        return script.term("=", CommuhashUtils.sortByHashCode(lhs, rhs));
    }

    private static Term setArrayCellValue(Script script, Term array, Term index, Term value) {
        Term select = SmtUtils.select(script, array, index);
        return SmtUtils.binaryEquality(script, select, value);
    }

    public static String removeSmtQuoteCharacters(String string) {
        return string.replaceAll("\\|", "");
    }

    public static Map<TermVariable, Term> termVariables2Constants(Script script, Collection<TermVariable> termVariables, boolean declareConstants) {
        HashMap<TermVariable, Term> mapping = new HashMap<TermVariable, Term>();
        for (TermVariable tv : termVariables) {
            Term constant = SmtUtils.termVariable2constant(script, tv, declareConstants);
            mapping.put(tv, constant);
        }
        return mapping;
    }

    public static Term termVariable2constant(Script script, TermVariable tv, boolean declareConstant) {
        String name = SmtUtils.removeSmtQuoteCharacters(tv.getName());
        if (declareConstant) {
            Sort resultSort = tv.getSort();
            script.declareFun(name, new Sort[0], resultSort);
        }
        return script.term(name, new Term[0]);
    }

    public static boolean containsFunctionApplication(Term term, String functionName) {
        return !SmtUtils.extractApplicationTerms(functionName, term, true).isEmpty();
    }

    public static boolean containsFunctionApplication(Term term, Collection<String> functionNames) {
        return functionNames.stream().anyMatch(x -> SmtUtils.containsFunctionApplication(term, x));
    }

    public static boolean containsArrayVariables(Term ... terms) {
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            TermVariable[] termVariableArray = term.getFreeVars();
            int n3 = termVariableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TermVariable tv = termVariableArray[n4];
                if (tv.getSort().isArraySort()) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isArrayFree(Term term) {
        return !SmtUtils.containsArrayVariables(term) && !SmtUtils.containsFunctionApplication(term, Arrays.asList("select", "store"));
    }

    public static boolean containsUninterpretedFunctionApplication(Term term) {
        for (NonTheorySymbol<?> s : new NonTheorySymbolFinder().findNonTheorySymbols(term)) {
            if (!(s instanceof NonTheorySymbol.Function)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFalseLiteral(Term term) {
        return SmtUtils.isLiteral("false", term);
    }

    public static boolean isTrueLiteral(Term term) {
        return SmtUtils.isLiteral("true", term);
    }

    private static boolean isLiteral(String literal, Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol fun = appTerm.getFunction();
            return fun.getParameterSorts().length == 0 && literal.equals(fun.getApplicationString());
        }
        return false;
    }

    public static boolean isConstant(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            return appTerm.getParameters().length == 0 && !appTerm.getFunction().isIntern();
        }
        return false;
    }

    public static boolean isIntegerLiteral(BigInteger number, Term term) {
        if (term instanceof ConstantTerm && SmtSortUtils.isIntSort(term.getSort())) {
            Object value = ((ConstantTerm)term).getValue();
            if (value instanceof Rational) {
                return value.equals(Rational.valueOf((BigInteger)number, (BigInteger)BigInteger.ONE));
            }
            if (value instanceof BigInteger) {
                return value.equals(number);
            }
            throw new AssertionError((Object)("unknown type of integer value " + value.getClass().getSimpleName()));
        }
        return false;
    }

    public static boolean isAtomicFormula(Term term) {
        if (SmtSortUtils.isBoolSort(term.getSort())) {
            if (SmtUtils.isTrueLiteral(term) || SmtUtils.isFalseLiteral(term)) {
                return true;
            }
            if (term instanceof TermVariable || SmtUtils.isConstant(term)) {
                return true;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                return !NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(appTerm);
            }
        }
        return false;
    }

    public static boolean isNNF(Term term) {
        for (String f : Arrays.asList("=", "=>", "xor", "distinct", "ite")) {
            for (Term t : SmtUtils.extractApplicationTerms(f, term, true)) {
                if (!SmtUtils.allParamsAreBool((ApplicationTerm)t)) continue;
                return false;
            }
        }
        for (Term t : SmtUtils.extractApplicationTerms("not", term, true)) {
            if (SmtUtils.isAtomicFormula(((ApplicationTerm)t).getParameters()[0])) continue;
            return false;
        }
        return true;
    }

    public static Set<TermVariable> getFreeVars(Collection<Term> terms) {
        HashSet<TermVariable> freeVars = new HashSet<TermVariable>();
        for (Term term : terms) {
            freeVars.addAll(Arrays.asList(term.getFreeVars()));
        }
        return freeVars;
    }

    public static Term and(Script script, Term ... terms) {
        return SmtUtils.andWithExtendedLocalSimplification(script, Arrays.asList(terms));
    }

    public static Term and(Script script, Collection<Term> terms) {
        return SmtUtils.andWithExtendedLocalSimplification(script, terms);
    }

    public static Term or(Script script, Term ... terms) {
        return SmtUtils.orWithExtendedLocalSimplification(script, Arrays.asList(terms));
    }

    public static Term or(Script script, Collection<Term> terms) {
        return SmtUtils.orWithExtendedLocalSimplification(script, terms);
    }

    public static Term andWithExtendedLocalSimplification(Script script, Term ... terms) {
        return SmtUtils.andWithExtendedLocalSimplification(script, Arrays.asList(terms));
    }

    public static Term andWithExtendedLocalSimplification(Script script, Collection<Term> terms) {
        Predicate<Term> isNeutral = SmtUtils::isTrueLiteral;
        Predicate<Term> isAbsorbing = SmtUtils::isFalseLiteral;
        HashSet<Term> resultJuncts = new HashSet<Term>();
        HashSet<Term> negativeJuncts = new HashSet<Term>();
        InnerDualJunctTracker idjt = new InnerDualJunctTracker();
        boolean resultIsAbsorbingElement = SmtUtils.recursiveAndOrSimplificationHelper(script, "and", isNeutral, isAbsorbing, terms, resultJuncts, negativeJuncts, idjt);
        if (resultIsAbsorbingElement) {
            return script.term("false", new Term[0]);
        }
        if (resultJuncts.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        if (resultJuncts.size() == 1) {
            return (Term)resultJuncts.iterator().next();
        }
        return script.term("and", CommuhashUtils.sortByHashCode(resultJuncts.toArray(new Term[resultJuncts.size()])));
    }

    private static Term applyDistributivity(Script script, Set<Term> dualJunctions, String outerConnective, Set<Term> omnipresentInnerDualJuncts) {
        String innerConnective = QuantifierUtils.getDualBooleanConnective(outerConnective);
        Term[] resultDualJunctions = new Term[dualJunctions.size()];
        int outerOffset = 0;
        for (Term dualJunction : dualJunctions) {
            Term[] innerDualJuncts = QuantifierUtils.getXjunctsInner(QuantifierUtils.getCorrespondingQuantifier(outerConnective), dualJunction);
            Term[] remainingInnerDualJuncts = new Term[innerDualJuncts.length - omnipresentInnerDualJuncts.size()];
            int offset = 0;
            Term[] termArray = innerDualJuncts;
            int n = innerDualJuncts.length;
            int n2 = 0;
            while (n2 < n) {
                Term innerDualJunct = termArray[n2];
                if (!omnipresentInnerDualJuncts.contains(innerDualJunct)) {
                    remainingInnerDualJuncts[offset] = innerDualJunct;
                    ++offset;
                }
                ++n2;
            }
            if (remainingInnerDualJuncts.length == 0) {
                throw new AssertionError((Object)"optimization!!");
            }
            resultDualJunctions[outerOffset] = remainingInnerDualJuncts.length == 1 ? remainingInnerDualJuncts[0] : script.term(innerConnective, remainingInnerDualJuncts);
            ++outerOffset;
        }
        Term resultInnerDistributed = script.term(outerConnective, resultDualJunctions);
        ArrayList<Term> resultOuter = new ArrayList<Term>(omnipresentInnerDualJuncts.size() + 1);
        resultOuter.addAll(omnipresentInnerDualJuncts);
        resultOuter.add(resultInnerDistributed);
        return script.term(innerConnective, resultOuter.toArray(new Term[resultOuter.size()]));
    }

    public static Term orWithExtendedLocalSimplification(Script script, Collection<Term> terms) {
        Predicate<Term> isNeutral = SmtUtils::isFalseLiteral;
        Predicate<Term> isAbsorbing = SmtUtils::isTrueLiteral;
        HashSet<Term> resultJuncts = new HashSet<Term>();
        HashSet<Term> negativeJuncts = new HashSet<Term>();
        InnerDualJunctTracker idjt = new InnerDualJunctTracker();
        boolean resultIsAbsorbingElement = SmtUtils.recursiveAndOrSimplificationHelper(script, "or", isNeutral, isAbsorbing, terms, resultJuncts, negativeJuncts, idjt);
        if (resultIsAbsorbingElement) {
            return script.term("true", new Term[0]);
        }
        if (resultJuncts.isEmpty()) {
            return script.term("false", new Term[0]);
        }
        if (resultJuncts.size() == 1) {
            return (Term)resultJuncts.iterator().next();
        }
        return script.term("or", CommuhashUtils.sortByHashCode(resultJuncts.toArray(new Term[resultJuncts.size()])));
    }

    private static boolean recursiveAndOrSimplificationHelper(Script script, String connective, Predicate<Term> isNeutral, Predicate<Term> isAbsorbing, Collection<Term> inputJuncts, Set<Term> resultJuncts, Set<Term> negatedJuncts, InnerDualJunctTracker idjt) {
        for (Term junct : inputJuncts) {
            if (isNeutral.test(junct)) continue;
            if (isAbsorbing.test(junct)) {
                return true;
            }
            if (junct instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)junct;
                if (appTerm.getFunction().getName().equals(connective)) {
                    boolean resultIsAbsorbingElement = SmtUtils.recursiveAndOrSimplificationHelper(script, connective, isNeutral, isAbsorbing, Arrays.asList(appTerm.getParameters()), resultJuncts, negatedJuncts, idjt);
                    if (!resultIsAbsorbingElement) continue;
                    return true;
                }
                if ("not".equals(appTerm.getFunction().getName())) {
                    if (resultJuncts.contains(appTerm.getParameters()[0])) {
                        return true;
                    }
                    negatedJuncts.add(appTerm.getParameters()[0]);
                }
            }
            if (negatedJuncts.contains(junct)) {
                return true;
            }
            resultJuncts.add(junct);
            idjt.addOuterJunct(junct, connective);
        }
        return false;
    }

    public static Term ite(Script script, Term cond, Term thenPart, Term elsePart) {
        if (SmtUtils.isTrueLiteral(cond) || thenPart == elsePart) {
            return thenPart;
        }
        if (SmtUtils.isFalseLiteral(cond)) {
            return elsePart;
        }
        if (SmtUtils.isTrueLiteral(thenPart)) {
            return SmtUtils.or(script, cond, elsePart);
        }
        if (SmtUtils.isFalseLiteral(elsePart)) {
            return SmtUtils.and(script, cond, thenPart);
        }
        if (SmtUtils.isFalseLiteral(thenPart)) {
            return SmtUtils.and(script, SmtUtils.not(script, cond), elsePart);
        }
        if (SmtUtils.isTrueLiteral(elsePart)) {
            return SmtUtils.or(script, SmtUtils.not(script, cond), thenPart);
        }
        return script.term("ite", new Term[]{cond, thenPart, elsePart});
    }

    public static Term leq(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "<=", lhs, rhs);
    }

    public static Term geq(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, ">=", lhs, rhs);
    }

    public static Term less(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "<", lhs, rhs);
    }

    public static Term greater(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, ">", lhs, rhs);
    }

    public static Term bvule(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvule", lhs, rhs);
    }

    public static Term bvult(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvult", lhs, rhs);
    }

    public static Term bvuge(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvuge", lhs, rhs);
    }

    public static Term bvugt(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvugt", lhs, rhs);
    }

    public static Term bvsle(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvsle", lhs, rhs);
    }

    public static Term bvslt(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvslt", lhs, rhs);
    }

    public static Term bvsge(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvsge", lhs, rhs);
    }

    public static Term bvsgt(Script script, Term lhs, Term rhs) {
        return SmtUtils.comparison(script, "bvsgt", lhs, rhs);
    }

    private static Term comparison(Script script, String functionSymbol, Term lhs, Term rhs) {
        RelationSymbol rel = RelationSymbol.convert(functionSymbol);
        if (rel == null) {
            throw new AssertionError((Object)("Unknown RelationSymbol" + functionSymbol));
        }
        if (!rel.isConvexInequality()) {
            throw new AssertionError((Object)("Not a comparison " + functionSymbol));
        }
        if (lhs == rhs) {
            if (rel.isStrictRelation()) {
                return script.term("false", new Term[0]);
            }
            return script.term("true", new Term[0]);
        }
        if (SmtSortUtils.isNumericSort(lhs.getSort())) {
            return PolynomialRelation.of(script, RelationSymbol.convert(functionSymbol), lhs, rhs).positiveNormalForm(script);
        }
        assert (SmtSortUtils.isBitvecSort(lhs.getSort()));
        return script.term(functionSymbol, new Term[]{lhs, rhs});
    }

    public static ApplicationTerm buildNewConstant(Script script, String name, String sortname) {
        script.declareFun(name, new Sort[0], script.sort(sortname, new Sort[0]));
        return (ApplicationTerm)script.term(name, new Term[0]);
    }

    public static Term convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs, Script script) {
        Term[] oldArgs = appTerm.getParameters();
        Object result = oldArgs == newArgs ? appTerm : SmtUtils.termWithLocalSimplification(script, appTerm.getFunction(), newArgs);
        return result;
    }

    public static Term termWithLocalSimplification(Script script, FunctionSymbol fun, Term ... params) {
        Sort resultSort = fun.isReturnOverload() ? fun.getReturnSort() : null;
        return SmtUtils.termWithLocalSimplification(script, fun.getName(), fun.getIndices(), resultSort, params);
    }

    public static Term termWithLocalSimplification(Script script, String funcname, String[] indices, Sort resultSort, Term ... params) {
        Term result;
        switch (funcname) {
            case "and": {
                result = SmtUtils.and(script, params);
                break;
            }
            case "or": {
                result = SmtUtils.or(script, params);
                break;
            }
            case "not": {
                if (params.length != 1) {
                    throw new IllegalArgumentException("no not term");
                }
                result = SmtUtils.not(script, params[0]);
                break;
            }
            case "=": {
                if (params.length != 2) {
                    throw new UnsupportedOperationException("not yet implemented: equality with " + params.length + " params");
                }
                result = SmtUtils.binaryEquality(script, params[0], params[1]);
                break;
            }
            case "distinct": {
                if (params.length != 2) {
                    throw new UnsupportedOperationException("not yet implemented: distinct with " + params.length + " params");
                }
                result = SmtUtils.distinct(script, params[0], params[1]);
                break;
            }
            case "=>": {
                result = Util.implies((Script)script, (Term[])params);
                break;
            }
            case "ite": {
                if (params.length != 3) {
                    throw new IllegalArgumentException("no ite");
                }
                result = SmtUtils.ite(script, params[0], params[1], params[2]);
                break;
            }
            case "+": 
            case "bvadd": {
                result = SmtUtils.sum(script, funcname, params);
                break;
            }
            case "-": 
            case "bvsub": {
                if (params.length == 1) {
                    assert (!funcname.equals("bvsub"));
                    result = SmtUtils.unaryNumericMinus(script, params[0]);
                    break;
                }
                result = SmtUtils.minus(script, params);
                break;
            }
            case "*": 
            case "bvmul": {
                result = SmtUtils.mul(script, funcname, params);
                break;
            }
            case "div": {
                if (params.length != 2) {
                    throw new IllegalArgumentException("no div");
                }
                result = SmtUtils.div(script, params[0], params[1]);
                break;
            }
            case "mod": {
                if (params.length != 2) {
                    throw new IllegalArgumentException("no mod");
                }
                result = SmtUtils.mod(script, params[0], params[1]);
                break;
            }
            case "<": 
            case ">": 
            case "<=": 
            case ">=": {
                if (params.length != 2) {
                    throw new IllegalArgumentException("no comparison");
                }
                result = SmtUtils.comparison(script, funcname, params[0], params[1]);
                break;
            }
            case "store": {
                result = SmtUtils.store(script, params[0], params[1], params[2]);
                break;
            }
            case "select": {
                result = SmtUtils.select(script, params[0], params[1]);
                break;
            }
            case "bvashr": 
            case "bvlshr": 
            case "bvsdiv": 
            case "bvsmod": 
            case "bvsrem": 
            case "bvudiv": 
            case "bvurem": 
            case "extract": 
            case "zero_extend": 
            case "bvor": 
            case "bvand": 
            case "bvneg": 
            case "bvnot": 
            case "bvsge": 
            case "bvsgt": 
            case "bvshl": 
            case "bvsle": 
            case "bvslt": 
            case "bvuge": 
            case "bvugt": 
            case "bvule": 
            case "bvult": 
            case "bvxor": {
                result = BitvectorUtils.termWithLocalSimplification(script, funcname, SmtUtils.toBigIntegerArray(indices), params);
                break;
            }
            default: {
                result = script.term(funcname, indices, resultSort, params);
            }
        }
        return result;
    }

    public static Term select(Script script, Term array, Term index) {
        ArrayStore as = ArrayStore.convert(array);
        Term result = as != null ? SmtUtils.selectOverStore(script, as, index) : script.term("select", new Term[]{array, index});
        return result;
    }

    private static Term selectOverStore(Script script, ArrayStore as, Term index) {
        Term result;
        if (as.getIndex().equals(index)) {
            result = as.getValue();
        } else {
            IPolynomialTerm selectIndex = PolynomialTermTransformer.convert(script, index);
            IPolynomialTerm storeIndex = PolynomialTermTransformer.convert(script, as.getIndex());
            if (selectIndex == null || storeIndex == null) {
                result = script.term("select", new Term[]{as.asTerm(), index});
            } else {
                AbstractGeneralizedAffineTerm.Equivalence comparison = selectIndex.compare(storeIndex);
                switch (comparison) {
                    case DISTINCT: {
                        result = SmtUtils.select(script, as.getArray(), index);
                        break;
                    }
                    case EQUALS: {
                        result = as.getValue();
                        break;
                    }
                    case INCOMPARABLE: {
                        result = script.term("select", new Term[]{as.asTerm(), index});
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown value " + (Object)((Object)comparison)));
                    }
                }
            }
        }
        return result;
    }

    public static Term store(Script script, Term array, Term index, Term value) {
        Term result;
        Term nestedIdx = SmtUtils.getArrayStoreIdx(array);
        if (nestedIdx != null) {
            if (nestedIdx.equals(index)) {
                ApplicationTerm appArray = (ApplicationTerm)array;
                result = script.term("store", new Term[]{appArray.getParameters()[0], index, value});
            } else {
                result = script.term("store", new Term[]{array, index, value});
            }
        } else {
            result = script.term("store", new Term[]{array, index, value});
        }
        return result;
    }

    public static Term getArrayStoreIdx(Term array) {
        ApplicationTerm appArray;
        FunctionSymbol arrayFunc;
        if (array instanceof ApplicationTerm && (arrayFunc = (appArray = (ApplicationTerm)array).getFunction()).isIntern() && "store".equals(arrayFunc.getName())) {
            return appArray.getParameters()[1];
        }
        return null;
    }

    public static Term getBasicArrayTerm(Term possiblyComplexArrayTerm) {
        assert (possiblyComplexArrayTerm.getSort().isArraySort());
        Term result = possiblyComplexArrayTerm;
        while (SmtUtils.isFunctionApplication(result, "store") || SmtUtils.isFunctionApplication(result, "select")) {
            result = ((ApplicationTerm)result).getParameters()[0];
        }
        assert (result.getSort().isArraySort());
        assert (result instanceof TermVariable || result instanceof ConstantTerm || SmtUtils.isConstant(result));
        return result;
    }

    public static boolean isBasicArrayTerm(Term term) {
        ApplicationTerm at;
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (term instanceof ApplicationTerm && (at = (ApplicationTerm)term).getParameters().length > 0) {
            return false;
        }
        assert (term instanceof ApplicationTerm || term instanceof TermVariable || term instanceof ConstantTerm);
        return true;
    }

    public static String sanitizeStringAsSmtIdentifier(String name) {
        return name.replaceAll("\\|", "BAR").replaceAll(" ", "_");
    }

    public static Term div(Script script, Term dividend, Term divisor) {
        if (dividend instanceof ConstantTerm && dividend.getSort().isNumericSort() && divisor instanceof ConstantTerm && divisor.getSort().isNumericSort()) {
            Rational dividentAsRational = SmtUtils.toRational((ConstantTerm)dividend);
            Rational divisorAsRational = SmtUtils.toRational((ConstantTerm)divisor);
            Rational quotientAsRational = dividentAsRational.div(divisorAsRational);
            Rational result = divisorAsRational.isNegative() ? quotientAsRational.ceil() : quotientAsRational.floor();
            return result.toTerm(dividend.getSort());
        }
        return script.term("div", new Term[]{dividend, divisor});
    }

    public static Term abs(Script script, Term operand) {
        if (operand instanceof ConstantTerm && SmtSortUtils.isIntSort(operand.getSort())) {
            Rational operandAsRational = SmtUtils.toRational((ConstantTerm)operand);
            return operandAsRational.abs().toTerm(operand.getSort());
        }
        return script.term("abs", new Term[]{operand});
    }

    public static Term divReal(Script script, Term ... inputParams) {
        ArrayList<Term> resultParams = new ArrayList<Term>();
        if (inputParams.length == 0) {
            throw new IllegalArgumentException("real division needs at least one argument");
        }
        resultParams.add(inputParams[0]);
        int i = 1;
        while (i < inputParams.length) {
            Rational nextAsRational = SmtUtils.tryToConvertToLiteral(inputParams[i]);
            if (nextAsRational == null) {
                resultParams.add(inputParams[i]);
            } else if (nextAsRational.numerator() == BigInteger.ZERO) {
                resultParams.add(inputParams[i]);
            } else if (nextAsRational.numerator() != BigInteger.ONE || !nextAsRational.isIntegral()) {
                Rational tmp;
                Object lastSimplifiedParam = resultParams.isEmpty() ? null : ((tmp = SmtUtils.tryToConvertToLiteral((Term)resultParams.get(resultParams.size() - 1))) == null ? null : (!tmp.numerator().equals(BigInteger.ZERO) || resultParams.size() == 1 ? tmp : null));
                if (lastSimplifiedParam != null) {
                    Rational resultRat = resultParams.size() == 1 ? lastSimplifiedParam.div(nextAsRational) : lastSimplifiedParam.mul(nextAsRational);
                    Term resultTerm = resultRat.toTerm(SmtSortUtils.getRealSort(script));
                    resultParams.set(resultParams.size() - 1, resultTerm);
                } else {
                    resultParams.add(inputParams[i]);
                }
            }
            ++i;
        }
        if (resultParams.size() == 1) {
            return (Term)resultParams.get(0);
        }
        return script.term("/", resultParams.toArray(new Term[resultParams.size()]));
    }

    public static Term divInt(Script script, Term ... inputParams) {
        ArrayList<Term> resultParams = new ArrayList<Term>();
        boolean simplificationPossible = true;
        if (inputParams.length == 0) {
            throw new IllegalArgumentException("int division needs at least one argument");
        }
        resultParams.add(inputParams[0]);
        int i = 1;
        while (i < inputParams.length) {
            Rational nextAsRational;
            if (simplificationPossible) {
                nextAsRational = SmtUtils.tryToConvertToLiteral(inputParams[i]);
                if (nextAsRational == null) {
                    resultParams.add(inputParams[i]);
                    simplificationPossible = false;
                } else if (nextAsRational.numerator() == BigInteger.ZERO) {
                    resultParams.add(inputParams[i]);
                    simplificationPossible = false;
                } else if (nextAsRational.numerator() != BigInteger.ONE || !nextAsRational.isIntegral()) {
                    Rational numerator = SmtUtils.tryToConvertToLiteral((Term)resultParams.get(0));
                    if (numerator == null) {
                        resultParams.add(inputParams[i]);
                        simplificationPossible = false;
                    } else {
                        if (!numerator.isIntegral() || !nextAsRational.isIntegral()) {
                            throw new AssertionError((Object)"no integers");
                        }
                        BigInteger div = ArithmeticUtils.euclideanDiv((BigInteger)numerator.numerator(), (BigInteger)nextAsRational.numerator());
                        Term resultTerm = SmtUtils.rational2Term(script, Rational.valueOf((BigInteger)div, (BigInteger)BigInteger.ONE), ((Term)resultParams.get(0)).getSort());
                        resultParams.set(0, resultTerm);
                    }
                }
            } else {
                nextAsRational = SmtUtils.tryToConvertToLiteral(inputParams[i]);
                if (nextAsRational == null) {
                    resultParams.add(inputParams[i]);
                } else if (nextAsRational.numerator() != BigInteger.ONE) {
                    resultParams.add(inputParams[i]);
                }
            }
            ++i;
        }
        if (resultParams.size() == 1) {
            return (Term)resultParams.get(0);
        }
        return script.term("div", resultParams.toArray(new Term[resultParams.size()]));
    }

    public static Term division(Script script, Sort sort, Term ... params) {
        if (SmtSortUtils.isRealSort(sort)) {
            return SmtUtils.divReal(script, params);
        }
        if (SmtSortUtils.isIntSort(sort)) {
            return SmtUtils.divInt(script, params);
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            throw new UnsupportedOperationException("Division with simplifications for bitvectors is not yet supported");
        }
        if (SmtSortUtils.isFloatingpointSort(sort)) {
            throw new UnsupportedOperationException("Division with simplifications for floats is not yet supported");
        }
        throw new AssertionError((Object)("Division does not make sense for sort " + sort));
    }

    public static Term mod(Script script, Term divident, Term divisor) {
        AffineTerm affineDivident = (AffineTerm)new AffineTermTransformer(script).transform(divident);
        AffineTerm affineDivisor = (AffineTerm)new AffineTermTransformer(script).transform(divisor);
        if (affineDivident.isErrorTerm() || affineDivisor.isErrorTerm()) {
            return script.term("mod", new Term[]{divident, divisor});
        }
        if (affineDivisor.isZero()) {
            return script.term("mod", new Term[]{divident, divisor});
        }
        if (affineDivisor.isConstant()) {
            BigInteger bigIntDivisor = SmtUtils.toInt(affineDivisor.getConstant()).abs();
            if (affineDivident.isConstant()) {
                BigInteger bigIntDivident = SmtUtils.toInt(affineDivident.getConstant());
                BigInteger modulus = ArithmeticUtils.euclideanMod((BigInteger)bigIntDivident, (BigInteger)bigIntDivisor);
                return SmtUtils.constructIntValue(script, modulus);
            }
            Term simplifiedNestedModulo = SmtUtils.simplifyNestedModulo(script, divident, bigIntDivisor);
            if (simplifiedNestedModulo != null) {
                return simplifiedNestedModulo;
            }
            AffineTerm moduloApplied = AffineTerm.applyModuloToAllCoefficients(script, affineDivident, bigIntDivisor);
            return script.term("mod", new Term[]{moduloApplied.toTerm(script), affineDivisor.getConstant().abs().toTerm(affineDivisor.getSort())});
        }
        return script.term("mod", new Term[]{affineDivident.toTerm(script), affineDivisor.toTerm(script)});
    }

    private static Term simplifyNestedModulo(Script script, Term divident, BigInteger bigIntDivisor) {
        BigInteger bigIntInnerDivisor;
        Term innerDivident;
        AffineTerm affineInnerDivisor;
        ApplicationTerm appTerm;
        if (divident instanceof ApplicationTerm && "mod".equals((appTerm = (ApplicationTerm)divident).getFunction().getApplicationString()) && !(affineInnerDivisor = (AffineTerm)new AffineTermTransformer(script).transform(innerDivident = appTerm.getParameters()[1])).isErrorTerm() && affineInnerDivisor.isConstant() && ((bigIntInnerDivisor = SmtUtils.toInt(affineInnerDivisor.getConstant()).abs()).mod(bigIntDivisor).equals(BigInteger.ZERO) || bigIntDivisor.mod(bigIntInnerDivisor).equals(BigInteger.ZERO))) {
            BigInteger min = bigIntInnerDivisor.min(bigIntDivisor);
            Term innerDivisor = appTerm.getParameters()[0];
            return SmtUtils.mod(script, innerDivisor, SmtUtils.constructIntValue(script, min));
        }
        return null;
    }

    public static Optional<BigDecimal> toDecimal(Rational rational) {
        if (!rational.isRational()) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(rational.numerator()).divide(new BigDecimal(rational.denominator())));
    }

    public static BigInteger toInt(Rational integralRational) {
        if (!integralRational.isIntegral()) {
            throw new IllegalArgumentException("dividend has to be integral");
        }
        if (!integralRational.denominator().equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("denominator has to be zero");
        }
        return integralRational.numerator();
    }

    public static Rational toRational(String realLiteralValue) {
        String[] twoParts = realLiteralValue.split("/");
        if (twoParts.length == 2) {
            return Rational.valueOf((BigInteger)new BigInteger(twoParts[0]), (BigInteger)new BigInteger(twoParts[1]));
        }
        if (twoParts.length == 1) {
            return SmtUtils.toRational(new BigDecimal(realLiteralValue));
        }
        throw new IllegalArgumentException("Not a valid real literal value: " + realLiteralValue);
    }

    public static Term rational2Term(Script script, Rational rational, Sort sort) {
        if (SmtSortUtils.isNumericSort(sort)) {
            return rational.toTerm(sort);
        }
        if (!SmtSortUtils.isBitvecSort(sort)) {
            throw new AssertionError((Object)(ERROR_MSG_UNKNOWN_SORT + sort));
        }
        if (rational.isIntegral() && rational.isRational()) {
            return BitvectorUtils.constructTerm(script, rational.numerator(), sort);
        }
        throw new IllegalArgumentException("unable to convert rational to bitvector if not integer");
    }

    public static Rational tryToConvertToLiteral(Term term) {
        BitvectorConstant bc;
        Rational result = SmtSortUtils.isBitvecSort(term.getSort()) ? ((bc = BitvectorUtils.constructBitvectorConstant(term)) != null ? Rational.valueOf((BigInteger)bc.getValue(), (BigInteger)BigInteger.ONE) : null) : (SmtSortUtils.isNumericSort(term.getSort()) ? (term instanceof ConstantTerm ? SmtUtils.toRational((ConstantTerm)term) : null) : null);
        return result;
    }

    public static Script.LBool checkSatDebug(Script script, Term term, ILogger logger) {
        script.push(1);
        try {
            TermVariable[] vars = term.getFreeVars();
            HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
            TermVariable[] termVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable var = termVariableArray[n2];
                Term substituent = SmtUtils.termVariable2PseudofreshConstant(script, var);
                substitutionMapping.put(var, substituent);
                ++n2;
            }
            HashMap<Term, Term> ucMapping = new HashMap<Term, Term>();
            Term[] conjuncts = SmtUtils.getConjuncts(term);
            int i = 0;
            while (i < conjuncts.length) {
                Term conjunct = new PureSubstitution(script, substitutionMapping).transform(conjuncts[i]);
                String name = "conjunct" + i;
                Annotation annot = new Annotation(":named", (Object)name);
                Term annotTerm = script.annotate(conjunct, new Annotation[]{annot});
                ucMapping.put(script.term(name, new Term[0]), conjuncts[i]);
                script.assertTerm(annotTerm);
                ++i;
            }
            Script.LBool result = script.checkSat();
            if (result == Script.LBool.UNSAT) {
                Term[] ucTerms;
                Term[] termArray = ucTerms = script.getUnsatCore();
                int n3 = ucTerms.length;
                int n4 = 0;
                while (n4 < n3) {
                    Term ucTerm = termArray[n4];
                    Term conjunct = (Term)ucMapping.get(ucTerm);
                    logger.debug((Object)("in uc: " + conjunct));
                    ++n4;
                }
            }
            script.pop(1);
            return result;
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Exception during satisfiablity check: " + e.getMessage()));
        }
    }

    private static Term termVariable2PseudofreshConstant(Script script, TermVariable tv) {
        String name = String.valueOf(tv.getName()) + "_const_" + tv.hashCode();
        Sort resultSort = tv.getSort();
        script.declareFun(name, new Sort[0], resultSort);
        return script.term(name, new Term[0]);
    }

    public static Rational toRational(ConstantTerm constTerm) {
        assert (SmtSortUtils.isNumericSort(constTerm.getSort()));
        Object value = constTerm.getValue();
        if (SmtSortUtils.isIntSort(constTerm.getSort())) {
            if (value instanceof BigInteger) {
                return Rational.valueOf((BigInteger)((BigInteger)value), (BigInteger)BigInteger.ONE);
            }
            if (value instanceof Rational) {
                return (Rational)value;
            }
        } else if (SmtSortUtils.isRealSort(constTerm.getSort())) {
            if (value instanceof BigDecimal) {
                return SmtUtils.toRational((BigDecimal)value);
            }
            if (value instanceof Rational) {
                return (Rational)value;
            }
            if (value instanceof BigInteger) {
                return SmtUtils.toRational((BigInteger)value);
            }
        }
        throw new UnsupportedOperationException("Cannot convert " + constTerm.toStringDirect() + " to Rational");
    }

    public static boolean occursAtMostAsLhs(TermVariable tv, ApplicationTerm appTerm) {
        if (appTerm.getParameters().length != 2) {
            return !Arrays.asList(appTerm.getFreeVars()).contains(tv);
        }
        if (Arrays.asList(appTerm.getParameters()[1].getFreeVars()).contains(tv)) {
            return false;
        }
        if (appTerm.getParameters()[0].equals(tv)) {
            return true;
        }
        return !Arrays.asList(appTerm.getParameters()[0].getFreeVars()).contains(tv);
    }

    public static Term quantifier(Script script, int quantifier, Collection<TermVariable> vars, Term subformula) {
        LinkedHashMap varMap = new LinkedHashMap();
        Term currentSubformula = subformula;
        Set freeVarsOfCurrentSubformula = Arrays.stream(currentSubformula.getFreeVars()).collect(Collectors.toSet());
        vars.stream().filter(freeVarsOfCurrentSubformula::contains).forEach(x -> {
            TermVariable termVariable = varMap.put(x.getName(), x);
        });
        while (currentSubformula instanceof QuantifiedFormula && ((QuantifiedFormula)currentSubformula).getQuantifier() == quantifier) {
            QuantifiedFormula qf = (QuantifiedFormula)currentSubformula;
            currentSubformula = qf.getSubformula();
            freeVarsOfCurrentSubformula = Arrays.stream(currentSubformula.getFreeVars()).collect(Collectors.toSet());
            Arrays.stream(qf.getVariables()).filter(freeVarsOfCurrentSubformula::contains).forEach(x -> {
                TermVariable termVariable = varMap.put(x.getName(), x);
            });
        }
        if (varMap.isEmpty()) {
            return subformula;
        }
        TermVariable[] resultVars = (TermVariable[])varMap.entrySet().stream().map(Map.Entry::getValue).toArray(TermVariable[]::new);
        return script.quantifier(quantifier, resultVars, currentSubformula, (Term[][])new Term[0][]);
    }

    public static List<TermVariable> projectToFreeVars(List<TermVariable> vars, Term term) {
        Set freeVars = Arrays.stream(term.getFreeVars()).collect(Collectors.toSet());
        List<TermVariable> result = vars.stream().filter(freeVars::contains).collect(Collectors.toList());
        return result;
    }

    public static Set<TermVariable> projectToFreeVars(Set<TermVariable> vars, Term term) {
        HashSet<TermVariable> result = new HashSet<TermVariable>();
        for (TermVariable tv : Arrays.asList(term.getFreeVars())) {
            if (!vars.contains(tv)) continue;
            result.add(tv);
        }
        return result;
    }

    public static QuantifiedFormula isQuantifiedFormulaWithSameQuantifier(int quant, Term term) {
        QuantifiedFormula quantifiedFormula;
        if (term instanceof QuantifiedFormula && quant == (quantifiedFormula = (QuantifiedFormula)term).getQuantifier()) {
            return quantifiedFormula;
        }
        return null;
    }

    public static Term renameQuantifiedVariables(ManagedScript mgdScript, QuantifiedFormula qFormula, Set<TermVariable> toRename, String freshVarPrefix) {
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (TermVariable var : toRename) {
            TermVariable freshVariable = mgdScript.constructFreshTermVariable(freshVarPrefix, var.getSort());
            substitutionMapping.put(var, freshVariable);
        }
        Term newBody = Substitution.apply(mgdScript, substitutionMapping, qFormula.getSubformula());
        TermVariable[] vars = new TermVariable[qFormula.getVariables().length];
        int i = 0;
        while (i < vars.length) {
            TermVariable renamed = (TermVariable)substitutionMapping.get(qFormula.getVariables()[i]);
            vars[i] = renamed != null ? renamed : qFormula.getVariables()[i];
            ++i;
        }
        Term result = mgdScript.getScript().quantifier(qFormula.getQuantifier(), vars, newBody, (Term[][])new Term[0][]);
        return result;
    }

    public static boolean isFunctionApplication(Term term, String functionName) {
        FunctionSymbol fun;
        return term instanceof ApplicationTerm && (fun = ((ApplicationTerm)term).getFunction()).getName().equals(functionName);
    }

    public static ApplicationTerm getFunctionApplication(Term term, String functionName) {
        ApplicationTerm appTerm;
        if (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName().equals(functionName)) {
            return appTerm;
        }
        return null;
    }

    public static boolean isIntDiv(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        FunctionSymbol fun = ((ApplicationTerm)term).getFunction();
        if (fun.isIntern()) {
            return ((ApplicationTerm)term).getFunction().getName().equals("div");
        }
        return false;
    }

    public static boolean isIntMod(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        FunctionSymbol fun = ((ApplicationTerm)term).getFunction();
        if (fun.isIntern()) {
            return ((ApplicationTerm)term).getFunction().getName().equals("mod");
        }
        return false;
    }

    public static Term toDnf(IUltimateServiceProvider services, ManagedScript mgdScript, Term term, XnfConversionTechnique xnfConversionTechnique) {
        Term result;
        switch (xnfConversionTechnique) {
            case BDD_BASED: {
                result = new SimplifyBdd(services, mgdScript).transformToDNF(term);
                break;
            }
            case BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION: {
                result = new DnfTransformer(mgdScript, services).transform(term);
                break;
            }
            default: {
                throw new AssertionError((Object)(ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT + (Object)((Object)xnfConversionTechnique)));
            }
        }
        return result;
    }

    public static Term toNnf(IUltimateServiceProvider services, ManagedScript mgdScript, Term term) {
        return new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.PULL).transform(term);
    }

    public static Term toCnf(IUltimateServiceProvider services, ManagedScript mgdScript, Term term, XnfConversionTechnique xnfConversionTechnique) {
        Term result;
        switch (xnfConversionTechnique) {
            case BDD_BASED: {
                result = new SimplifyBdd(services, mgdScript).transformToCNF(term);
                break;
            }
            case BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION: {
                result = new CnfTransformer(mgdScript, services).transform(term);
                break;
            }
            default: {
                throw new AssertionError((Object)(ERROR_MESSAGE_UNKNOWN_ENUM_CONSTANT + (Object)((Object)xnfConversionTechnique)));
            }
        }
        return result;
    }

    public static boolean isSortForWhichWeCanGetValues(Sort sort) {
        return SmtSortUtils.isNumericSort(sort) || SmtSortUtils.isBoolSort(sort) || SmtSortUtils.isBitvecSort(sort) || SmtSortUtils.isFloatingpointSort(sort);
    }

    public static Map<Term, Term> getValues(Script script, Collection<Term> terms) {
        if (terms.isEmpty()) {
            return Collections.emptyMap();
        }
        Term[] asArray = terms.toArray(new Term[terms.size()]);
        Map mapFromSolver = script.getValue(asArray);
        HashMap<Term, Term> copyWithNiceValues = new HashMap<Term, Term>();
        for (Map.Entry entry : mapFromSolver.entrySet()) {
            copyWithNiceValues.put((Term)entry.getKey(), SmtUtils.makeAffineIfPossible(script, (Term)entry.getValue()));
        }
        return Collections.unmodifiableMap(copyWithNiceValues);
    }

    private static Term makeAffineIfPossible(Script script, Term term) {
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(script).transform(term);
        if (affineTerm.isErrorTerm()) {
            return term;
        }
        return affineTerm.toTerm(script);
    }

    public static Term constructPositiveNormalForm(Script script, Term term) {
        Term result = new AffineSubtermNormalizer(script).transform(term);
        assert (Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, result})) != Script.LBool.SAT);
        return result;
    }

    public static int getOtherQuantifier(int quantifier) {
        if (quantifier == 0) {
            return 1;
        }
        if (quantifier == 1) {
            return 0;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static String getCorrespondingFiniteConnective(int quantifier) {
        if (quantifier == 0) {
            return "or";
        }
        if (quantifier == 1) {
            return "and";
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public static Term constructIntValue(Script script, BigInteger number) {
        return Rational.valueOf((BigInteger)number, (BigInteger)BigInteger.ONE).toTerm(SmtSortUtils.getIntSort(script));
    }

    public static Term constructIntegerValue(Script script, Sort sort, BigInteger integer) {
        if (SmtSortUtils.isIntSort(sort)) {
            return SmtUtils.constructIntValue(script, integer);
        }
        if (SmtSortUtils.isRealSort(sort)) {
            return script.decimal(new BigDecimal(integer));
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            return BitvectorUtils.constructTerm(script, integer, sort);
        }
        throw new UnsupportedOperationException(ERROR_MSG_UNKNOWN_SORT + sort);
    }

    public static Term filterFormula(Term formula, Set<TermVariable> variables, Script script) {
        Term[] oldConjuncts = SmtUtils.getConjuncts(formula);
        ArrayList<Term> newConjuncts = new ArrayList<Term>(oldConjuncts.length);
        Term[] termArray = oldConjuncts;
        int n = oldConjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term c = termArray[n2];
            HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(c.getFreeVars()));
            if (DataStructureUtils.haveNonEmptyIntersection(freeVars, variables)) {
                newConjuncts.add(c);
            }
            ++n2;
        }
        return SmtUtils.and(script, newConjuncts);
    }

    public static boolean areFormulasEquivalent(Term formula1, Term formula2, Script script) {
        return SmtUtils.checkEquivalence(formula1, formula2, script) == Script.LBool.UNSAT;
    }

    public static Script.LBool checkEquivalence(Term formula1, Term formula2, Script script) {
        Term notEq = script.term("distinct", new Term[]{formula1, formula2});
        return Util.checkSat((Script)script, (Term)notEq);
    }

    public static Script.LBool checkEquivalenceUnderAssumption(Term formula1, Term formula2, Term assumption, Script script) {
        Term eq = SmtUtils.binaryEquality(script, formula1, formula2);
        Term impl = SmtUtils.implies(script, assumption, eq);
        return Util.checkSat((Script)script, (Term)SmtUtils.not(script, impl));
    }

    public static void checkLogicalEquivalenceForDebugging(Script script, Term result, Term input, Class<?> checkedClass, boolean tolerateUnknown) {
        String errorMessage;
        script.echo(new QuotedObject(String.format("Start correctness check for %s.", checkedClass.getSimpleName())));
        Script.LBool lbool = SmtUtils.checkEquivalence(result, input, script);
        script.echo(new QuotedObject(String.format("Finished correctness check for %s. Result: " + lbool, checkedClass.getSimpleName())));
        switch (lbool) {
            case SAT: {
                errorMessage = String.format("%s: Not equivalent to expected result: %s Input: %s", checkedClass.getSimpleName(), result, input);
                break;
            }
            case UNKNOWN: {
                errorMessage = String.format("%s: Insufficient ressources for checking equivalence to expected result: %s Input: %s", checkedClass.getSimpleName(), result, input);
                break;
            }
            case UNSAT: {
                errorMessage = null;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value " + lbool));
            }
        }
        if (lbool == Script.LBool.SAT || !tolerateUnknown && lbool == Script.LBool.UNKNOWN) {
            throw new AssertionError((Object)errorMessage);
        }
    }

    public static boolean areFormulasEquivalent(Term formula1, Term formula2, Term assumption, Script script) {
        Term eq = SmtUtils.binaryEquality(script, formula1, formula2);
        Term impl = SmtUtils.implies(script, assumption, eq);
        return Util.checkSat((Script)script, (Term)SmtUtils.not(script, impl)) == Script.LBool.UNSAT;
    }

    public static int getDimension(Sort sort) {
        int i = 0;
        while (sort.isArraySort()) {
            sort = sort.getArguments()[1];
            ++i;
        }
        return i;
    }

    public static Pair<Script.LBool, Term> interpolateBinary(Script script, Term first, Term second) {
        script.push(1);
        try {
            Term fPart = SmtUtils.annotateAndAssert(script, first, "first");
            Term sPart = SmtUtils.annotateAndAssert(script, second, "second");
            Script.LBool checkSatResult = script.checkSat();
            switch (checkSatResult) {
                case UNSAT: {
                    Term[] interpolants = script.getInterpolants(new Term[]{fPart, sPart});
                    assert (interpolants != null && interpolants.length == 1);
                    Pair pair = new Pair((Object)checkSatResult, (Object)interpolants[0]);
                    return pair;
                }
            }
            Pair pair = new Pair((Object)checkSatResult, null);
            return pair;
        }
        finally {
            script.pop(1);
        }
    }

    public static Term annotateAndAssert(Script script, Term term, String name) {
        assert (term.getFreeVars().length == 0) : "Term has free vars";
        Annotation annot = new Annotation(":named", (Object)name);
        Term fAnnot = script.annotate(term, new Annotation[]{annot});
        script.assertTerm(fAnnot);
        return script.term(name, new Term[0]);
    }

    public static Term constructNamedTerm(Script script, Term term, String name) {
        Annotation annot = new Annotation(":named", (Object)name);
        Term result = script.annotate(term, new Annotation[]{annot});
        return result;
    }

    public static QuotedObject echo(Script script, String message) {
        return script.echo(new QuotedObject(message));
    }

    public static boolean isUnaryNumericMinus(FunctionSymbol function) {
        return function.isIntern() && function.getName().equals("-") && function.getParameterSorts().length == 1 && function.getParameterSorts()[0].isNumericSort() && function.getReturnSort().isNumericSort();
    }

    public static boolean isSubterm(Term term, Term subterm) {
        return new SubtermPropertyChecker(x -> x.equals(subterm)).isSatisfiedBySomeSubterm(term);
    }

    public static Rational toRational(long val) {
        return Rational.valueOf((long)val, (long)1L);
    }

    public static Rational toRational(int val) {
        return Rational.valueOf((long)val, (long)1L);
    }

    public static Rational toRational(BigInteger bigInt) {
        return Rational.valueOf((BigInteger)bigInt, (BigInteger)BigInteger.ONE);
    }

    public static Rational toRational(BigDecimal bigDec) {
        Rational rat;
        if (bigDec.scale() <= 0) {
            BigInteger num = bigDec.toBigInteger();
            rat = Rational.valueOf((BigInteger)num, (BigInteger)BigInteger.ONE);
        } else {
            BigInteger num = bigDec.unscaledValue();
            BigInteger denom = BigInteger.TEN.pow(bigDec.scale());
            rat = Rational.valueOf((BigInteger)num, (BigInteger)denom);
        }
        return rat;
    }

    public static Rational gcd(Collection<Rational> rationals) {
        if (rationals.isEmpty()) {
            throw new IllegalArgumentException("Need at least one rational");
        }
        return rationals.stream().reduce(SmtUtils::gcd).orElseThrow();
    }

    public static Rational gcd(Rational r1, Rational r2) {
        BigInteger numerator = Rational.gcd((BigInteger)r1.numerator().multiply(r2.denominator()), (BigInteger)r2.numerator().multiply(r1.denominator()));
        BigInteger denominator = r1.denominator().multiply(r2.denominator());
        return Rational.valueOf((BigInteger)numerator, (BigInteger)denominator);
    }

    public static String toString(Rational r) {
        Optional<BigDecimal> dec = SmtUtils.toDecimal(r);
        return dec.isPresent() ? dec.get().toPlainString() : r.toString();
    }

    public static Set<FunctionSymbol> extractNonTheoryFunctionSymbols(Term term) {
        Set<Term> appTerms = SubTermFinder.find(term, x -> x instanceof ApplicationTerm, false);
        return appTerms.stream().map(x -> ((ApplicationTerm)x).getFunction()).filter(x -> !x.isIntern()).collect(Collectors.toSet());
    }

    public static Set<Term> extractApplicationTerms(String fun, Term term, boolean onlyOutermost) {
        return SubTermFinder.find(term, x -> SmtUtils.isFunctionApplication(x, fun), onlyOutermost);
    }

    public static Set<ApplicationTerm> extractConstants(Term term, boolean restrictToNonTheoryConstants) {
        Predicate<Term> p = restrictToNonTheoryConstants ? x -> SmtUtils.isConstant(x) && x instanceof ApplicationTerm && !((ApplicationTerm)x).getFunction().isIntern() : SmtUtils::isConstant;
        return SubTermFinder.find(term, p, false);
    }

    public static Term unzipNot(Term term) {
        ApplicationTerm appTerm;
        if (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().isIntern() && appTerm.getFunction().getName().equals("not")) {
            return appTerm.getParameters()[0];
        }
        return null;
    }

    public static Term oldAPITerm(Script script, String funName, BigInteger[] indices, Sort returnSort, Term[] params) {
        return script.term(funName, SmtUtils.toStringArray(indices), returnSort, params);
    }

    public static final BigInteger[] toBigIntegerArray(String ... indices) {
        if (indices == null) {
            return null;
        }
        if (indices.length == 0) {
            return EMPTY_INDICES_BI;
        }
        BigInteger[] biIndices = new BigInteger[indices.length];
        int i = 0;
        while (i < indices.length) {
            biIndices[i] = new BigInteger(indices[i]);
            ++i;
        }
        return biIndices;
    }

    public static final String[] toStringArray(BigInteger ... indices) {
        if (indices == null) {
            return null;
        }
        if (indices.length == 0) {
            return EMPTY_INDICES;
        }
        String[] strIndices = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            strIndices[i] = indices[i].toString();
            ++i;
        }
        return strIndices;
    }

    public static double approximateAsDouble(Rational rat) {
        return rat.numerator().doubleValue() / rat.denominator().doubleValue();
    }

    public static boolean isBvMinusOneButNotOne(Rational number, Sort bvSort) {
        if (SmtSortUtils.getBitvectorLength(bvSort) == 1) {
            return false;
        }
        if (number.equals((Object)Rational.MONE)) {
            return true;
        }
        int vecSize = SmtSortUtils.getBitvectorLength(bvSort);
        BigInteger minusOne = BigInteger.valueOf(2L).pow(vecSize).subtract(BigInteger.ONE);
        Rational rationalMinusOne = Rational.valueOf((BigInteger)minusOne, (BigInteger)BigInteger.ONE);
        return number.equals((Object)rationalMinusOne);
    }

    public BigInteger computeSmallestRepresentableBitvector(Sort bv, RelationSymbol.BvSignedness signedness) {
        return null;
    }

    public BigInteger computeLargestRepresentableBitvector(Sort bv, RelationSymbol.BvSignedness signedness) {
        return null;
    }

    public static class ExtendedSimplificationResult {
        private final Term mSimplifiedTerm;
        private final long mSimplificationTimeNano;
        private final long mReductionOfTreeSize;
        private final double mReductionRatioInPercent;

        public ExtendedSimplificationResult(Term simplifiedTerm, long simplificationTimeNano, long reductionOfTreeSize, double reductionRatioPercent) {
            this.mSimplifiedTerm = simplifiedTerm;
            this.mSimplificationTimeNano = simplificationTimeNano;
            this.mReductionOfTreeSize = reductionOfTreeSize;
            this.mReductionRatioInPercent = reductionRatioPercent;
        }

        public Term getSimplifiedTerm() {
            return this.mSimplifiedTerm;
        }

        public long getSimplificationTimeNano() {
            return this.mSimplificationTimeNano;
        }

        public long getReductionOfTreeSize() {
            return this.mReductionOfTreeSize;
        }

        public double getReductionRatioInPercent() {
            return this.mReductionRatioInPercent;
        }

        public String buildSizeReductionMessage() {
            return String.format("treesize reduction %d, result has %2.1f percent of original size", this.getReductionOfTreeSize(), this.getReductionRatioInPercent());
        }
    }

    private static class InnerDualJunctTracker {
        private Set<Term> mInnerDualJuncts;

        private InnerDualJunctTracker() {
        }

        public void addOuterJunct(Term outerJunct, String outerConnective) {
            Term[] innerDualJuncts = QuantifierUtils.getXjunctsInner(QuantifierUtils.getCorrespondingQuantifier(outerConnective), outerJunct);
            if (this.mInnerDualJuncts == null) {
                this.mInnerDualJuncts = new HashSet<Term>(Arrays.asList(innerDualJuncts));
            } else {
                this.mInnerDualJuncts.retainAll(Arrays.asList(innerDualJuncts));
            }
        }

        public Set<Term> getInnerDualJuncts() {
            return this.mInnerDualJuncts;
        }
    }

    public static enum SimplificationTechnique {
        SIMPLIFY_BDD_PROP(false),
        SIMPLIFY_BDD_FIRST_ORDER(false),
        SIMPLIFY_QUICK(true),
        SIMPLIFY_DDA(true),
        POLY_PAC(false),
        NONE(false);

        private final boolean mDecidesFeasibility;

        private SimplificationTechnique(boolean decidesFeasibility) {
            this.mDecidesFeasibility = decidesFeasibility;
        }

        public boolean decidesFeasibility() {
            return this.mDecidesFeasibility;
        }
    }

    public static enum XnfConversionTechnique {
        BDD_BASED,
        BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION;

    }
}

