/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class SubTermFinder
extends NonRecursive {
    private final Predicate<Term> mPredicate;
    private final boolean mOnlyOutermost;
    private HashSet<Term> mResult;
    private HashSet<Term> mVisitedSubterms;

    private SubTermFinder(Predicate<Term> predicate, boolean onlyOutermost) {
        this.mPredicate = predicate;
        this.mOnlyOutermost = onlyOutermost;
    }

    private Set<Term> findMatchingSubterms(Term term) {
        if (term == null) {
            throw new IllegalArgumentException();
        }
        this.mResult = new HashSet();
        this.mVisitedSubterms = new HashSet();
        this.run((NonRecursive.Walker)new FindWalker(term));
        return this.mResult;
    }

    public static Set<Term> find(Term term, Predicate<Term> predicate, boolean onlyOutermost) {
        return new SubTermFinder(predicate, onlyOutermost).findMatchingSubterms(term);
    }

    class FindWalker
    extends NonRecursive.TermWalker {
        FindWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
            if (SubTermFinder.this.mPredicate.test((Term)term)) {
                SubTermFinder.this.mResult.add((Term)term);
            }
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            if (SubTermFinder.this.mPredicate.test((Term)term)) {
                SubTermFinder.this.mResult.add((Term)term);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            walker.enqueueWalker((NonRecursive.Walker)new FindWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            if (SubTermFinder.this.mVisitedSubterms.contains(term)) {
                return;
            }
            SubTermFinder.this.mVisitedSubterms.add((Term)term);
            if (SubTermFinder.this.mPredicate.test((Term)term)) {
                SubTermFinder.this.mResult.add((Term)term);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            Term[] termArray = term.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                walker.enqueueWalker((NonRecursive.Walker)new FindWalker(t));
                ++n2;
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new UnsupportedOperationException();
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            if (SubTermFinder.this.mPredicate.test((Term)term)) {
                SubTermFinder.this.mResult.add((Term)term);
                if (SubTermFinder.this.mOnlyOutermost) {
                    return;
                }
            }
            walker.enqueueWalker((NonRecursive.Walker)new FindWalker(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
            if (SubTermFinder.this.mPredicate.test((Term)term)) {
                SubTermFinder.this.mResult.add((Term)term);
            }
        }

        public void walk(NonRecursive walker, MatchTerm term) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive walker, LambdaTerm term) {
            throw new UnsupportedOperationException();
        }
    }
}

