/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SolveForSubjectUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TermClassifier
extends NonRecursive {
    private Set<Term> mTermsInWhichWeAlreadyDescended;
    private final Set<String> mOccuringSortNames = new HashSet<String>();
    private final Set<String> mOccuringFunctionNames = new HashSet<String>();
    private final Set<Integer> mOccuringQuantifiers = new HashSet<Integer>();
    private boolean mHasArrays = false;
    private boolean mHasNonlinearArithmetic;

    public Set<String> getOccuringSortNames() {
        return this.mOccuringSortNames;
    }

    public Set<String> getOccuringFunctionNames() {
        return this.mOccuringFunctionNames;
    }

    public Set<Integer> getOccuringQuantifiers() {
        return this.mOccuringQuantifiers;
    }

    public boolean hasArrays() {
        return this.mHasArrays;
    }

    public boolean hasNonlinearArithmetic() {
        return this.mHasNonlinearArithmetic;
    }

    public void checkTerm(Term term) {
        this.mTermsInWhichWeAlreadyDescended = new HashSet<Term>();
        this.run((NonRecursive.Walker)new MyWalker(term));
        this.mTermsInWhichWeAlreadyDescended = null;
    }

    private class MyWalker
    extends NonRecursive.TermWalker {
        MyWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            if (!TermClassifier.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                Sort currentSort = this.getTerm().getSort();
                TermClassifier.this.mOccuringSortNames.add(currentSort.getName());
                if (currentSort.isArraySort()) {
                    TermClassifier.this.mHasArrays = true;
                }
                if (this.getTerm() instanceof ApplicationTerm) {
                    long nonConstantTerms;
                    ApplicationTerm appTerm = (ApplicationTerm)this.getTerm();
                    if (appTerm.getFunction().getName().equals("*") && (nonConstantTerms = Arrays.asList(appTerm.getParameters()).stream().filter(x -> !(x instanceof ConstantTerm)).count()) > 1L) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                    if (appTerm.getFunction().getName().equals("mod") && !(appTerm.getParameters()[1] instanceof ConstantTerm)) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                    if (appTerm.getFunction().getName().equals("div") && !SolveForSubjectUtils.tailIsConstant(Arrays.asList(appTerm.getParameters()))) {
                        TermClassifier.this.mHasNonlinearArithmetic = true;
                    }
                }
                super.walk(walker);
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            TermClassifier.this.mOccuringFunctionNames.add(term.getFunction().getName());
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            Term[] termArray = term.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                ++n2;
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            TermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubTerm()));
            Term[] termArray = term.getValues();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term v = termArray[n2];
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(v));
                ++n2;
            }
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            TermClassifier.this.mOccuringQuantifiers.add(term.getQuantifier());
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
        }

        public void walk(NonRecursive walker, MatchTerm term) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive walker, LambdaTerm term) {
            throw new UnsupportedOperationException();
        }
    }
}

