/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TermContextTransformationEngine<C> {
    private static final boolean DEBUG_CHECK_INTERMEDIATE_RESULT = false;
    private static final boolean DEBUG_NONTERMINATION = false;
    private final TermWalker<C> mTermWalker;
    private final ArrayDeque<Task> mStack;

    private TermContextTransformationEngine(TermWalker<C> termWalker) {
        this.mTermWalker = termWalker;
        this.mStack = new ArrayDeque();
    }

    public static <C> Term transform(TermWalker<C> termWalker, C initialContext, Term term) {
        return new TermContextTransformationEngine<C>(termWalker).transform(initialContext, term);
    }

    private Term transform(C context, Term term) {
        DescendResult dr = this.mTermWalker.convert(context, term);
        Task initialTask = this.constructTaskForDescendResult(context, dr);
        if (initialTask instanceof AscendResultTask) {
            AscendResultTask art = (AscendResultTask)initialTask;
            return art.getResult();
        }
        this.mStack.push(initialTask);
        while (!this.mStack.isEmpty()) {
            Task newTask = this.mStack.peek().doStep();
            if (newTask instanceof AscendResultTask) {
                AscendResultTask art = (AscendResultTask)newTask;
                if (this.mStack.isEmpty()) {
                    return art.getResult();
                }
                this.mStack.peek().integrateResult(art.getResult());
                continue;
            }
            this.mStack.push(newTask);
        }
        throw new AssertionError((Object)"empty stack should have caused return");
    }

    private Task constructTaskForDescendResult(C currentContext, DescendResult res) {
        Task result;
        if (res instanceof IntermediateResultForDescend) {
            result = this.constructTask(currentContext, ((IntermediateResultForDescend)res).getTerm());
        } else if (res instanceof FinalResultForAscend) {
            result = new AscendResultTask(currentContext, ((FinalResultForAscend)res).getTerm());
        } else {
            throw new AssertionError((Object)("unknown result " + res));
        }
        return result;
    }

    private Task constructTask(C context, Term term) {
        Task result;
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            result = new ApplicationTermTask(context, appTerm);
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            result = new QuantifiedFormulaTask(context, qf);
        } else {
            throw new AssertionError((Object)("unknown term " + term));
        }
        return result;
    }

    private class ApplicationTermTask
    extends Task {
        int mNext;
        final ApplicationTerm mOriginal;
        final Term[] mResult;
        boolean mChangeInThisIteration;
        int mRepetitions;

        public ApplicationTermTask(C context, ApplicationTerm original) {
            super(context);
            this.mChangeInThisIteration = false;
            this.mNext = 0;
            this.mOriginal = original;
            this.mResult = Arrays.copyOf(original.getParameters(), original.getParameters().length);
            this.mRepetitions = 0;
        }

        @Override
        Task doStep() {
            Task result;
            if (this.mNext == this.mOriginal.getParameters().length && this.mChangeInThisIteration && TermContextTransformationEngine.this.mTermWalker.applyRepeatedlyUntilNoChange()) {
                this.mNext = 0;
                this.mChangeInThisIteration = false;
                ++this.mRepetitions;
            }
            if (this.mNext == this.mOriginal.getParameters().length) {
                Term res = TermContextTransformationEngine.this.mTermWalker.constructResultForApplicationTerm(this.mContext, this.mOriginal, this.mResult);
                Task old = TermContextTransformationEngine.this.mStack.pop();
                assert (old == this);
                result = new AscendResultTask(this.mContext, res);
            } else {
                ArrayList<Term> otherParams = new ArrayList<Term>(Arrays.asList(this.mResult));
                otherParams.remove(this.mNext);
                Object currentContext = TermContextTransformationEngine.this.mTermWalker.constructContextForApplicationTerm(this.mContext, this.mOriginal.getFunction(), Arrays.asList(this.mResult), this.mNext);
                DescendResult res = TermContextTransformationEngine.this.mTermWalker.convert(currentContext, this.mResult[this.mNext]);
                result = TermContextTransformationEngine.this.constructTaskForDescendResult(currentContext, res);
            }
            return result;
        }

        @Override
        void integrateResult(Term result) {
            assert (this.mNext < this.mOriginal.getParameters().length);
            if (!this.mResult[this.mNext].equals(result)) {
                this.mChangeInThisIteration = true;
            }
            this.mResult[this.mNext] = result;
            ++this.mNext;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("next:");
            builder.append(this.mNext);
            builder.append(" (");
            builder.append(this.mOriginal.getFunction().toString());
            builder.append(Arrays.stream(this.mResult).map(Term::toString).collect(Collectors.joining(" ")));
            builder.append(")");
            return builder.toString();
        }
    }

    private class AscendResultTask
    extends Task {
        final Term mResult;

        public AscendResultTask(C context, Term result) {
            super(context);
            this.mResult = result;
        }

        public Term getResult() {
            return this.mResult;
        }

        @Override
        Task doStep() {
            throw new AssertionError();
        }

        @Override
        void integrateResult(Term result) {
            throw new AssertionError();
        }
    }

    public static interface DescendResult {
        public Term getTerm();
    }

    public static class FinalResultForAscend
    implements DescendResult {
        private final Term mFinalResult;

        public FinalResultForAscend(Term finalResult) {
            this.mFinalResult = finalResult;
        }

        @Override
        public Term getTerm() {
            return this.mFinalResult;
        }
    }

    public static class IntermediateResultForDescend
    implements DescendResult {
        private final Term mIntermediateResult;

        public IntermediateResultForDescend(Term intermediateResult) {
            this.mIntermediateResult = intermediateResult;
        }

        @Override
        public Term getTerm() {
            return this.mIntermediateResult;
        }
    }

    private class QuantifiedFormulaTask
    extends Task {
        private final QuantifiedFormula mOriginal;
        private Term mResultSubformula;

        public QuantifiedFormulaTask(C context, QuantifiedFormula quantifiedFormula) {
            super(context);
            this.mOriginal = quantifiedFormula;
        }

        @Override
        Task doStep() {
            Task result;
            if (this.mResultSubformula != null) {
                Term res = TermContextTransformationEngine.this.mTermWalker.constructResultForQuantifiedFormula(this.mContext, this.mOriginal, this.mResultSubformula);
                Task old = TermContextTransformationEngine.this.mStack.pop();
                assert (old == this);
                result = new AscendResultTask(this.mContext, res);
            } else {
                Object currentContext = TermContextTransformationEngine.this.mTermWalker.constructContextForQuantifiedFormula(this.mContext, this.mOriginal.getQuantifier(), Arrays.asList(this.mOriginal.getVariables()));
                DescendResult res = TermContextTransformationEngine.this.mTermWalker.convert(currentContext, this.mOriginal.getSubformula());
                result = TermContextTransformationEngine.this.constructTaskForDescendResult(currentContext, res);
            }
            return result;
        }

        @Override
        void integrateResult(Term result) {
            this.mResultSubformula = result;
        }

        public String toString() {
            return this.mOriginal.toStringDirect();
        }
    }

    private abstract class Task {
        private final C mContext;

        public Task(C context) {
            this.mContext = context;
        }

        abstract Task doStep();

        abstract void integrateResult(Term var1);
    }

    public static abstract class TermWalker<C> {
        protected abstract C constructContextForApplicationTerm(C var1, FunctionSymbol var2, List<Term> var3, int var4);

        protected abstract boolean applyRepeatedlyUntilNoChange();

        protected abstract C constructContextForQuantifiedFormula(C var1, int var2, List<TermVariable> var3);

        protected abstract DescendResult convert(C var1, Term var2);

        protected abstract Term constructResultForApplicationTerm(C var1, ApplicationTerm var2, Term[] var3);

        protected abstract Term constructResultForQuantifiedFormula(C var1, QuantifiedFormula var2, Term var3);

        protected abstract void checkIntermediateResult(C var1, Term var2, Term var3);
    }
}

