/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Predicate;

public final class UltimateNormalFormUtils {
    private UltimateNormalFormUtils() {
    }

    private static boolean rootRespectsUltimateNormalForm(ConstantTerm term) {
        if (SmtSortUtils.isBitvecSort(term.getSort())) {
            assert (false) : "UNF does not support bitvector literals, use instead e.g., (_ bv23 64) to construct a bitvector of length 64 whose decimal value is 23.";
            return false;
        }
        if (term.getValue() instanceof Rational) {
            return true;
        }
        assert (false) : "ConstantTerms have to use Rationals";
        return false;
    }

    private static boolean rootRespectsUltimateNormalForm(ApplicationTerm term) {
        Term param;
        int n;
        Term[] termArray;
        Term index;
        Term array;
        if ("distinct".equals(term.getFunction().getName())) {
            assert (false) : "use not and equals";
            return false;
        }
        if (term.getFunction().getName().equals("select")) {
            array = term.getParameters()[0];
            index = term.getParameters()[1];
            if (index.equals(SmtUtils.getArrayStoreIdx(array))) {
                assert (false) : "select-over-store with same index should have been removed";
                return false;
            }
        }
        if (term.getFunction().getName().equals("store")) {
            array = term.getParameters()[0];
            index = term.getParameters()[1];
            if (index.equals(SmtUtils.getArrayStoreIdx(array))) {
                assert (false) : "select-over-store with same index should have been removed";
                return false;
            }
        }
        if (term.getFunction().getName().equals("+")) {
            termArray = term.getParameters();
            n = termArray.length;
            int index2 = 0;
            while (index2 < n) {
                param = termArray[index2];
                if (SmtUtils.isIntegerLiteral(BigInteger.ZERO, param)) {
                    assert (false) : "zero is neutral element of plus operator";
                    return false;
                }
                ++index2;
            }
        }
        if (term.getFunction().getName().equals("bvadd")) {
            termArray = term.getParameters();
            n = termArray.length;
            int index2 = 0;
            while (index2 < n) {
                param = termArray[index2];
                if (BitvectorUtils.isBitvectorConstant(BigInteger.ZERO, param)) {
                    assert (false) : "zero is neutral element of plus operator";
                    return false;
                }
                ++index2;
            }
        }
        if (term.getFunction().getName().equals("bvand")) {
            termArray = term.getParameters();
            n = termArray.length;
            int index2 = 0;
            while (index2 < n) {
                param = termArray[index2];
                if (BitvectorUtils.isBitvectorConstant(BigInteger.ZERO, param)) {
                    assert (false) : "zero is absorbing element of bvand operator";
                    return false;
                }
                ++index2;
            }
        }
        if (SmtUtils.isUnaryNumericMinus(term.getFunction())) {
            param = term.getParameters()[0];
            if (param instanceof ConstantTerm) {
                return true;
            }
            if (param instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)param;
                if (appTerm.getFunction().getName().equals("+")) {
                    assert (false) : "must not be argument of unary minus " + appTerm.getFunction().getName();
                    return false;
                }
                return true;
            }
            if (param instanceof TermVariable) {
                return true;
            }
            throw new AssertionError((Object)("Illegal kind of term " + param.getClass().getSimpleName()));
        }
        if (term.getFunction().getName().equals("or")) {
            if (Arrays.asList(term.getParameters()).stream().anyMatch(SmtUtils::isTrueLiteral)) {
                assert (false) : "true is absorbing for or: " + term;
                return false;
            }
            if (Arrays.asList(term.getParameters()).stream().anyMatch(SmtUtils::isFalseLiteral)) {
                assert (false) : "disjunction with false is identity: " + term;
                return false;
            }
        }
        if (term.getFunction().getName().equals("and")) {
            if (Arrays.asList(term.getParameters()).stream().anyMatch(SmtUtils::isFalseLiteral)) {
                assert (false) : "false is absorbing for and: " + term;
                return false;
            }
            if (Arrays.asList(term.getParameters()).stream().anyMatch(SmtUtils::isTrueLiteral)) {
                assert (false) : "conjunction with true is identity: " + term;
                return false;
            }
        }
        return true;
    }

    private static boolean rootRespectsUltimateNormalForm(Term term) {
        if (term instanceof ApplicationTerm) {
            return UltimateNormalFormUtils.rootRespectsUltimateNormalForm((ApplicationTerm)term);
        }
        if (term instanceof ConstantTerm) {
            return UltimateNormalFormUtils.rootRespectsUltimateNormalForm((ConstantTerm)term);
        }
        return true;
    }

    public static boolean respectsUltimateNormalForm(Term term) {
        Predicate<Term> property = x -> !UltimateNormalFormUtils.rootRespectsUltimateNormalForm(x);
        return !new SubtermPropertyChecker(property).isSatisfiedBySomeSubterm(term);
    }
}

