/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;

public class UndoableWrapperScript
extends WrapperScript {
    private int mDirtyStackLevels = 0;

    public UndoableWrapperScript(Script wrappedScript) {
        super(wrappedScript);
        this.push(1);
    }

    public void push(int levels) throws SMTLIBException {
        assert (levels > 0);
        super.push(levels);
        this.mDirtyStackLevels += levels;
    }

    public void pop(int levels) throws SMTLIBException {
        assert (levels > 0);
        super.pop(levels);
        this.mDirtyStackLevels -= levels;
        if (this.mDirtyStackLevels < 0) {
            throw new AssertionError((Object)"You removed more stack levels than tracked by UndoableWrapperScript");
        }
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException(UndoableWrapperScript.class + " cannot restore anymore because it does not know what was on the stack before its creation");
    }

    public void reset() {
        throw new UnsupportedOperationException(UndoableWrapperScript.class + " cannot restore anymore because it does not know what was on the stack before its creation");
    }

    public int restore() {
        int rtr = this.mDirtyStackLevels;
        this.pop(this.mDirtyStackLevels);
        return rtr;
    }
}

