/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction.MaximumUniversalSetComputation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.Set;
import java.util.function.ToIntFunction;

public class Abducer {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final ToIntFunction<TermVariable> mCost;
    private final Set<TermVariable> mForbiddenVars;

    public Abducer(IUltimateServiceProvider services, ManagedScript script) {
        this(services, script, Collections.emptySet());
    }

    public Abducer(IUltimateServiceProvider services, ManagedScript script, Set<TermVariable> forbiddenVars) {
        this(services, script, x -> 1, forbiddenVars);
    }

    public Abducer(IUltimateServiceProvider services, ManagedScript script, ToIntFunction<TermVariable> cost, Set<TermVariable> forbiddenVars) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(Abducer.class);
        this.mScript = script;
        this.mCost = cost;
        this.mForbiddenVars = forbiddenVars;
    }

    public Term abduce(Term premise, Term conclusion) {
        Term solution = this.solveAbductionProblem(SmtUtils.implies(this.mScript.getScript(), premise, conclusion), premise);
        assert (this.checkResult(premise, conclusion, solution, false)) : "Abduction failed";
        return solution;
    }

    public Term abduceEquivalence(Term lhs, Term rhs) {
        Term formula = SmtUtils.binaryBooleanEquality(this.mScript.getScript(), lhs, rhs);
        Term invariant = SmtUtils.or(this.mScript.getScript(), lhs, rhs);
        Term solution = this.solveAbductionProblem(formula, invariant);
        assert (this.checkResult(lhs, rhs, solution, true)) : "Abduction failed";
        return solution;
    }

    private Term solveAbductionProblem(Term formula, Term invariant) {
        Term quantifiedFormula = this.tryEliminateForall(this.mForbiddenVars, formula);
        Script.LBool sat = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), invariant, quantifiedFormula));
        if (sat != Script.LBool.SAT) {
            return null;
        }
        Term unsimplified = new MaximumUniversalSetComputation(this.mServices, this.mScript, quantifiedFormula, invariant, this.mCost).getQuantifiedFormula();
        return SmtUtils.simplify(this.mScript, unsimplified, invariant, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
    }

    private Term tryEliminateForall(Set<TermVariable> vars, Term formula) {
        return PartialQuantifierElimination.quantifier(this.mServices, this.mLogger, this.mScript, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, 1, vars, formula, new Term[0][]);
    }

    private boolean checkResult(Term lhs, Term rhs, Term solution, boolean equiv) {
        Script.LBool suff;
        if (solution == null) {
            return true;
        }
        if (equiv) {
            suff = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), solution, SmtUtils.binaryBooleanNotEquals(this.mScript.getScript(), lhs, rhs)));
            assert (suff != Script.LBool.SAT) : "Abduction failed: solution " + solution + " does not imply equivalence of " + lhs + " and " + rhs;
        } else {
            suff = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), lhs, solution, SmtUtils.not(this.mScript.getScript(), rhs)));
            assert (suff != Script.LBool.SAT) : "Abduction failed: premise " + lhs + " and solution " + solution + " do not imply conclusion " + rhs;
        }
        Script.LBool cons = SmtUtils.checkSatTerm(this.mScript.getScript(), SmtUtils.and(this.mScript.getScript(), lhs, solution));
        assert (cons != Script.LBool.UNSAT) : "Abduction failed: LHS " + lhs + " and solution " + solution + " are inconsistent";
        return suff != Script.LBool.SAT && cons != Script.LBool.UNSAT;
    }
}

