/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class MaximumUniversalSetComputation {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private final ToIntFunction<TermVariable> mCost;
    private final Term mContext;
    private Set<TermVariable> mUniversalSet;
    private Term mQuantifiedUniversalFormula;
    private int mUniversalSetCost;

    public MaximumUniversalSetComputation(IUltimateServiceProvider services, ManagedScript mgdScript, Term phi, Term context, ToIntFunction<TermVariable> cost) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(MaximumUniversalSetComputation.class);
        this.mMgdScript = mgdScript;
        this.mContext = context;
        this.mCost = cost;
        TermVariable[] variables = phi.getFreeVars();
        int varCost = Arrays.stream(variables).collect(Collectors.summingInt(this.mCost));
        this.computeMUS(phi, variables, 0, varCost, 0);
    }

    public Set<TermVariable> getVariables() {
        return this.mUniversalSet;
    }

    public Term getQuantifiedFormula() {
        return this.mQuantifiedUniversalFormula;
    }

    public int getCost() {
        return this.mUniversalSetCost;
    }

    private void computeMUS(Term phi, TermVariable[] variables, int minVar, int varCost, int lowerBound) {
        if (minVar >= variables.length || varCost <= lowerBound) {
            this.mUniversalSet = new HashSet<TermVariable>();
            this.mQuantifiedUniversalFormula = phi;
            this.mUniversalSetCost = 0;
            return;
        }
        Set<TermVariable> bestUniversalSet = new HashSet<TermVariable>();
        Term bestFormula = phi;
        int bestCost = 0;
        TermVariable x = variables[minVar];
        int xCost = this.mCost.applyAsInt(x);
        Term quantifiedPhi = this.tryEliminateUniversal(x, phi);
        Script.LBool includeX = SmtUtils.checkSatTerm(this.mMgdScript.getScript(), this.getWithContext(quantifiedPhi));
        if (includeX == Script.LBool.SAT) {
            this.computeMUS(quantifiedPhi, variables, minVar + 1, varCost - xCost, lowerBound - xCost);
            if (this.mUniversalSetCost + xCost > lowerBound) {
                bestUniversalSet = this.mUniversalSet;
                bestUniversalSet.add(x);
                bestFormula = this.mQuantifiedUniversalFormula;
                lowerBound = bestCost = this.mUniversalSetCost + xCost;
            }
        }
        this.computeMUS(phi, variables, minVar + 1, varCost - xCost, lowerBound);
        if (this.mUniversalSetCost > lowerBound) {
            bestUniversalSet = this.mUniversalSet;
            bestFormula = this.mQuantifiedUniversalFormula;
            bestCost = this.mUniversalSetCost;
        }
        this.mUniversalSet = bestUniversalSet;
        this.mQuantifiedUniversalFormula = bestFormula;
        this.mUniversalSetCost = bestCost;
    }

    private Term getWithContext(Term formula) {
        if (this.mContext == null) {
            return formula;
        }
        return SmtUtils.and(this.mMgdScript.getScript(), this.mContext, formula);
    }

    private Term tryEliminateUniversal(TermVariable x, Term phi) {
        Term letFree = new FormulaUnLet().transform(phi);
        return PartialQuantifierElimination.eliminate(this.mServices, this.mMgdScript, SmtUtils.quantifier(this.mMgdScript.getScript(), 1, Set.of(x), letFree), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
    }
}

