/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ArrayEquality {
    private final Term mOriginalTerm;
    private final Term mLhs;
    private final Term mRhs;
    private final boolean mIsNegated;

    public ArrayEquality(Term term) throws ArrayEqualityException {
        this(term, false, false);
    }

    public ArrayEquality(Term term, boolean allowDisequalities, boolean allowConstants) throws ArrayEqualityException {
        ApplicationTerm eqAppTerm;
        boolean isDisEquality;
        if (!(term instanceof ApplicationTerm)) {
            throw new ArrayEqualityException("no ApplicationTerm");
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        boolean isNotEqualsAppTerm = appTerm.getFunction().getName().equals("not") && appTerm.getParameters()[0] instanceof ApplicationTerm && ((ApplicationTerm)appTerm.getParameters()[0]).getFunction().getName().equals("=");
        this.mIsNegated = isDisEquality = appTerm.getFunction().getName().equals("distinct") || isNotEqualsAppTerm;
        if (!appTerm.getFunction().getName().equals("=")) {
            if (!allowDisequalities) {
                throw new ArrayEqualityException("no equality");
            }
            if (!isDisEquality) {
                throw new ArrayEqualityException("no (dis)equality");
            }
        }
        ApplicationTerm applicationTerm = eqAppTerm = isNotEqualsAppTerm ? (ApplicationTerm)appTerm.getParameters()[0] : appTerm;
        if (eqAppTerm.getParameters().length != 2) {
            throw new ArrayEqualityException("no binary equality");
        }
        this.mOriginalTerm = term;
        Term lhsTerm = eqAppTerm.getParameters()[0];
        Term rhsTerm = eqAppTerm.getParameters()[1];
        if (!lhsTerm.getSort().isArraySort()) {
            throw new ArrayEqualityException("no array");
        }
        if (lhsTerm instanceof TermVariable) {
            this.mLhs = lhsTerm;
        } else if (allowConstants && ArrayEquality.isTermVarOrConst(lhsTerm)) {
            this.mLhs = lhsTerm;
        } else {
            throw new ArrayEqualityException("no TermVariable or constant");
        }
        if (rhsTerm instanceof TermVariable) {
            this.mRhs = rhsTerm;
        } else if (allowConstants && ArrayEquality.isTermVarOrConst(rhsTerm)) {
            this.mRhs = rhsTerm;
        } else {
            throw new ArrayEqualityException("no TermVariable or constant");
        }
    }

    public Term getOriginalTerm() {
        return this.mOriginalTerm;
    }

    public Term getLhs() {
        return this.mLhs;
    }

    public Term getRhs() {
        return this.mRhs;
    }

    public TermVariable getLhsTermVariable() {
        return (TermVariable)this.mLhs;
    }

    public TermVariable getRhsTermVariable() {
        return (TermVariable)this.mRhs;
    }

    public boolean isNegated() {
        return this.mIsNegated;
    }

    public static List<ArrayEquality> extractArrayEqualities(Term term) {
        HashSet<String> functionSymbolNames = new HashSet<String>(3);
        functionSymbolNames.add("=");
        functionSymbolNames.add("distinct");
        functionSymbolNames.add("not");
        ArrayList<ArrayEquality> result = new ArrayList<ArrayEquality>();
        ApplicationTermFinder atf = new ApplicationTermFinder(functionSymbolNames, false);
        for (ApplicationTerm subterm : atf.findMatchingSubterms(term)) {
            ArrayEquality arrayEquality = null;
            try {
                arrayEquality = new ArrayEquality((Term)subterm, true, true);
            }
            catch (ArrayEqualityException arrayEqualityException) {
                continue;
            }
            result.add(arrayEquality);
        }
        return result;
    }

    private static boolean isTermVarOrConst(Term t) {
        if (t instanceof TermVariable) {
            return true;
        }
        if (t instanceof ConstantTerm) {
            return true;
        }
        return t instanceof ApplicationTerm && ((ApplicationTerm)t).getParameters().length == 0;
    }

    public String toString() {
        return this.mOriginalTerm.toString();
    }

    public class ArrayEqualityException
    extends Exception {
        private static final long serialVersionUID = -5344050289008681972L;

        public ArrayEqualityException(String message) {
            super(message);
        }
    }

    public static class ArrayEqualityExtractor {
        private final List<ArrayEquality> mArrayEqualities = new ArrayList<ArrayEquality>();
        private final List<Term> remainingTerms = new ArrayList<Term>();

        public ArrayEqualityExtractor(Term[] terms) {
            Term[] termArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayEquality au;
                Term term = termArray[n2];
                try {
                    au = new ArrayEquality(term);
                }
                catch (ArrayEqualityException arrayEqualityException) {
                    au = null;
                }
                if (au == null) {
                    this.remainingTerms.add(term);
                } else {
                    this.mArrayEqualities.add(au);
                }
                ++n2;
            }
        }

        public List<ArrayEquality> getArrayEqualities() {
            return this.mArrayEqualities;
        }

        public List<Term> getRemainingTerms() {
            return this.remainingTerms;
        }
    }
}

