/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArrayEqualityExplicator {
    private static final String AUX_VAR_PREFIX = "antiDerIndex";
    private final List<TermVariable> mNewAuxVars;
    private final Term mResultTerm;

    public ArrayEqualityExplicator(ManagedScript mgdScript, int quantifier, TermVariable eliminatee, Term inputTerm, List<BinaryEqualityRelation> bers) {
        ArrayList<TermVariable> newAuxVars = new ArrayList<TermVariable>();
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (BinaryEqualityRelation ber : bers) {
            if (ber.getRelationSymbol() != ArrayEqualityExplicator.getDerRelationSymbol(quantifier).negate()) {
                throw new IllegalArgumentException("incompatible relation");
            }
            Term elementwiseComparison = this.constructElementwiseEquality(mgdScript, quantifier, ber.getLhs(), ber.getRhs(), newAuxVars);
            substitutionMapping.put(ber.toTerm(mgdScript.getScript()), elementwiseComparison);
        }
        this.mResultTerm = Substitution.apply(mgdScript, substitutionMapping, inputTerm);
        assert (CommuhashUtils.isInCommuhashNormalForm(inputTerm, CommuhashUtils.COMMUTATIVE_OPERATORS)) : "input not in commuhash normal form";
        if (this.mResultTerm.equals(inputTerm)) {
            throw new AssertionError((Object)("Substitution failed: " + substitutionMapping));
        }
        this.mNewAuxVars = newAuxVars;
    }

    private static RelationSymbol getDerRelationSymbol(int quantifier) {
        if (quantifier == 0) {
            return RelationSymbol.EQ;
        }
        if (quantifier == 1) {
            return RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public Term getResultTerm() {
        return this.mResultTerm;
    }

    public List<TermVariable> getNewAuxVars() {
        return this.mNewAuxVars;
    }

    private Term constructElementwiseEquality(ManagedScript mgdScript, int quantifier, Term lhsArray, Term rhsArray, List<TermVariable> newAuxVars) {
        Term result;
        MultiDimensionalSort mds = new MultiDimensionalSort(lhsArray.getSort());
        ArrayIndex auxIndex = ArrayEqualityExplicator.constructAuxIndex(mgdScript, mds, newAuxVars);
        Term lhsSelect = SmtUtils.multiDimensionalSelect(mgdScript.getScript(), lhsArray, auxIndex);
        Term rhsSelect = SmtUtils.multiDimensionalSelect(mgdScript.getScript(), rhsArray, auxIndex);
        if (quantifier == 0) {
            result = SmtSortUtils.isBoolSort(lhsSelect.getSort()) ? SmtUtils.binaryBooleanNotEquals(mgdScript.getScript(), lhsSelect, rhsSelect) : mgdScript.getScript().term("not", new Term[]{SmtUtils.equality(mgdScript.getScript(), lhsSelect, rhsSelect)});
        } else if (quantifier == 1) {
            result = SmtSortUtils.isBoolSort(lhsSelect.getSort()) ? SmtUtils.binaryBooleanEquality(mgdScript.getScript(), lhsSelect, rhsSelect) : SmtUtils.equality(mgdScript.getScript(), lhsSelect, rhsSelect);
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        return result;
    }

    private static ArrayIndex constructAuxIndex(ManagedScript mgdScript, MultiDimensionalSort mds, List<TermVariable> newAuxVars) {
        ArrayList<TermVariable> indexEntries = new ArrayList<TermVariable>();
        int offset = 0;
        for (Sort sort : mds.getIndexSorts()) {
            TermVariable auxIndex = mgdScript.constructFreshTermVariable("antiDerIndex_entry" + offset, sort);
            indexEntries.add(auxIndex);
            newAuxVars.add(auxIndex);
            ++offset;
        }
        return new ArrayIndex(indexEntries);
    }
}

