/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndex
implements List<Term> {
    private final List<Term> mIndexEntries;

    public ArrayIndex() {
        this.mIndexEntries = Collections.emptyList();
    }

    public ArrayIndex(Term ... indexEntries) {
        this.mIndexEntries = Arrays.asList(indexEntries);
    }

    public ArrayIndex(List<? extends Term> indexEntries) {
        this.mIndexEntries = indexEntries;
    }

    @Override
    public boolean add(Term arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public void add(int arg0, Term arg1) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean addAll(Collection<? extends Term> arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends Term> arg1) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean contains(Object arg0) {
        return this.mIndexEntries.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.mIndexEntries.containsAll(arg0);
    }

    @Override
    public Term get(int arg0) {
        return this.mIndexEntries.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.mIndexEntries.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.mIndexEntries.isEmpty();
    }

    @Override
    public Iterator<Term> iterator() {
        return this.mIndexEntries.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.mIndexEntries.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.mIndexEntries.listIterator();
    }

    @Override
    public ListIterator<Term> listIterator(int arg0) {
        return this.mIndexEntries.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public Term remove(int arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public Term set(int arg0, Term arg1) {
        throw new UnsupportedOperationException("ArrayIndex is immutable");
    }

    @Override
    public int size() {
        return this.mIndexEntries.size();
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        return this.mIndexEntries.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.mIndexEntries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.mIndexEntries.toArray(arg0);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mIndexEntries == null ? 0 : this.mIndexEntries.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayIndex other = (ArrayIndex)obj;
        return !(this.mIndexEntries == null ? other.mIndexEntries != null : !this.mIndexEntries.equals(other.mIndexEntries));
    }

    public String toString() {
        return this.mIndexEntries.toString();
    }

    public ArrayIndex append(Term term) {
        ArrayList<Term> newList = new ArrayList<Term>(this.size() + 1);
        newList.addAll(this.mIndexEntries);
        newList.add(term);
        return new ArrayIndex(newList);
    }

    public ArrayIndex getFirst(int k) {
        ArrayList<Term> indexEntries = new ArrayList<Term>();
        int i = 0;
        while (i < k) {
            indexEntries.add(this.mIndexEntries.get(i));
            ++i;
        }
        return new ArrayIndex(indexEntries);
    }

    public ArrayIndex getLast(int k) {
        ArrayList<Term> indexEntries = new ArrayList<Term>();
        int i = this.mIndexEntries.size() - k;
        while (i < this.mIndexEntries.size()) {
            indexEntries.add(this.mIndexEntries.get(i));
            ++i;
        }
        return new ArrayIndex(indexEntries);
    }

    public Set<TermVariable> getFreeVars() {
        return SmtUtils.getFreeVars(this.mIndexEntries);
    }

    public boolean freeVarsAreSubset(Set<TermVariable> tvSet) {
        for (Term term : this.mIndexEntries) {
            TermVariable[] termVariableArray = term.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable tv = termVariableArray[n2];
                if (!tvSet.contains(tv)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public ArrayIndex appendEntriesAtBeginning(List<Term> newIndexEntries) {
        ArrayList<Term> resultEntries = new ArrayList<Term>(newIndexEntries);
        resultEntries.addAll(this);
        return new ArrayIndex(resultEntries);
    }

    public ArrayIndex applySubstitution(ManagedScript mgdScript, Map<Term, Term> substitutionMapping) {
        ArrayIndex translatedIndex = new ArrayIndex(this.stream().map(x -> Substitution.apply(mgdScript, substitutionMapping, x)).collect(Collectors.toList()));
        return translatedIndex;
    }

    public static List<ArrayIndex> appendEntriesAtBeginning(List<ArrayIndex> indices, List<Term> newIndexEntries) {
        ArrayList<ArrayIndex> result = new ArrayList<ArrayIndex>(indices.size());
        for (ArrayIndex index : indices) {
            result.add(index.appendEntriesAtBeginning(newIndexEntries));
        }
        return result;
    }
}

