/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayIndexBasedCostEstimation {
    private final MultiElementCounter<Doubleton<ArrayIndex>> mIndexDoubleton2Occurrence = new MultiElementCounter();
    private final MultiElementCounter<TermVariable> mEliminatee2Cost = new MultiElementCounter();
    private final TreeHashRelation<Integer, TermVariable> mCost2Eliminatee;
    private final TreeHashRelation<Integer, Doubleton<ArrayIndex>> mOccurrence2Doubletons;
    private final int mOccurrenceMaximum;
    private final Doubleton<Term> mProposedCaseSplitDoubleton;

    public ArrayIndexBasedCostEstimation(Script script, ArrayIndexEqualityManager aiem, Set<TermVariable> eliminatees, Term term, Set<TermVariable> forbiddenVariables) {
        for (TermVariable eliminatee : eliminatees) {
            this.computeCostEstimation(script, aiem, term, eliminatee);
        }
        this.mCost2Eliminatee = ArrayIndexBasedCostEstimation.computeCost2Eliminatee(eliminatees, this.mEliminatee2Cost);
        this.mOccurrence2Doubletons = ArrayIndexBasedCostEstimation.computeOccurrence2Doubletons(this.mIndexDoubleton2Occurrence);
        if (this.mOccurrence2Doubletons.isEmpty()) {
            this.mOccurrenceMaximum = 0;
            this.mProposedCaseSplitDoubleton = null;
        } else {
            this.mOccurrenceMaximum = (Integer)this.mOccurrence2Doubletons.descendingDomain().iterator().next();
            this.mProposedCaseSplitDoubleton = this.computeProposedCaseSplitDoubleton(aiem, forbiddenVariables, this.mOccurrence2Doubletons, this.mOccurrenceMaximum);
        }
    }

    private Doubleton<Term> computeProposedCaseSplitDoubleton(ArrayIndexEqualityManager aiem, Set<TermVariable> forbiddenVariables, TreeHashRelation<Integer, Doubleton<ArrayIndex>> occurrence2Doubletons, int occurrenceMaximum) {
        for (Doubleton indexDoubleton : occurrence2Doubletons.getImage((Object)occurrenceMaximum)) {
            int i = 0;
            while (i < ((ArrayIndex)indexDoubleton.getOneElement()).size()) {
                Term entry2;
                Term entry1 = ((ArrayIndex)indexDoubleton.getOneElement()).get(i);
                EqualityStatus es = aiem.checkEqualityStatus(entry1, entry2 = ((ArrayIndex)indexDoubleton.getOtherElement()).get(i));
                if (es == EqualityStatus.UNKNOWN) {
                    return new Doubleton((Object)entry1, (Object)entry2);
                }
                ++i;
            }
        }
        throw new AssertionError((Object)"all values known");
    }

    public TreeHashRelation<Integer, TermVariable> getCost2Eliminatee() {
        return this.mCost2Eliminatee;
    }

    public int getOccurrenceMaximum() {
        return this.mOccurrenceMaximum;
    }

    public Doubleton<Term> getProposedCaseSplitDoubleton() {
        return this.mProposedCaseSplitDoubleton;
    }

    private static TreeHashRelation<Integer, TermVariable> computeCost2Eliminatee(Set<TermVariable> eliminatees, MultiElementCounter<TermVariable> eliminatee2Cost) {
        TreeHashRelation result = new TreeHashRelation();
        for (TermVariable eliminatee : eliminatees) {
            result.addPair((Object)eliminatee2Cost.getNumber((Object)eliminatee), (Object)eliminatee);
        }
        return result;
    }

    private static TreeHashRelation<Integer, Doubleton<ArrayIndex>> computeOccurrence2Doubletons(MultiElementCounter<Doubleton<ArrayIndex>> indexDoubleton2Occurrence) {
        TreeHashRelation result = new TreeHashRelation();
        for (Doubleton elem : indexDoubleton2Occurrence.getElements()) {
            result.addPair((Object)indexDoubleton2Occurrence.getNumber((Object)elem), (Object)elem);
        }
        return result;
    }

    private void computeCostEstimation(Script script, ArrayIndexEqualityManager aiem, Term term, TermVariable eliminatee) {
        ArrayOccurrenceAnalysis aoa = new ArrayOccurrenceAnalysis(script, term, (Term)eliminatee).downgradeDimensionsIfNecessary(script);
        HashSet<ArrayIndex> selectIndicesIntroducedBySos = new HashSet<ArrayIndex>();
        List<MultiDimensionalSelectOverNestedStore> arraySelectOverStores = aoa.getArraySelectOverStores();
        for (MultiDimensionalSelectOverNestedStore sos : arraySelectOverStores) {
            List<ArrayIndex> nsi;
            ArrayIndex selectIdx = sos.getSelect().getIndex();
            boolean earlyResultDetection = this.sosOuterLoop(aiem, eliminatee, selectIdx, nsi = sos.getNestedStore().getIndices());
            if (earlyResultDetection) continue;
            selectIndicesIntroducedBySos.add(selectIdx);
        }
        Set<ArrayIndex> selectIndices = ArrayOccurrenceAnalysis.extractSelectIndices(aoa.getArraySelects());
        ArrayList<ArrayIndex> selectIndicesAsList = new ArrayList<ArrayIndex>(selectIndices);
        selectIndicesAsList.addAll(selectIndicesIntroducedBySos);
        int i = 0;
        while (i < selectIndicesAsList.size()) {
            int j = 0;
            while (j < i) {
                ArrayIndex indexJ;
                ArrayIndex indexI = (ArrayIndex)selectIndicesAsList.get(i);
                int costForPair = ArrayIndexBasedCostEstimation.analyzeCosts(aiem, indexI, indexJ = (ArrayIndex)selectIndicesAsList.get(j));
                if (costForPair != 0) {
                    this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)indexI, (Object)indexJ), costForPair);
                    this.mEliminatee2Cost.increment((Object)eliminatee, costForPair);
                }
                ++j;
            }
            ++i;
        }
        Set<ArrayIndex> storeIndices = ArrayOccurrenceAnalysis.extractNestedStoreIndices(aoa.getNestedArrayStores());
        ArrayList<ArrayIndex> storeIndicesAsList = new ArrayList<ArrayIndex>(storeIndices);
        int i2 = 0;
        while (i2 < storeIndicesAsList.size()) {
            int j = 0;
            while (j < selectIndicesAsList.size()) {
                ArrayIndex indexJ;
                ArrayIndex indexI = (ArrayIndex)storeIndicesAsList.get(i2);
                int costForPair = ArrayIndexBasedCostEstimation.analyzeCosts(aiem, indexI, indexJ = (ArrayIndex)selectIndicesAsList.get(j));
                if (costForPair != 0) {
                    this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)indexI, (Object)indexJ), costForPair);
                    this.mEliminatee2Cost.increment((Object)eliminatee, costForPair);
                }
                ++j;
            }
            ++i2;
        }
    }

    private boolean sosOuterLoop(ArrayIndexEqualityManager aiem, TermVariable eliminatee, ArrayIndex selectIdx, List<ArrayIndex> nsi) {
        int indexOfEquality = nsi.size() - 1;
        while (indexOfEquality >= 0) {
            boolean earlyResultDetection = this.sosInnerLoop(aiem, selectIdx, nsi, indexOfEquality);
            this.mEliminatee2Cost.increment((Object)eliminatee);
            if (earlyResultDetection) {
                return true;
            }
            --indexOfEquality;
        }
        return false;
    }

    private boolean sosInnerLoop(ArrayIndexEqualityManager aiem, ArrayIndex selectIdx, List<ArrayIndex> nsi, int indexOfEquality) {
        int i = nsi.size() - 1;
        while (i >= indexOfEquality) {
            EqualityStatus eq = aiem.checkIndexEquality(selectIdx, nsi.get(i));
            switch (eq) {
                case EQUAL: {
                    return true;
                }
                case NOT_EQUAL: {
                    break;
                }
                case UNKNOWN: {
                    this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)selectIdx, (Object)nsi.get(i)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            --i;
        }
        return false;
    }

    private static int analyzeCosts(ArrayIndexEqualityManager aiem, ArrayIndex indexI, ArrayIndex indexJ) {
        if (indexI.size() != indexJ.size()) {
            throw new AssertionError((Object)"incompatible size");
        }
        int unknowns = 0;
        int k = 0;
        while (k < indexI.size()) {
            Term entryI = indexI.get(k);
            Term entryJ = indexJ.get(k);
            EqualityStatus eq = aiem.checkEqualityStatus(entryI, entryJ);
            switch (eq) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return 0;
                }
                case UNKNOWN: {
                    ++unknowns;
                    break;
                }
            }
            ++k;
        }
        return unknowns;
    }
}

