/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndexEqualityManager {
    private final ThreeValuedEquivalenceRelation<Term> mTver;
    private final Term mContext;
    private final boolean mContextIsAbsorbingElement;
    private final Set<TermVariable> mFreeVarsOfContext;
    private final boolean mCheckEqualityStatusOnDemand;
    private final int mQuantifier;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final HashRelation<Term, Term> mAlreadyCheckedBySolver;
    final IncrementalPlicationChecker mIea;

    public ArrayIndexEqualityManager(ThreeValuedEquivalenceRelation<Term> tver, Term context, int quantifier, ILogger logger, ManagedScript mgdScript) {
        IncrementalPlicationChecker.Plication plication;
        this.mTver = tver;
        this.mContext = context;
        this.mQuantifier = quantifier;
        this.mLogger = logger;
        this.mMgdScript = mgdScript;
        this.mFreeVarsOfContext = Arrays.stream(this.mContext.getFreeVars()).collect(Collectors.toSet());
        this.mCheckEqualityStatusOnDemand = true;
        this.mAlreadyCheckedBySolver = new HashRelation();
        if (this.mQuantifier == 0) {
            plication = IncrementalPlicationChecker.Plication.IMPLICATION;
        } else if (this.mQuantifier == 1) {
            plication = IncrementalPlicationChecker.Plication.EXPLICATION;
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        this.mIea = new IncrementalPlicationChecker(plication, this.mMgdScript, this.mContext);
        Term absorbingElement = QuantifierUtils.getNeutralElement(this.mMgdScript.getScript(), this.mQuantifier);
        IncrementalPlicationChecker.Validity validity = this.mIea.checkPlication(absorbingElement);
        this.mContextIsAbsorbingElement = validity == IncrementalPlicationChecker.Validity.VALID;
    }

    boolean alreadyCheckedUsesRepresenatives() {
        for (Term t : this.mAlreadyCheckedBySolver.getDomain()) {
            if (this.mTver.isRepresentative((Object)t)) continue;
            return false;
        }
        return true;
    }

    public EqualityStatus checkEqualityStatus(Term elem1, Term elem2) {
        if (!this.allFreeVarsOccurInContext(elem1)) {
            return EqualityStatus.UNKNOWN;
        }
        if (!this.allFreeVarsOccurInContext(elem2)) {
            return EqualityStatus.UNKNOWN;
        }
        this.mTver.addElement((Object)elem1);
        this.mTver.addElement((Object)elem2);
        EqualityStatus status = this.mTver.getEqualityStatus((Object)elem1, (Object)elem2);
        if (status == EqualityStatus.UNKNOWN && this.mCheckEqualityStatusOnDemand) {
            Term elem1Rep = (Term)this.mTver.getRepresentative((Object)elem1);
            Term elem2Rep = (Term)this.mTver.getRepresentative((Object)elem2);
            assert (this.alreadyCheckedUsesRepresenatives()) : "the mAlreadyCheckedBySolver relation is outdated";
            if (this.mAlreadyCheckedBySolver.containsPair((Object)elem1Rep, (Object)elem2Rep)) {
                return EqualityStatus.UNKNOWN;
            }
            this.mAlreadyCheckedBySolver.addPair((Object)elem1Rep, (Object)elem2Rep);
            this.mAlreadyCheckedBySolver.addPair((Object)elem2Rep, (Object)elem1Rep);
            this.checkEqualityStatusViaSolver(this.mQuantifier, this.mTver, this.mIea, elem1Rep, elem2Rep);
            assert (this.alreadyCheckedUsesRepresenatives()) : "the mAlreadyCheckedBySolver relation is outdated";
            return this.mTver.getEqualityStatus((Object)elem1Rep, (Object)elem2Rep);
        }
        return status;
    }

    private boolean allFreeVarsOccurInContext(Term term) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            if (!this.mFreeVarsOfContext.contains(tv)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void checkEqualityStatusViaSolver(int mQuantifier, ThreeValuedEquivalenceRelation<Term> tver, IncrementalPlicationChecker iea, Term index1, Term index2) throws AssertionError {
        Term eq = SmtUtils.binaryEquality(this.mMgdScript.getScript(), index1, index2);
        if (SmtUtils.isTrueLiteral(eq)) {
            this.reportEquality(index1, index2);
            assert (!tver.isInconsistent()) : "inconsistent equality information";
        } else if (SmtUtils.isFalseLiteral(eq)) {
            tver.reportDisequality((Object)index1, (Object)index2);
            assert (!tver.isInconsistent()) : "inconsistent equality information";
        } else {
            Term neq = SmtUtils.not(this.mMgdScript.getScript(), eq);
            IncrementalPlicationChecker.Validity isEqual = iea.checkPlication(eq);
            if (isEqual == IncrementalPlicationChecker.Validity.UNKNOWN && this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)("solver failed to check if following equality is implied: " + eq));
            }
            if (isEqual == IncrementalPlicationChecker.Validity.VALID) {
                if (mQuantifier == 0) {
                    this.reportEquality(index1, index2);
                    assert (!tver.isInconsistent()) : "inconsistent equality information";
                } else if (mQuantifier == 1) {
                    tver.reportDisequality((Object)index1, (Object)index2);
                    assert (!tver.isInconsistent()) : "inconsistent equality information";
                } else {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                this.mLogger.info((Object)"detected equality via solver");
            } else {
                IncrementalPlicationChecker.Validity notEqualsHolds = iea.checkPlication(neq);
                if (notEqualsHolds == IncrementalPlicationChecker.Validity.UNKNOWN && this.mLogger.isWarnEnabled()) {
                    this.mLogger.warn((Object)("solver failed to check if following not equals relation is implied: " + eq));
                }
                if (notEqualsHolds == IncrementalPlicationChecker.Validity.VALID) {
                    if (mQuantifier == 0) {
                        tver.reportDisequality((Object)index1, (Object)index2);
                        assert (!tver.isInconsistent()) : "inconsistent equality information";
                    } else if (mQuantifier == 1) {
                        this.reportEquality(index1, index2);
                        assert (!tver.isInconsistent()) : "inconsistent equality information";
                    } else {
                        throw new AssertionError((Object)"unknown quantifier");
                    }
                    this.mLogger.info((Object)"detected not equals via solver");
                }
            }
        }
    }

    private void reportEquality(Term index1, Term index2) {
        Term outdatedRepresentative;
        Term newRepresentative;
        Term t1rep = (Term)this.mTver.getRepresentative((Object)index1);
        Term t2rep = (Term)this.mTver.getRepresentative((Object)index2);
        this.mTver.reportEquality((Object)index1, (Object)index2);
        if (t1rep == this.mTver.getRepresentative((Object)index1)) {
            newRepresentative = t1rep;
            outdatedRepresentative = t2rep;
            assert (t1rep == this.mTver.getRepresentative((Object)index2));
        } else {
            newRepresentative = t2rep;
            outdatedRepresentative = t1rep;
            assert (t2rep == this.mTver.getRepresentative((Object)index1));
        }
        HashRelation outdatedEntries = new HashRelation();
        for (Map.Entry entry : this.mAlreadyCheckedBySolver.getSetOfPairs()) {
            if (entry.getKey() != outdatedRepresentative && entry.getValue() != outdatedRepresentative) continue;
            outdatedEntries.addPair((Object)((Term)entry.getKey()), (Object)((Term)entry.getValue()));
        }
        for (Map.Entry entry : outdatedEntries.getSetOfPairs()) {
            boolean removed;
            if (entry.getKey() == outdatedRepresentative) {
                removed = this.mAlreadyCheckedBySolver.removePair((Object)outdatedRepresentative, (Object)((Term)entry.getValue()));
                if (!removed) {
                    throw new AssertionError((Object)"element does not exist");
                }
                this.mAlreadyCheckedBySolver.addPair((Object)newRepresentative, (Object)((Term)entry.getValue()));
                continue;
            }
            if (entry.getValue() == outdatedRepresentative) {
                removed = this.mAlreadyCheckedBySolver.removePair((Object)((Term)entry.getKey()), (Object)outdatedRepresentative);
                if (!removed) {
                    throw new AssertionError((Object)"element does not exist");
                }
                this.mAlreadyCheckedBySolver.addPair((Object)((Term)entry.getKey()), (Object)newRepresentative);
                continue;
            }
            throw new AssertionError((Object)"some element has to be outdated.");
        }
    }

    public void unlockSolver() {
        this.mIea.unlockSolver();
    }

    public boolean contextIsAbsorbingElement() {
        return this.mContextIsAbsorbingElement;
    }

    public EqualityStatus checkIndexEquality(ArrayIndex selectIndex, ArrayIndex storeIndex) {
        int i = 0;
        while (i < selectIndex.size()) {
            EqualityStatus eqStaus = this.checkEqualityStatus(selectIndex.get(i), storeIndex.get(i));
            if (eqStaus == EqualityStatus.NOT_EQUAL || eqStaus == EqualityStatus.UNKNOWN) {
                return eqStaus;
            }
            ++i;
        }
        return EqualityStatus.EQUAL;
    }

    public Term constructIndexEquality(ArrayIndex index1, ArrayIndex index2) {
        assert (index1.size() == index2.size());
        ArrayList<Term> conjuncts = new ArrayList<Term>(index1.size());
        int i = 0;
        while (i < index1.size()) {
            EqualityStatus indexEquality = this.checkEqualityStatus(index1.get(i), index2.get(i));
            switch (indexEquality) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return this.mMgdScript.getScript().term("false", new Term[0]);
                }
                case UNKNOWN: {
                    conjuncts.add(SmtUtils.binaryEquality(this.mMgdScript.getScript(), index1.get(i), index2.get(i)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return SmtUtils.and(this.mMgdScript.getScript(), conjuncts);
    }

    public Term constructDerRelation(Script script, int quantifier, Term t1, Term t2) {
        Term result;
        EqualityStatus eq = this.checkEqualityStatus(t1, t2);
        switch (eq) {
            case EQUAL: {
                result = QuantifierUtils.getAbsorbingElement(script, quantifier);
                break;
            }
            case NOT_EQUAL: {
                result = QuantifierUtils.getNeutralElement(script, quantifier);
                break;
            }
            case UNKNOWN: {
                result = QuantifierUtils.applyDerOperator(script, quantifier, t1, t2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return result;
    }

    public Term constructAntiDerRelation(Script script, int quantifier, Term t1, Term t2) {
        Term result;
        EqualityStatus eq = this.checkEqualityStatus(t1, t2);
        switch (eq) {
            case EQUAL: {
                result = QuantifierUtils.getNeutralElement(script, quantifier);
                break;
            }
            case NOT_EQUAL: {
                result = QuantifierUtils.getAbsorbingElement(script, quantifier);
                break;
            }
            case UNKNOWN: {
                result = QuantifierUtils.applyDerOperator(script, quantifier, t1, t2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return result;
    }

    public Term constructDerRelation(Script script, int quantifier, ArrayIndex idx1, ArrayIndex idx2) {
        assert (idx1.size() == idx2.size());
        ArrayList<Term> dualJuncts = new ArrayList<Term>(idx1.size());
        int i = 0;
        while (i < idx1.size()) {
            EqualityStatus entryEquality = this.checkEqualityStatus(idx1.get(i), idx2.get(i));
            switch (entryEquality) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return QuantifierUtils.getNeutralElement(script, quantifier);
                }
                case UNKNOWN: {
                    dualJuncts.add(QuantifierUtils.applyDerOperator(script, quantifier, idx1.get(i), idx2.get(i)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return QuantifierUtils.applyDualFiniteConnective(script, quantifier, dualJuncts);
    }

    public Term constructAntiDerRelation(Script script, int quantifier, ArrayIndex idx1, ArrayIndex idx2) {
        assert (idx1.size() == idx2.size());
        ArrayList<Term> sameJuncts = new ArrayList<Term>(idx1.size());
        int i = 0;
        while (i < idx1.size()) {
            EqualityStatus entryEquality = this.checkEqualityStatus(idx1.get(i), idx2.get(i));
            switch (entryEquality) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return QuantifierUtils.getAbsorbingElement(script, quantifier);
                }
                case UNKNOWN: {
                    sameJuncts.add(QuantifierUtils.applyAntiDerOperator(script, quantifier, idx1.get(i), idx2.get(i)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        return QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, sameJuncts);
    }

    private Term constructNestedStoreUpdateConstraintForOnePosition(Script script, int quantifier, Term arrayRes, ArrayIndex idx, List<ArrayIndex> laterUpdateIndices, ArrayIndex updateIndex, Term updateValue) {
        List<Term> correspondingFiniteJuncts = laterUpdateIndices.stream().map(x -> this.constructDerRelation(script, quantifier, idx, (ArrayIndex)x)).collect(Collectors.toList());
        Term correspondingFiniteJunction = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, correspondingFiniteJuncts);
        if (correspondingFiniteJunction == QuantifierUtils.getAbsorbingElement(script, quantifier)) {
            return correspondingFiniteJunction;
        }
        Term idxAntiDerUidx = this.constructAntiDerRelation(script, quantifier, idx, updateIndex);
        MultiDimensionalSelect idxCellOfArrayRes = new MultiDimensionalSelect(arrayRes, idx, script);
        Term updateValueDerRelation = this.constructDerRelation(script, quantifier, idxCellOfArrayRes.toTerm(script), updateValue);
        Term result = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, correspondingFiniteJunction, idxAntiDerUidx, updateValueDerRelation);
        return result;
    }

    public Term constructNestedStoreUpdateConstraint(Script script, int quantifier, Term resArray, ArrayIndex idx, List<ArrayIndex> storeIndices, List<Term> storeValues, Term defaultValue) {
        assert (storeIndices.size() == storeValues.size());
        ArrayList<Term> resultDualJuncts = new ArrayList<Term>();
        Term inputCase = this.constructNestedStoreUpdateConstraintForOnePosition(script, quantifier, resArray, idx, storeIndices, idx, defaultValue);
        resultDualJuncts.add(inputCase);
        LinkedList<ArrayIndex> tmp = new LinkedList<ArrayIndex>(storeIndices);
        int i = 0;
        while (i < storeIndices.size()) {
            ArrayIndex innermost = tmp.removeFirst();
            Term correspondingValue = storeValues.get(i);
            Term term = this.constructNestedStoreUpdateConstraintForOnePosition(script, quantifier, resArray, idx, tmp, innermost, correspondingValue);
            resultDualJuncts.add(term);
            ++i;
        }
        Term result = QuantifierUtils.applyDualFiniteConnective(script, quantifier, resultDualJuncts);
        return result;
    }
}

