/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ArrayOccurrenceAnalysis {
    private static final boolean THROW_ERROR_BEFORE_DOWNGRADE = false;
    private final Term mAnalyzedTerm;
    private final Term mWantedArray;
    private final int mDimensionUpperLimit;
    private final List<MultiDimensionalSelectOverNestedStore> mArraySelectOverStores = new ArrayList<MultiDimensionalSelectOverNestedStore>();
    private final List<MultiDimensionalNestedStore> mNestedArrayStores = new ArrayList<MultiDimensionalNestedStore>();
    private final List<MultiDimensionalSelect> mArraySelects = new ArrayList<MultiDimensionalSelect>();
    private final List<BinaryEqualityRelation> mArrayEqualities = new ArrayList<BinaryEqualityRelation>();
    private final List<BinaryEqualityRelation> mArrayDisequalities = new ArrayList<BinaryEqualityRelation>();
    private final List<Term> mOtherFunctionApplications = new ArrayList<Term>();
    private final List<Term> mIsValueOfStore = new ArrayList<Term>();

    public ArrayOccurrenceAnalysis(Script script, Term analyzedTerm, Term wantedArray) {
        this.mAnalyzedTerm = analyzedTerm;
        this.mWantedArray = wantedArray;
        this.mDimensionUpperLimit = Integer.MAX_VALUE;
        new ArrOccFinder(script, this.mAnalyzedTerm);
    }

    public ArrayOccurrenceAnalysis(Script script, Term analyzedTerm, Term wantedArray, int dimensionUpperLimit) {
        this.mAnalyzedTerm = analyzedTerm;
        this.mWantedArray = wantedArray;
        this.mDimensionUpperLimit = dimensionUpperLimit;
        new ArrOccFinder(script, this.mAnalyzedTerm);
    }

    public List<MultiDimensionalSelectOverNestedStore> getArraySelectOverStores() {
        return this.mArraySelectOverStores;
    }

    public List<MultiDimensionalNestedStore> getNestedArrayStores() {
        return this.mNestedArrayStores;
    }

    public List<MultiDimensionalSelect> getArraySelects() {
        return this.mArraySelects;
    }

    public List<BinaryEqualityRelation> getArrayEqualities() {
        return this.mArrayEqualities;
    }

    public List<BinaryEqualityRelation> getArrayDisequalities() {
        return this.mArrayDisequalities;
    }

    public List<Term> getOtherFunctionApplications() {
        return this.mOtherFunctionApplications;
    }

    public List<Term> getValueOfStore() {
        return this.mIsValueOfStore;
    }

    public List<BinaryEqualityRelation> getDerRelations(int quantifier) {
        if (quantifier == 0) {
            return this.getArrayEqualities().stream().filter(x -> ArrayOccurrenceAnalysis.isRhsOrLhs(this.mWantedArray, x)).collect(Collectors.toList());
        }
        if (quantifier == 1) {
            return this.getArrayDisequalities().stream().filter(x -> ArrayOccurrenceAnalysis.isRhsOrLhs(this.mWantedArray, x)).collect(Collectors.toList());
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public List<BinaryEqualityRelation> getAntiDerRelations(int quantifier) {
        if (quantifier == 0) {
            return this.getArrayDisequalities();
        }
        if (quantifier == 1) {
            return this.getArrayEqualities();
        }
        throw new AssertionError((Object)"unknown quantifier");
    }

    public TreeSet<Integer> computeSelectAndStoreDimensions() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (MultiDimensionalSelect multiDimensionalSelect : this.getArraySelects()) {
            result.add(multiDimensionalSelect.getDimension());
        }
        for (MultiDimensionalNestedStore multiDimensionalNestedStore : this.getNestedArrayStores()) {
            result.add(multiDimensionalNestedStore.getDimension());
        }
        return result;
    }

    public ArrayOccurrenceAnalysis downgradeDimensionsIfNecessary(Script script) {
        TreeSet<Integer> dims = this.computeSelectAndStoreDimensions();
        if (dims.size() <= 1) {
            return this;
        }
        int dimensionUpperLimit = dims.first();
        assert (dimensionUpperLimit >= 1);
        return new ArrayOccurrenceAnalysis(script, this.mAnalyzedTerm, this.mWantedArray, dimensionUpperLimit);
    }

    private static boolean isRhsOrLhs(Term target, BinaryEqualityRelation ber) {
        return ber.getLhs().equals(target) || ber.getRhs().equals(target);
    }

    private static boolean isSubtermOfSome(Term subtermCandidate, Term ... terms) {
        return Arrays.stream(terms).anyMatch(x -> SmtUtils.isSubterm(x, subtermCandidate));
    }

    public static Set<ArrayIndex> extractSelectIndices(List<MultiDimensionalSelect> arraySelects) {
        return arraySelects.stream().map(MultiDimensionalSelect::getIndex).collect(Collectors.toSet());
    }

    public static Set<ArrayIndex> extractStoreIndices(List<MultiDimensionalStore> mds) {
        return mds.stream().map(MultiDimensionalStore::getIndex).collect(Collectors.toSet());
    }

    public static Set<ArrayIndex> extractNestedStoreIndices(List<MultiDimensionalNestedStore> arraySelects) {
        return arraySelects.stream().map(MultiDimensionalNestedStore::getIndices).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static boolean isStoreWhereWantedArrayIsValue(Term term, Term wantedArray) {
        ArrayStore as = ArrayStore.convert(term);
        if (as == null) {
            return false;
        }
        return as.getValue().equals(wantedArray);
    }

    private class ArrOccFinder
    extends NonRecursive {
        private final Script mScript;
        private final Set<Term> mTermsInWhichWeAlreadyDescended = new HashSet<Term>();

        public ArrOccFinder(Script script, Term term) {
            this.mScript = script;
            this.run((NonRecursive.Walker)new MyWalker(term));
        }

        class MyWalker
        extends NonRecursive.TermWalker {
            MyWalker(Term term) {
                super(term);
            }

            public void walk(NonRecursive walker) {
                if (!ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                    super.walk(walker);
                }
            }

            public void walk(NonRecursive walker, ConstantTerm term) {
            }

            public void walk(NonRecursive walker, AnnotatedTerm term) {
                ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubterm()));
            }

            public void walk(NonRecursive walker, ApplicationTerm term) {
                ArrOccFinder.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
                String fun = term.getFunction().getName();
                if (fun.equals("=")) {
                    if (term.getParameters().length != 2) {
                        throw new UnsupportedOperationException("expecting equality with two parameters");
                    }
                    if (SmtSortUtils.isArraySort(term.getParameters()[0].getSort()) && ArrayOccurrenceAnalysis.isSubtermOfSome(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray, term.getParameters()[0], term.getParameters()[1])) {
                        ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArrayEqualities.add(this.constructBinaryEqualityRelation(term));
                    }
                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getParameters()[0]));
                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getParameters()[1]));
                } else {
                    if (fun.equals("distinct")) {
                        throw new UnsupportedOperationException("UNF requires negated equality");
                    }
                    if (fun.equals("not")) {
                        assert (term.getParameters().length == 1);
                        if (!SmtUtils.isAtomicFormula(term.getParameters()[0])) {
                            throw new UnsupportedOperationException("expected NNF");
                        }
                        Term negatedAtom = term.getParameters()[0];
                        if (negatedAtom instanceof ApplicationTerm) {
                            ApplicationTerm negatedAppTerm = (ApplicationTerm)negatedAtom;
                            if (negatedAppTerm.getFunction().getName().equals("=")) {
                                if (negatedAppTerm.getParameters().length != 2) {
                                    throw new UnsupportedOperationException("expecting equality with two parameters");
                                }
                                if (SmtSortUtils.isArraySort(negatedAppTerm.getParameters()[0].getSort()) && ArrayOccurrenceAnalysis.isSubtermOfSome(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray, negatedAppTerm.getParameters()[0], negatedAppTerm.getParameters()[1])) {
                                    ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArrayDisequalities.add(this.constructBinaryEqualityRelation(term));
                                }
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(negatedAppTerm.getParameters()[0]));
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(negatedAppTerm.getParameters()[1]));
                            } else {
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(negatedAtom));
                            }
                        } else {
                            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(negatedAtom));
                        }
                    } else if (fun.equals("store")) {
                        MultiDimensionalNestedStore nas = MultiDimensionalNestedStore.convert(ArrOccFinder.this.mScript, (Term)term);
                        if (nas != null) {
                            Set<Term> swwaiv = SubTermFinder.find((Term)term, x -> ArrayOccurrenceAnalysis.isStoreWhereWantedArrayIsValue(x, ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray), false);
                            ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mIsValueOfStore.addAll(swwaiv);
                        }
                        if (nas != null && nas.getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                            if (nas.getDimension() > ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                nas = new MultiDimensionalNestedStore(MultiDimensionalStore.convert((Term)nas.getInnermost().getStoreTerm(), ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit));
                                assert (nas.getArray() == ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray);
                            }
                            assert (nas.getArray() == ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray);
                            ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mNestedArrayStores.add(nas);
                            for (ArrayIndex ai : nas.getIndices()) {
                                for (Term indexEntry : ai) {
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(indexEntry));
                                }
                            }
                            for (Term value : nas.getValues()) {
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(value));
                            }
                        } else {
                            Term[] termArray = term.getParameters();
                            int indexEntry = termArray.length;
                            int n = 0;
                            while (n < indexEntry) {
                                Term t = termArray[n];
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                                ++n;
                            }
                        }
                    } else if (fun.equals("select")) {
                        MultiDimensionalSelectOverNestedStore asos = MultiDimensionalSelectOverNestedStore.convert(ArrOccFinder.this.mScript, (Term)term);
                        if (asos != null) {
                            if (asos.getNestedStore().getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                                if (asos.getNestedStore().getDimension() > ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                    Term[] termArray = term.getParameters();
                                    int indexEntry = termArray.length;
                                    int n = 0;
                                    while (n < indexEntry) {
                                        Term t = termArray[n];
                                        walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                                        ++n;
                                    }
                                    return;
                                }
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArraySelectOverStores.add(asos);
                                for (Term indexEntry : asos.getSelect().getIndex()) {
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(indexEntry));
                                }
                                for (ArrayIndex ai : asos.getNestedStore().getIndices()) {
                                    for (Term indexEntry : ai) {
                                        walker.enqueueWalker((NonRecursive.Walker)new MyWalker(indexEntry));
                                    }
                                }
                                for (Term value : asos.getNestedStore().getValues()) {
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(value));
                                }
                            } else {
                                Term[] termArray = term.getParameters();
                                int n = termArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Term t = termArray[n2];
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                                    ++n2;
                                }
                            }
                        } else {
                            MultiDimensionalSelect as = MultiDimensionalSelect.convert((Term)term);
                            if (as != null && as.getArray().equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray) && as.getDimension() <= ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mDimensionUpperLimit) {
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mArraySelects.add(as);
                                for (Term indexEntry : as.getIndex()) {
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(indexEntry));
                                }
                            } else {
                                Term[] termArray = term.getParameters();
                                int n = termArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    Term t = termArray[n3];
                                    walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                                    ++n3;
                                }
                            }
                        }
                    } else {
                        Term[] termArray = term.getParameters();
                        int n = termArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Term t = termArray[n4];
                            if (t.equals(((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mWantedArray)) {
                                ((ArrOccFinder)ArrOccFinder.this).ArrayOccurrenceAnalysis.this.mOtherFunctionApplications.add(t);
                            } else {
                                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                            }
                            ++n4;
                        }
                    }
                }
            }

            private BinaryEqualityRelation constructBinaryEqualityRelation(ApplicationTerm term) {
                BinaryEqualityRelation ber = BinaryEqualityRelation.convert((Term)term);
                if (ber == null) {
                    throw new AssertionError((Object)"Cannot convert relation");
                }
                return ber;
            }

            public void walk(NonRecursive walker, LetTerm term) {
                throw new UnsupportedOperationException();
            }

            public void walk(NonRecursive walker, QuantifiedFormula term) {
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubformula()));
            }

            public void walk(NonRecursive walker, TermVariable term) {
            }

            public void walk(NonRecursive walker, MatchTerm term) {
                throw new UnsupportedOperationException("not yet implemented: MatchTerm");
            }

            public void walk(NonRecursive walker, LambdaTerm term) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

