/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class ArraySelect {
    private final Term mArray;
    private final Term mIndex;
    private final Term mTermRepresentation;

    public ArraySelect(Term array, Term index, Term termRepresentation) {
        this.mArray = array;
        this.mIndex = index;
        this.mTermRepresentation = termRepresentation;
    }

    public Term getArray() {
        return this.mArray;
    }

    public Term getIndex() {
        return this.mIndex;
    }

    public Term asTerm() {
        return this.mTermRepresentation;
    }

    public String toString() {
        return String.valueOf(this.mTermRepresentation);
    }

    public static ArraySelect convert(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        if (!appTerm.getFunction().isIntern()) {
            return null;
        }
        if (!appTerm.getFunction().getName().equals("select")) {
            return null;
        }
        assert (appTerm.getParameters().length == 2);
        return new ArraySelect(appTerm.getParameters()[0], appTerm.getParameters()[1], term);
    }
}

