/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArraySelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class ArraySelectOverStore {
    private final ArrayStore mArrayStore;
    private final Term mIndex;

    public ArraySelectOverStore(Term term) {
        ArraySelect arraySelect = ArraySelect.convert(term);
        this.mArrayStore = ArrayStore.convert(arraySelect.getArray());
        this.mIndex = arraySelect.getIndex();
    }

    public ArrayStore getArrayStore() {
        return this.mArrayStore;
    }

    public Term getIndex() {
        return this.mIndex;
    }

    public Term toTerm(Script script) {
        return script.term("select", new Term[]{this.getArrayStore().asTerm(), this.getIndex()});
    }

    public String toString() {
        return String.format("(select %s %s)", this.getArrayStore(), this.getIndex());
    }

    public static ArraySelectOverStore convert(Term term) {
        try {
            return new ArraySelectOverStore(term);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

