/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayStore {
    private final Term mArray;
    private final Term mIndex;
    private final Term mValue;
    private final Term mTermRepresentation;

    public ArrayStore(Term array, Term index, Term value, Term termRepresentation) {
        this.mArray = array;
        this.mIndex = index;
        this.mValue = value;
        this.mTermRepresentation = termRepresentation;
    }

    public Term getArray() {
        return this.mArray;
    }

    public Term getIndex() {
        return this.mIndex;
    }

    public Term getValue() {
        return this.mValue;
    }

    public Term asTerm() {
        return this.mTermRepresentation;
    }

    public String toString() {
        return String.valueOf(this.mTermRepresentation);
    }

    public static ArrayStore convert(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        if (!appTerm.getFunction().isIntern()) {
            return null;
        }
        if (!appTerm.getFunction().getName().equals("store")) {
            return null;
        }
        assert (appTerm.getParameters().length == 3);
        return new ArrayStore(appTerm.getParameters()[0], appTerm.getParameters()[1], appTerm.getParameters()[2], (Term)appTerm);
    }

    public static Collection<ArrayStore> extractStores(Term term, boolean onlyOutermost) {
        Set<Term> storeTerms = SmtUtils.extractApplicationTerms("store", term, onlyOutermost);
        return storeTerms.stream().map(ArrayStore::convert).collect(Collectors.toList());
    }
}

