/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ArrayUpdate {
    private final TermVariable mNewArray;
    private final MultiDimensionalStore mMultiDimensionalStore;
    private final Term mArrayUpdateTerm;
    private final boolean mIsNegatedEquality;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayUpdate(Term term, boolean isNegated, boolean enforceThatOldArrayIsTermVariable) throws ArrayUpdateException {
        ApplicationTerm allegedStoreTerm;
        BinaryEqualityRelation ber = BinaryEqualityRelation.convert(term);
        if (ber == null) {
            throw new ArrayUpdateException("not a binary equality relation");
        }
        if (isNegated && ber.getRelationSymbol() != RelationSymbol.DISTINCT) {
            throw new ArrayUpdateException("no negated array update");
        }
        if (!isNegated && ber.getRelationSymbol() != RelationSymbol.EQ) {
            throw new ArrayUpdateException("no not negated array update");
        }
        this.mArrayUpdateTerm = term;
        this.mIsNegatedEquality = isNegated;
        Term lhs = ber.getLhs();
        Term rhs = ber.getRhs();
        if (this.isArrayTermVariable(lhs)) {
            if (!this.isStoreTerm(rhs)) throw new ArrayUpdateException("no array update");
            this.mNewArray = (TermVariable)lhs;
            allegedStoreTerm = (ApplicationTerm)rhs;
        } else {
            if (!this.isArrayTermVariable(rhs)) throw new ArrayUpdateException("no array update");
            if (!this.isStoreTerm(lhs)) throw new ArrayUpdateException("no array update");
            this.mNewArray = (TermVariable)rhs;
            allegedStoreTerm = (ApplicationTerm)lhs;
        }
        assert (allegedStoreTerm.getFunction().getName().equals("store"));
        assert (allegedStoreTerm.getParameters().length == 3);
        assert (this.mNewArray.getSort() == allegedStoreTerm.getSort());
        this.mMultiDimensionalStore = MultiDimensionalStore.convert((Term)allegedStoreTerm);
        if (this.mMultiDimensionalStore.getIndex().size() == 0) {
            throw new ArrayUpdateException("no multidimensional array");
        }
        if (!this.mMultiDimensionalStore.getArray().getSort().equals(this.mNewArray.getSort())) {
            throw new AssertionError((Object)"sort mismatch");
        }
        if (!enforceThatOldArrayIsTermVariable || this.mMultiDimensionalStore.getArray() instanceof TermVariable) return;
        throw new ArrayUpdateException("old array is no term variable");
    }

    private boolean isArrayTermVariable(Term term) {
        return term instanceof TermVariable && term.getSort().isArraySort();
    }

    private boolean isStoreTerm(Term term) {
        ApplicationTerm appTerm;
        return term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName().equals("store");
    }

    TermVariable isArrayWithSort(Term term, Sort sort) {
        if (term instanceof TermVariable) {
            if (term.getSort().equals(sort)) {
                return (TermVariable)term;
            }
            return null;
        }
        return null;
    }

    public Term getOldArray() {
        return this.mMultiDimensionalStore.getArray();
    }

    public TermVariable getNewArray() {
        return this.mNewArray;
    }

    public ArrayIndex getIndex() {
        return this.mMultiDimensionalStore.getIndex();
    }

    public Term getValue() {
        return this.mMultiDimensionalStore.getValue();
    }

    public Term getArrayUpdateTerm() {
        return this.mArrayUpdateTerm;
    }

    public MultiDimensionalStore getMultiDimensionalStore() {
        return this.mMultiDimensionalStore;
    }

    public boolean isNegatedEquality() {
        return this.mIsNegatedEquality;
    }

    public String toString() {
        return this.mArrayUpdateTerm.toString();
    }

    public static List<ArrayUpdate> extractArrayUpdates(Term formula) {
        return ArrayUpdate.extractArrayUpdates(formula, true);
    }

    public static List<ArrayUpdate> extractArrayUpdates(Term formula, boolean enforceThatOldArrayIsTermVariable) {
        HashSet<String> functionSymbolNames = new HashSet<String>(3);
        functionSymbolNames.add("=");
        functionSymbolNames.add("distinct");
        functionSymbolNames.add("not");
        ArrayList<ArrayUpdate> result = new ArrayList<ArrayUpdate>();
        ApplicationTermFinder atf = new ApplicationTermFinder(functionSymbolNames, false);
        for (ApplicationTerm subterm : atf.findMatchingSubterms(formula)) {
            ArrayUpdate arrayUpdate = null;
            boolean isNegated = subterm.getFunction().getName().equals("not") || subterm.getFunction().getName().equals("distinct");
            try {
                arrayUpdate = new ArrayUpdate((Term)subterm, isNegated, enforceThatOldArrayIsTermVariable);
            }
            catch (ArrayUpdateException arrayUpdateException) {
                continue;
            }
            result.add(arrayUpdate);
        }
        return result;
    }

    public static class ArrayUpdateException
    extends Exception {
        private static final long serialVersionUID = -5344050289008681972L;

        public ArrayUpdateException(String message) {
            super(message);
        }
    }

    public static class ArrayUpdateExtractor {
        private final Map<Term, Term> mStore2TermVariable = new HashMap<Term, Term>();
        private final List<ArrayUpdate> mArrayUpdates = new ArrayList<ArrayUpdate>();
        private final List<Term> remainingTerms = new ArrayList<Term>();

        public ArrayUpdateExtractor(boolean negatedUpdate, boolean oldArrayIsTermVariable, Term ... terms) {
            Term[] termArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayUpdate au;
                Term term = termArray[n2];
                try {
                    au = new ArrayUpdate(term, negatedUpdate, oldArrayIsTermVariable);
                }
                catch (ArrayUpdateException arrayUpdateException) {
                    au = null;
                }
                if (au == null) {
                    this.remainingTerms.add(term);
                } else {
                    this.mArrayUpdates.add(au);
                    this.mStore2TermVariable.put((Term)au.getMultiDimensionalStore().getStoreTerm(), (Term)au.getNewArray());
                }
                ++n2;
            }
        }

        public Map<Term, Term> getStore2TermVariable() {
            return this.mStore2TermVariable;
        }

        public List<ArrayUpdate> getArrayUpdates() {
            return this.mArrayUpdates;
        }

        public List<Term> getRemainingTerms() {
            return this.remainingTerms;
        }
    }
}

