/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;

public class DiffWrapperScript
extends WrapperScript {
    private ScopedHashMap<Sort, String> mDiffFunctions;
    private ScopedHashSet<Doubleton<Term>> mDiffAxioms;
    private static final String DIFF_FUNCTION_PREFIX = "ULTIMATE@diff";

    public DiffWrapperScript(Script script) {
        super(script);
    }

    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        this.setLogic(Logics.valueOf((String)logic));
    }

    private void setupDiffFunction() {
        Theory theory = this.mScript.term("true", new Term[0]).getSort().getTheory();
        Sort[] vars = theory.createSortVariables(new String[]{"Index", "Elem"});
        Sort array = theory.getSort("Array", vars);
        theory.declareInternalPolymorphicFunction("@diff", vars, new Sort[]{array, array}, vars[0], 0);
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        this.mScript.setLogic(logic);
        this.setupDiffFunction();
        this.mDiffFunctions = new ScopedHashMap();
        this.mDiffAxioms = new ScopedHashSet();
    }

    public void push(int levels) throws SMTLIBException {
        this.mScript.push(levels);
        int i = 0;
        while (i < levels) {
            this.mDiffFunctions.beginScope();
            this.mDiffAxioms.beginScope();
            ++i;
        }
    }

    public void pop(int levels) throws SMTLIBException {
        this.mScript.pop(levels);
        int i = 0;
        while (i < levels) {
            this.mDiffFunctions.endScope();
            this.mDiffAxioms.endScope();
            ++i;
        }
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        term = new FormulaUnLet().unlet(term);
        term = new DiffTransformer().transform(term);
        term = new FormulaLet().let(term);
        return this.mScript.assertTerm(term);
    }

    private String wrap(Sort sort) {
        int n;
        int n2;
        String[] stringArray;
        StringBuilder sb = new StringBuilder();
        sb.append(sort.getName());
        if (sort.getIndices() != null) {
            stringArray = sort.getIndices();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String index = stringArray[n];
                sb.append('@').append(index);
                ++n;
            }
        }
        if (sort.getArguments() != null) {
            stringArray = sort.getArguments();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String arg = stringArray[n];
                sb.append('_').append(this.wrap((Sort)arg));
                ++n;
            }
        }
        return sb.toString();
    }

    private final class DiffTransformer
    extends TermTransformer {
        private DiffTransformer() {
        }

        private String checkOrDeclare(Sort arraySort) {
            String fsymName = (String)DiffWrapperScript.this.mDiffFunctions.get((Object)arraySort);
            if (fsymName == null) {
                Sort[] indexElemSorts = arraySort.getArguments();
                Sort indexSort = indexElemSorts[0];
                fsymName = DiffWrapperScript.DIFF_FUNCTION_PREFIX + DiffWrapperScript.this.wrap(indexElemSorts[0]) + DiffWrapperScript.this.wrap(indexElemSorts[1]);
                DiffWrapperScript.this.declareFun(fsymName, new Sort[]{arraySort, arraySort}, indexSort);
                DiffWrapperScript.this.mDiffFunctions.put((Object)arraySort, (Object)fsymName);
            }
            return fsymName;
        }

        private void checkOrAddAxiom(Term diffTerm, Doubleton<Term> arrays) {
            if (DiffWrapperScript.this.mDiffAxioms.add(arrays)) {
                Term a = (Term)arrays.getOneElement();
                Term b = (Term)arrays.getOtherElement();
                Term selectA = DiffWrapperScript.this.term("select", new Term[]{a, diffTerm});
                Term selectB = DiffWrapperScript.this.term("select", new Term[]{b, diffTerm});
                Term axiom = DiffWrapperScript.this.term("=>", new Term[]{DiffWrapperScript.this.term("=", new Term[]{selectA, selectB}), DiffWrapperScript.this.term("=", new Term[]{a, b})});
                DiffWrapperScript.this.mScript.assertTerm(axiom);
            }
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            if (appTerm.getFunction().isIntern() && appTerm.getFunction().getName() == "@diff") {
                String diffSymbol = this.checkOrDeclare(newArgs[0].getSort().getRealSort());
                Term result = appTerm.getTheory().term(diffSymbol, newArgs);
                Doubleton paramPair = new Doubleton((Object)newArgs[0], (Object)newArgs[1]);
                this.checkOrAddAxiom(result, (Doubleton<Term>)paramPair);
                this.setResult(result);
            } else {
                super.convertApplicationTerm(appTerm, newArgs);
            }
        }
    }
}

