/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiDimensionalNestedStore {
    private final Term mArray;
    private final List<ArrayIndex> mIndices;
    private final List<Term> mValues;
    private final Term mTerm;

    public MultiDimensionalNestedStore(Script script, Term array, List<ArrayIndex> indices, List<Term> values) {
        this.mArray = array;
        this.mIndices = indices;
        this.mValues = values;
        this.mTerm = MultiDimensionalNestedStore.toTerm(script, array, indices, values);
    }

    public MultiDimensionalNestedStore(MultiDimensionalStore mds) {
        this.mArray = mds.getArray();
        this.mIndices = Collections.singletonList(mds.getIndex());
        this.mValues = Collections.singletonList(mds.getValue());
        this.mTerm = mds.getStoreTerm();
    }

    public Term getArray() {
        return this.mArray;
    }

    public List<ArrayIndex> getIndices() {
        return this.mIndices;
    }

    public List<Term> getValues() {
        return this.mValues;
    }

    public int getDimension() {
        return this.mIndices.get(0).size();
    }

    private static Term toTerm(Script script, Term array, List<ArrayIndex> indices, List<Term> values) {
        Term result = array;
        int i = 0;
        while (i < indices.size()) {
            result = SmtUtils.multiDimensionalStore(script, result, indices.get(i), values.get(i));
            ++i;
        }
        return result;
    }

    public Term toTerm(Script script) {
        Term array = this.mArray;
        int i = 0;
        while (i < this.mIndices.size()) {
            array = SmtUtils.multiDimensionalStore(script, array, this.mIndices.get(i), this.mValues.get(i));
            ++i;
        }
        return array;
    }

    @Deprecated
    private MultiDimensionalStore getInnermost(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("must extract at least one MultiDimensionalStore");
        }
        if (k > this.mIndices.size()) {
            throw new IllegalArgumentException("only " + this.mIndices.size() + " stores in sequence");
        }
        MultiDimensionalStore mds = MultiDimensionalStore.convert(this.mTerm);
        int i = 0;
        while (i < this.mIndices.size() - k) {
            mds = MultiDimensionalStore.convert(mds.getArray());
            ++i;
        }
        assert (this.mArray == mds.getArray());
        return mds;
    }

    public MultiDimensionalStore getInnermost() {
        MultiDimensionalStore mds = MultiDimensionalStore.convert(this.mTerm);
        while (mds.getArray() != this.mArray) {
            mds = MultiDimensionalStore.convert(mds.getArray());
        }
        assert (this.mArray == mds.getArray());
        return mds;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mArray == null ? 0 : this.mArray.hashCode());
        result = 31 * result + (this.mIndices == null ? 0 : this.mIndices.hashCode());
        result = 31 * result + (this.mValues == null ? 0 : this.mValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiDimensionalNestedStore other = (MultiDimensionalNestedStore)obj;
        if (this.mArray == null ? other.mArray != null : !this.mArray.equals(other.mArray)) {
            return false;
        }
        if (this.mIndices == null ? other.mIndices != null : !this.mIndices.equals(other.mIndices)) {
            return false;
        }
        return !(this.mValues == null ? other.mValues != null : !this.mValues.equals(other.mValues));
    }

    public static MultiDimensionalNestedStore convert(Script script, Term term) {
        MultiDimensionalNestedStore result = MultiDimensionalNestedStore.convert1mdseq(script, term);
        if (result == null) {
            return null;
        }
        Term innerArray = result.getArray();
        MultiDimensionalNestedStore innerArrayMds = MultiDimensionalNestedStore.convert1mdseq(script, innerArray);
        while (innerArrayMds != null) {
            if (innerArrayMds.getDimension() != result.getDimension()) {
                return result;
            }
            innerArray = innerArrayMds.getArray();
            result = result.addInnerSequence(script, innerArrayMds);
            innerArrayMds = MultiDimensionalNestedStore.convert1mdseq(script, innerArray);
        }
        return result;
    }

    private MultiDimensionalNestedStore addInnerSequence(Script script, MultiDimensionalNestedStore innerArrayMdns) {
        ArrayList<ArrayIndex> indices = new ArrayList<ArrayIndex>(innerArrayMdns.getIndices());
        indices.addAll(this.mIndices);
        ArrayList<Term> values = new ArrayList<Term>(innerArrayMdns.getValues());
        values.addAll(this.mValues);
        MultiDimensionalNestedStore result = new MultiDimensionalNestedStore(script, innerArrayMdns.getArray(), indices, values);
        return result;
    }

    public static MultiDimensionalNestedStore convert1mdseq(Script script, Term term) {
        ArrayStore as = ArrayStore.convert(term);
        if (as == null) {
            return null;
        }
        Term array = as.getArray();
        ArrayList<Term> indexEntries = new ArrayList<Term>();
        indexEntries.add(as.getIndex());
        Term remainingValue = as.getValue();
        MultiDimensionalNestedStore remainingValueAsMdns = MultiDimensionalNestedStore.convert(script, remainingValue);
        while (remainingValueAsMdns != null && MultiDimensionalStore.isCompatibleSelect(remainingValueAsMdns.getArray(), array, indexEntries)) {
            if (remainingValueAsMdns.getDimension() == 1 && remainingValueAsMdns.getIndices().size() == 1) {
                assert (remainingValueAsMdns.getIndices().size() == 1);
                assert (remainingValueAsMdns.getIndices().get(0).size() == 1);
                indexEntries.add(remainingValueAsMdns.getIndices().get(0).get(0));
                remainingValue = remainingValueAsMdns.getValues().get(0);
                remainingValueAsMdns = MultiDimensionalNestedStore.convert(script, remainingValue);
                continue;
            }
            MultiDimensionalNestedStore result = remainingValueAsMdns.addDimensionsAtBeginning(script, array, indexEntries, term);
            return result;
        }
        MultiDimensionalStore mds = new MultiDimensionalStore(array, new ArrayIndex(indexEntries), remainingValue, term);
        return new MultiDimensionalNestedStore(mds);
    }

    private MultiDimensionalNestedStore addDimensionsAtBeginning(Script script, Term array, List<Term> indexEntries, Term term) {
        return new MultiDimensionalNestedStore(script, array, ArrayIndex.appendEntriesAtBeginning(this.mIndices, indexEntries), this.mValues);
    }
}

