/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArraySelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MultiDimensionalSelect {
    private final Term mArray;
    private final ArrayIndex mIndex;
    private final Term mSelectTerm;

    public MultiDimensionalSelect(Term term) {
        ApplicationTerm appTerm;
        this.mSelectTerm = term instanceof ApplicationTerm ? term : null;
        ArrayList<Term> index = new ArrayList<Term>();
        while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName().equals("select")) {
            assert (appTerm.getParameters().length == 2);
            index.add(0, appTerm.getParameters()[1]);
            term = appTerm.getParameters()[0];
        }
        this.mIndex = new ArrayIndex(index);
        this.mArray = term;
        assert (this.classInvariant());
    }

    public MultiDimensionalSelect(Term array, ArrayIndex index, Script script) {
        this.mArray = array;
        this.mIndex = index;
        Term tmp = array;
        for (Term entry : index) {
            tmp = SmtUtils.select(script, tmp, entry);
        }
        this.mSelectTerm = tmp;
    }

    public MultiDimensionalSelect getInnermost(int dim) {
        if (dim < 1) {
            throw new IllegalArgumentException("result must have at least dimension one");
        }
        if (dim > this.getDimension()) {
            throw new IllegalArgumentException("cannot extract more dimensions than this array has");
        }
        ArraySelect as = ArraySelect.convert(this.mSelectTerm);
        int i = 0;
        while (i < this.getDimension() - dim) {
            as = ArraySelect.convert(as.getArray());
            ++i;
        }
        return MultiDimensionalSelect.convert(as.asTerm());
    }

    private boolean classInvariant() {
        if (this.mSelectTerm == null) {
            return this.mIndex.size() == 0;
        }
        return MultiDimensionalSort.areDimensionsConsistent(this.mArray, this.mIndex, this.mSelectTerm);
    }

    public Term getArray() {
        return this.mArray;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public Term getSelectTerm() {
        return this.mSelectTerm;
    }

    public int getDimension() {
        return this.getIndex().size();
    }

    public Term toTerm(Script script) {
        return SmtUtils.multiDimensionalSelect(script, this.getArray(), this.getIndex());
    }

    public static MultiDimensionalSelect convert(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        MultiDimensionalSelect mds = new MultiDimensionalSelect(term);
        if (mds.getArray() == null) {
            return null;
        }
        return mds;
    }

    public String toString() {
        return this.mSelectTerm.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiDimensionalSelect) {
            return this.mSelectTerm.equals(((MultiDimensionalSelect)obj).getSelectTerm());
        }
        return false;
    }

    public int hashCode() {
        return this.mSelectTerm.hashCode();
    }

    public static List<MultiDimensionalSelect> extractSelectShallow(Term term, boolean allowArrayValues) {
        ArrayList<MultiDimensionalSelect> result = new ArrayList<MultiDimensionalSelect>();
        Set<ApplicationTerm> selectTerms = new ApplicationTermFinder("select", true).findMatchingSubterms(term);
        for (Term term2 : selectTerms) {
            if (!allowArrayValues && term2.getSort().isArraySort()) continue;
            MultiDimensionalSelect mdSelect = new MultiDimensionalSelect(term2);
            if (mdSelect.getIndex().size() == 0) {
                throw new AssertionError((Object)"select must not have dimension 0");
            }
            result.add(mdSelect);
        }
        return result;
    }

    public static List<MultiDimensionalSelect> extractSelectDeep(Term term, boolean allowArrayValues) {
        LinkedList<MultiDimensionalSelect> result = new LinkedList<MultiDimensionalSelect>();
        List<MultiDimensionalSelect> foundInThisIteration = MultiDimensionalSelect.extractSelectShallow(term, allowArrayValues);
        while (!foundInThisIteration.isEmpty()) {
            result.addAll(0, foundInThisIteration);
            List<MultiDimensionalSelect> foundInLastIteration = foundInThisIteration;
            foundInThisIteration = new ArrayList<MultiDimensionalSelect>();
            for (MultiDimensionalSelect mdSelect : foundInLastIteration) {
                foundInThisIteration.addAll(MultiDimensionalSelect.extractSelectShallow(mdSelect.getArray(), allowArrayValues));
                ArrayIndex index = mdSelect.getIndex();
                for (Term entry : index) {
                    foundInThisIteration.addAll(MultiDimensionalSelect.extractSelectShallow(entry, allowArrayValues));
                }
            }
        }
        return result;
    }
}

