/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MultiDimensionalSelectOverNestedStore {
    private final MultiDimensionalSelect mSelect;
    private final MultiDimensionalNestedStore mNestedStore;
    private final Term mTerm;

    public MultiDimensionalSelectOverNestedStore(Script script, Term term) {
        MultiDimensionalNestedStore store;
        Term innerArray;
        MultiDimensionalSelect select = new MultiDimensionalSelect(term);
        if (!select.getIndex().isEmpty() && (innerArray = select.getArray()) instanceof ApplicationTerm && (store = MultiDimensionalNestedStore.convert(script, innerArray)) != null && store.getIndices().get(0).size() == select.getIndex().size()) {
            this.mSelect = select;
            this.mNestedStore = store;
            this.mTerm = term;
            return;
        }
        this.mSelect = null;
        this.mNestedStore = null;
        this.mTerm = null;
    }

    public MultiDimensionalSelect getSelect() {
        return this.mSelect;
    }

    public MultiDimensionalNestedStore getNestedStore() {
        return this.mNestedStore;
    }

    public Term toTerm() {
        return this.mTerm;
    }

    public static MultiDimensionalSelectOverNestedStore convert(Script script, Term term) {
        MultiDimensionalSelectOverNestedStore mdsos = new MultiDimensionalSelectOverNestedStore(script, term);
        if (mdsos.getSelect() == null) {
            return null;
        }
        return mdsos;
    }

    public Term constructNotEqualsReplacement(Script script) {
        MultiDimensionalSelect mds = new MultiDimensionalSelect(this.getNestedStore().getArray(), this.getSelect().getIndex(), script);
        return mds.getSelectTerm();
    }

    public static List<MultiDimensionalSelectOverNestedStore> extractMultiDimensionalSelectOverStores(Script script, Term term) {
        ArrayList<MultiDimensionalSelectOverNestedStore> result = new ArrayList<MultiDimensionalSelectOverNestedStore>();
        Set<ApplicationTerm> allSelectTerms = new ApplicationTermFinder("select", false).findMatchingSubterms(term);
        for (ApplicationTerm selectTerm : allSelectTerms) {
            MultiDimensionalSelectOverNestedStore mdsos = MultiDimensionalSelectOverNestedStore.convert(script, (Term)selectTerm);
            if (mdsos == null) continue;
            result.add(mdsos);
        }
        return result;
    }

    public static List<MultiDimensionalSelectOverNestedStore> extractMultiDimensionalSelectOverStores(Script script, Term term, Term arr) {
        ArrayList<MultiDimensionalSelectOverNestedStore> result = new ArrayList<MultiDimensionalSelectOverNestedStore>();
        Set<ApplicationTerm> allSelectTerms = new ApplicationTermFinder("select", false).findMatchingSubterms(term);
        for (ApplicationTerm selectTerm : allSelectTerms) {
            MultiDimensionalSelectOverNestedStore mdsos = MultiDimensionalSelectOverNestedStore.convert(script, (Term)selectTerm);
            if (mdsos == null || mdsos.getNestedStore().getArray() != arr) continue;
            result.add(mdsos);
        }
        return result;
    }
}

