/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MultiDimensionalSelectOverStore {
    private final MultiDimensionalSelect mSelect;
    private final MultiDimensionalStore mStore;
    private final Term mTerm;

    public MultiDimensionalSelectOverStore(Term term) {
        MultiDimensionalStore store;
        Term innerArray;
        MultiDimensionalSelect select = new MultiDimensionalSelect(term);
        if (!select.getIndex().isEmpty() && (innerArray = select.getArray()) instanceof ApplicationTerm && (store = MultiDimensionalStore.convert(innerArray)).getIndex().size() == select.getIndex().size()) {
            this.mSelect = select;
            this.mStore = store;
            this.mTerm = term;
            return;
        }
        this.mSelect = null;
        this.mStore = null;
        this.mTerm = null;
    }

    public MultiDimensionalSelect getSelect() {
        return this.mSelect;
    }

    public MultiDimensionalStore getStore() {
        return this.mStore;
    }

    public Term toTerm() {
        return this.mTerm;
    }

    public static MultiDimensionalSelectOverStore convert(Term term) {
        MultiDimensionalSelectOverStore mdsos = new MultiDimensionalSelectOverStore(term);
        if (mdsos.getSelect() == null) {
            return null;
        }
        return mdsos;
    }

    public Term constructNotEqualsReplacement(Script script) {
        MultiDimensionalSelect mds = new MultiDimensionalSelect(this.getStore().getArray(), this.getSelect().getIndex(), script);
        return mds.getSelectTerm();
    }

    public Term constructEqualsReplacement() {
        return this.getStore().getValue();
    }

    public static List<MultiDimensionalSelectOverStore> extractMultiDimensionalSelectOverStores(Term term) {
        ArrayList<MultiDimensionalSelectOverStore> result = new ArrayList<MultiDimensionalSelectOverStore>();
        Set<ApplicationTerm> allSelectTerms = new ApplicationTermFinder("select", false).findMatchingSubterms(term);
        for (ApplicationTerm selectTerm : allSelectTerms) {
            MultiDimensionalSelectOverStore mdsos = MultiDimensionalSelectOverStore.convert((Term)selectTerm);
            if (mdsos == null) continue;
            result.add(mdsos);
        }
        return result;
    }

    public static List<MultiDimensionalSelectOverStore> extractMultiDimensionalSelectOverStores(Term term, Term arr) {
        ArrayList<MultiDimensionalSelectOverStore> result = new ArrayList<MultiDimensionalSelectOverStore>();
        Set<ApplicationTerm> allSelectTerms = new ApplicationTermFinder("select", false).findMatchingSubterms(term);
        for (ApplicationTerm selectTerm : allSelectTerms) {
            MultiDimensionalSelectOverStore mdsos = MultiDimensionalSelectOverStore.convert((Term)selectTerm);
            if (mdsos == null || mdsos.getStore().getArray() != arr) continue;
            result.add(mdsos);
        }
        return result;
    }
}

