/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayQuantifierEliminationUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import java.util.Collections;
import java.util.Map;

public class MultiDimensionalSelectOverStoreEliminationUtils {
    public static Term replace(ManagedScript mgdScript, ArrayIndexEqualityManager aiem, Term term, MultiDimensionalSelectOverStore mdsos) {
        Term result;
        ArrayIndex selectIndex = mdsos.getSelect().getIndex();
        ArrayIndex storeIndex = mdsos.getStore().getIndex();
        EqualityStatus indexEquality = aiem.checkIndexEquality(selectIndex, storeIndex);
        switch (indexEquality) {
            case EQUAL: {
                Map<Term, Term> substitutionMapping = Collections.singletonMap(mdsos.toTerm(), mdsos.constructEqualsReplacement());
                result = Substitution.apply(mgdScript, substitutionMapping, term);
                break;
            }
            case NOT_EQUAL: {
                Map<Term, Term> substitutionMapping = Collections.singletonMap(mdsos.toTerm(), mdsos.constructNotEqualsReplacement(mgdScript.getScript()));
                result = Substitution.apply(mgdScript, substitutionMapping, term);
                break;
            }
            case UNKNOWN: {
                Map<Term, Term> substitutionMapping = Collections.singletonMap(mdsos.toTerm(), ArrayQuantifierEliminationUtils.transformMultiDimensionalSelectOverStoreToIte(mdsos, mgdScript, aiem));
                Term resultWithIte = Substitution.apply(mgdScript, substitutionMapping, term);
                result = new IteRemover(mgdScript).transform(resultWithIte);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return result;
    }

    public static Term replace(ManagedScript mgdScript, ArrayIndexEqualityManager aiem, Term term, MultiDimensionalSelectOverNestedStore mdsos) {
        Map<Term, Term> substitutionMapping = Collections.singletonMap(mdsos.toTerm(), ArrayQuantifierEliminationUtils.transformMultiDimensionalSelectOverNestedStoreToIte(mdsos, mgdScript, aiem));
        Term resultWithIte = Substitution.apply(mgdScript, substitutionMapping, term);
        Term result = new IteRemover(mgdScript).transform(resultWithIte);
        return result;
    }
}

