/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;

public class MultiDimensionalSort {
    private final ArrayList<Sort> mIndexSorts = new ArrayList();
    private final Sort mArrayValueSort;

    public MultiDimensionalSort(Sort sort) {
        while (sort.isArraySort()) {
            Sort[] arg = sort.getArguments();
            assert (arg.length == 2);
            this.mIndexSorts.add(arg[0]);
            sort = arg[1];
        }
        this.mArrayValueSort = sort;
    }

    public ArrayList<Sort> getIndexSorts() {
        return this.mIndexSorts;
    }

    public Sort getArrayValueSort() {
        return this.mArrayValueSort;
    }

    public int getDimension() {
        return this.mIndexSorts.size();
    }

    public static boolean areDimensionsConsistent(Term outerArray, ArrayIndex index, Term innerArray) {
        int dimensionInnerArray = new MultiDimensionalSort(innerArray.getSort()).getDimension();
        int dimensionOuterArray = new MultiDimensionalSort(outerArray.getSort()).getDimension();
        return index.size() == dimensionOuterArray - dimensionInnerArray;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mArrayValueSort == null ? 0 : this.mArrayValueSort.hashCode());
        result = 31 * result + (this.mIndexSorts == null ? 0 : this.mIndexSorts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiDimensionalSort other = (MultiDimensionalSort)obj;
        if (this.mArrayValueSort == null ? other.mArrayValueSort != null : !this.mArrayValueSort.equals(other.mArrayValueSort)) {
            return false;
        }
        return !(this.mIndexSorts == null ? other.mIndexSorts != null : !this.mIndexSorts.equals(other.mIndexSorts));
    }
}

