/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MultiDimensionalStore {
    private final Term mArray;
    private final ArrayIndex mIndex;
    private final Term mValue;
    private final ApplicationTerm mStoreTerm;

    public MultiDimensionalStore(Term array, ArrayIndex index, Term value, Script script) {
        this.mArray = array;
        this.mIndex = index;
        this.mValue = value;
        this.mStoreTerm = (ApplicationTerm)SmtUtils.multiDimensionalStore(script, array, index, value);
    }

    public MultiDimensionalStore(Term array, ArrayIndex index, Term value, Term asTerm) {
        this.mArray = array;
        this.mIndex = index;
        this.mValue = value;
        this.mStoreTerm = (ApplicationTerm)asTerm;
    }

    public MultiDimensionalStore(Term term) {
        this.mStoreTerm = (ApplicationTerm)term;
        ArrayList<Term> index = new ArrayList<Term>();
        Term remainder = term;
        if (MultiDimensionalStore.isStore(term)) {
            this.mArray = ((ApplicationTerm)term).getParameters()[0];
            index.add(((ApplicationTerm)term).getParameters()[1]);
            remainder = ((ApplicationTerm)term).getParameters()[2];
            while (MultiDimensionalStore.isStore(remainder) && MultiDimensionalStore.isCompatibleSelect(((ApplicationTerm)remainder).getParameters()[0], this.mArray, index)) {
                index.add(((ApplicationTerm)remainder).getParameters()[1]);
                remainder = ((ApplicationTerm)remainder).getParameters()[2];
            }
        } else {
            this.mArray = null;
        }
        this.mIndex = new ArrayIndex(index);
        this.mValue = remainder;
        assert (this.classInvariant());
    }

    private static boolean isStore(Term term) {
        if (term instanceof ApplicationTerm) {
            return ((ApplicationTerm)term).getFunction().getName().equals("store");
        }
        return false;
    }

    private boolean classInvariant() {
        if (this.mArray == null) {
            return this.mIndex.size() == 0 && this.mStoreTerm == this.mValue;
        }
        return this.mArray.getSort() == this.mStoreTerm.getSort() && MultiDimensionalSort.areDimensionsConsistent(this.mArray, this.mIndex, this.mValue);
    }

    static boolean isCompatibleSelect(Term term, Term array, List<Term> index) {
        MultiDimensionalSelect mdSelect = new MultiDimensionalSelect(term);
        return mdSelect.getArray() == array && index.equals(mdSelect.getIndex());
    }

    public Term getArray() {
        return this.mArray;
    }

    public ArrayIndex getIndex() {
        return this.mIndex;
    }

    public Term getValue() {
        return this.mValue;
    }

    public ApplicationTerm getStoreTerm() {
        return this.mStoreTerm;
    }

    public int getDimension() {
        return this.getIndex().size();
    }

    public Term toTerm(Script script) {
        return SmtUtils.multiDimensionalStore(script, this.getArray(), this.getIndex(), this.getValue());
    }

    public MultiDimensionalStore getInnermost(int dim) {
        if (dim < 1) {
            throw new IllegalArgumentException("result must have at least dimension one");
        }
        if (dim > this.getDimension()) {
            throw new IllegalArgumentException("cannot extract more dimensions than this array has");
        }
        ArrayStore as = ArrayStore.convert((Term)this.mStoreTerm);
        int i = 0;
        while (i < this.getDimension() - dim) {
            as = ArrayStore.convert(as.getValue());
            ++i;
        }
        return MultiDimensionalStore.convert(as.asTerm());
    }

    public static MultiDimensionalStore convert(Term term) {
        return MultiDimensionalStore.convert(term, Integer.MAX_VALUE);
    }

    public static MultiDimensionalStore convert(Term term, int maxDimension) {
        Term array;
        ArrayList<Term> index = new ArrayList<Term>();
        Term remainder = term;
        if (MultiDimensionalStore.isStore(term)) {
            array = ((ApplicationTerm)term).getParameters()[0];
            index.add(((ApplicationTerm)term).getParameters()[1]);
            remainder = ((ApplicationTerm)term).getParameters()[2];
            int dimension = 1;
            while (dimension < maxDimension && MultiDimensionalStore.isStore(remainder) && MultiDimensionalStore.isCompatibleSelect(((ApplicationTerm)remainder).getParameters()[0], array, index)) {
                index.add(((ApplicationTerm)remainder).getParameters()[1]);
                remainder = ((ApplicationTerm)remainder).getParameters()[2];
                ++dimension;
            }
        } else {
            return null;
        }
        return new MultiDimensionalStore(array, new ArrayIndex(index), remainder, term);
    }

    public String toString() {
        return this.mStoreTerm.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiDimensionalStore) {
            return this.mStoreTerm.equals(((MultiDimensionalStore)obj).getStoreTerm());
        }
        return false;
    }

    public int hashCode() {
        return this.mStoreTerm.hashCode();
    }

    public static List<MultiDimensionalStore> extractArrayStoresShallow(Term term) {
        ArrayList<MultiDimensionalStore> arrayStoreDefs = new ArrayList<MultiDimensionalStore>();
        Set<ApplicationTerm> storeTerms = new ApplicationTermFinder("store", true).findMatchingSubterms(term);
        for (Term term2 : storeTerms) {
            MultiDimensionalStore mdStore = MultiDimensionalStore.convert(term2);
            if (mdStore.getIndex().size() == 0) {
                throw new AssertionError((Object)"store must not have dimension 0");
            }
            arrayStoreDefs.add(mdStore);
        }
        return arrayStoreDefs;
    }

    public static List<MultiDimensionalStore> extractArrayStoresDeep(Term term) {
        LinkedList<MultiDimensionalStore> result = new LinkedList<MultiDimensionalStore>();
        List<MultiDimensionalStore> foundInThisIteration = MultiDimensionalStore.extractArrayStoresShallow(term);
        while (!foundInThisIteration.isEmpty()) {
            result.addAll(0, foundInThisIteration);
            List<MultiDimensionalStore> foundInLastIteration = foundInThisIteration;
            foundInThisIteration = new ArrayList<MultiDimensionalStore>();
            for (MultiDimensionalStore asd : foundInLastIteration) {
                foundInThisIteration.addAll(MultiDimensionalStore.extractArrayStoresShallow(asd.getArray()));
                foundInThisIteration.addAll(MultiDimensionalStore.extractArrayStoresShallow(asd.getValue()));
                ArrayIndex index = asd.getIndex();
                for (Term entry : index) {
                    foundInThisIteration.addAll(MultiDimensionalStore.extractArrayStoresShallow(entry));
                }
            }
        }
        return result;
    }
}

