/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.LinkedList;
import java.util.List;

public class NestedArrayStore {
    private final Term mArray;
    private final List<Term> mIndices;
    private final List<Term> mValues;

    public NestedArrayStore(Term array, List<Term> indices, List<Term> values) {
        this.mArray = array;
        this.mIndices = indices;
        this.mValues = values;
    }

    public Term getArray() {
        return this.mArray;
    }

    public List<Term> getIndices() {
        return this.mIndices;
    }

    public List<Term> getValues() {
        return this.mValues;
    }

    public Term toTerm(Script script) {
        Term array = this.mArray;
        int i = 0;
        while (i < this.mIndices.size()) {
            array = SmtUtils.store(script, array, this.mIndices.get(i), this.mValues.get(i));
            ++i;
        }
        return array;
    }

    public String toString() {
        String s = this.mArray.toString();
        int i = 0;
        while (i < this.mIndices.size()) {
            s = String.format("(store %s %s %s)", s, this.mIndices.get(i), this.mValues.get(i));
            ++i;
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public static NestedArrayStore convert(Term term) {
        if (!term.getSort().isArraySort()) {
            throw new IllegalArgumentException("no array");
        }
        indices = new LinkedList<Term>();
        values = new LinkedList<Term>();
        currentArray = term;
        currentStore = ArrayStore.convert(term);
        if (currentStore != null) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            indices.addFirst(currentStore.getIndex());
            values.addFirst(currentStore.getValue());
            currentArray = currentStore.getArray();
            currentStore = ArrayStore.convert(currentArray);
lbl13:
            // 2 sources

            ** while (currentStore != null)
        }
lbl14:
        // 1 sources

        return new NestedArrayStore(currentArray, indices, values);
    }
}

