/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class BinaryEqualityRelation
extends BinaryRelation {
    private BinaryEqualityRelation(RelationSymbol relSymb, Term lhs, Term rhs) {
        super(relSymb, lhs, rhs);
    }

    public static BinaryEqualityRelation convert(Term term) {
        boolean isNegated;
        if (!(term instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        String functionSymbolName = appTerm.getFunction().getName();
        Term[] params = appTerm.getParameters();
        if (functionSymbolName.equals("not")) {
            assert (params.length == 1);
            Term notTerm = params[0];
            if (!(notTerm instanceof ApplicationTerm)) {
                return null;
            }
            isNegated = true;
            appTerm = (ApplicationTerm)notTerm;
            functionSymbolName = appTerm.getFunction().getName();
            params = appTerm.getParameters();
        } else {
            isNegated = false;
        }
        if (appTerm.getParameters().length != 2) {
            return null;
        }
        if (!appTerm.getFunction().isIntern()) {
            return null;
        }
        RelationSymbol relSymb = RelationSymbol.convert(functionSymbolName);
        if (relSymb == null) {
            return null;
        }
        if (relSymb != RelationSymbol.EQ && relSymb != RelationSymbol.DISTINCT) {
            return null;
        }
        if (isNegated) {
            RelationSymbol symb = relSymb;
            relSymb = symb.negate();
        }
        return new BinaryEqualityRelation(relSymb, params[0], params[1]);
    }
}

