/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class BinaryNumericRelation
extends BinaryRelation {
    private BinaryNumericRelation(RelationSymbol relationSymbol, Term lhs, Term rhs) {
        super(relationSymbol, lhs, rhs);
    }

    public BinaryNumericRelation changeRelationSymbol(RelationSymbol relSymb) {
        return new BinaryNumericRelation(relSymb, this.getLhs(), this.getRhs());
    }

    public static BinaryNumericRelation convert(Term term) {
        boolean isNegated;
        Term afterPreprocessing;
        if (SmtUtils.unzipNot(term) == null) {
            afterPreprocessing = term;
            isNegated = false;
        } else {
            afterPreprocessing = SmtUtils.unzipNot(term);
            isNegated = true;
        }
        if (!(afterPreprocessing instanceof ApplicationTerm)) {
            return null;
        }
        ApplicationTerm appTerm = (ApplicationTerm)afterPreprocessing;
        String functionSymbolName = appTerm.getFunction().getName();
        Term[] params = appTerm.getParameters();
        if (appTerm.getParameters().length != 2) {
            return null;
        }
        if (!appTerm.getFunction().isIntern()) {
            return null;
        }
        if (!params[0].getSort().isNumericSort() && !SmtSortUtils.isBitvecSort(params[0].getSort())) {
            return null;
        }
        assert (params[1].getSort().isNumericSort() || SmtSortUtils.isBitvecSort(params[1].getSort()));
        RelationSymbol tmp = RelationSymbol.convert(functionSymbolName);
        if (tmp == null) {
            return null;
        }
        RelationSymbol relSymb = isNegated ? tmp.negate() : tmp;
        return new BinaryNumericRelation(relSymb, params[0], params[1]);
    }
}

