/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.IBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public abstract class BinaryRelation
implements IBinaryRelation {
    protected final RelationSymbol mRelationSymbol;
    protected final Term mLhs;
    protected final Term mRhs;

    protected BinaryRelation(RelationSymbol relationSymbol, Term lhs, Term rhs) {
        this.mRelationSymbol = relationSymbol;
        this.mLhs = lhs;
        this.mRhs = rhs;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Term getLhs() {
        return this.mLhs;
    }

    public Term getRhs() {
        return this.mRhs;
    }

    public static Term constructLessNormalForm(Script script, RelationSymbol relationSymbol, Term lhsTerm, Term rhsTerm) throws AssertionError {
        Term result;
        switch (relationSymbol) {
            case EQ: 
            case DISTINCT: {
                Term[] sortedOperands = CommuhashUtils.sortByHashCode(lhsTerm, rhsTerm);
                result = BinaryRelation.toTerm(script, relationSymbol, sortedOperands[0], sortedOperands[1]);
                break;
            }
            case LEQ: 
            case LESS: 
            case BVULE: 
            case BVULT: 
            case BVSLE: 
            case BVSLT: {
                result = BinaryRelation.toTerm(script, relationSymbol, lhsTerm, rhsTerm);
                break;
            }
            case GEQ: 
            case GREATER: 
            case BVUGE: 
            case BVUGT: 
            case BVSGE: 
            case BVSGT: {
                RelationSymbol swapped = relationSymbol.swapParameters();
                result = BinaryRelation.toTerm(script, swapped, rhsTerm, lhsTerm);
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown relation symbol");
            }
        }
        return result;
    }

    public Term toTerm(Script script) {
        return BinaryRelation.constructLessNormalForm(script, this.getRelationSymbol(), this.getLhs(), this.getRhs());
    }

    public static Term toTerm(Script script, RelationSymbol relationSymbol, Term lhsTerm, Term rhsTerm) {
        Term result;
        switch (relationSymbol) {
            case DISTINCT: {
                Term eq = SmtUtils.binaryEquality(script, lhsTerm, rhsTerm);
                result = script.term("not", new Term[]{eq});
                break;
            }
            case EQ: 
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                result = script.term(relationSymbol.toString(), new Term[]{lhsTerm, rhsTerm});
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown relation symbol");
            }
        }
        return result;
    }

    @Override
    public SolvedBinaryRelation solveForSubject(Script script, Term subject) {
        if (this.getLhs().equals(subject)) {
            if (SmtUtils.isSubterm(this.getRhs(), subject)) {
                return null;
            }
            return new SolvedBinaryRelation(subject, this.getRhs(), this.getRelationSymbol(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        }
        if (this.getRhs().equals(subject)) {
            if (SmtUtils.isSubterm(this.getLhs(), subject)) {
                return null;
            }
            return new SolvedBinaryRelation(subject, this.getLhs(), this.getRelationSymbol().swapParameters(), new MultiCaseSolvedBinaryRelation.IntricateOperation[0]);
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mLhs == null ? 0 : this.mLhs.hashCode());
        result = 31 * result + (this.mRelationSymbol == null ? 0 : this.mRelationSymbol.toString().hashCode());
        result = 31 * result + (this.mRhs == null ? 0 : this.mRhs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryRelation other = (BinaryRelation)obj;
        if (this.mLhs == null ? other.mLhs != null : !this.mLhs.equals(other.mLhs)) {
            return false;
        }
        if (this.mRelationSymbol != other.mRelationSymbol) {
            return false;
        }
        return !(this.mRhs == null ? other.mRhs != null : !this.mRhs.equals(other.mRhs));
    }
}

