/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public enum RelationSymbol {
    EQ("="),
    DISTINCT("distinct"),
    LEQ("<="),
    GEQ(">="),
    LESS("<"),
    GREATER(">"),
    BVULE("bvule"),
    BVULT("bvult"),
    BVUGE("bvuge"),
    BVUGT("bvugt"),
    BVSLE("bvsle"),
    BVSLT("bvslt"),
    BVSGE("bvsge"),
    BVSGT("bvsgt");

    private final String mStringRepresentation;

    private RelationSymbol(String stringRepresentation) {
        this.mStringRepresentation = stringRepresentation;
    }

    public String toString() {
        return this.mStringRepresentation;
    }

    public static RelationSymbol convert(String relAsString) {
        switch (relAsString) {
            case "=": {
                return EQ;
            }
            case "distinct": {
                return DISTINCT;
            }
            case "<=": {
                return LEQ;
            }
            case ">=": {
                return GEQ;
            }
            case "<": {
                return LESS;
            }
            case ">": {
                return GREATER;
            }
            case "bvule": {
                return BVULE;
            }
            case "bvult": {
                return BVULT;
            }
            case "bvuge": {
                return BVUGE;
            }
            case "bvugt": {
                return BVUGT;
            }
            case "bvsle": {
                return BVSLE;
            }
            case "bvslt": {
                return BVSLT;
            }
            case "bvsge": {
                return BVSGE;
            }
            case "bvsgt": {
                return BVSGT;
            }
        }
        return null;
    }

    public RelationSymbol negate() {
        RelationSymbol result;
        switch (this) {
            case EQ: {
                result = DISTINCT;
                break;
            }
            case DISTINCT: {
                result = EQ;
                break;
            }
            case LEQ: {
                result = GREATER;
                break;
            }
            case GEQ: {
                result = LESS;
                break;
            }
            case LESS: {
                result = GEQ;
                break;
            }
            case GREATER: {
                result = LEQ;
                break;
            }
            case BVULE: {
                result = BVUGT;
                break;
            }
            case BVULT: {
                result = BVUGE;
                break;
            }
            case BVUGE: {
                result = BVULT;
                break;
            }
            case BVUGT: {
                result = BVULE;
                break;
            }
            case BVSLE: {
                result = BVSGT;
                break;
            }
            case BVSLT: {
                result = BVSGE;
                break;
            }
            case BVSGE: {
                result = BVSLT;
                break;
            }
            case BVSGT: {
                result = BVSLE;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
            }
        }
        return result;
    }

    public RelationSymbol swapParameters() {
        RelationSymbol result;
        switch (this) {
            case EQ: {
                result = EQ;
                break;
            }
            case DISTINCT: {
                result = DISTINCT;
                break;
            }
            case LEQ: {
                result = GEQ;
                break;
            }
            case GEQ: {
                result = LEQ;
                break;
            }
            case LESS: {
                result = GREATER;
                break;
            }
            case GREATER: {
                result = LESS;
                break;
            }
            case BVULE: {
                result = BVUGE;
                break;
            }
            case BVULT: {
                result = BVUGT;
                break;
            }
            case BVUGE: {
                result = BVULE;
                break;
            }
            case BVUGT: {
                result = BVULT;
                break;
            }
            case BVSLE: {
                result = BVSGE;
                break;
            }
            case BVSLT: {
                result = BVSGT;
                break;
            }
            case BVSGE: {
                result = BVSLE;
                break;
            }
            case BVSGT: {
                result = BVSLT;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
            }
        }
        return result;
    }

    public boolean isConvexInequality() {
        boolean result;
        switch (this) {
            case EQ: 
            case DISTINCT: {
                result = false;
                break;
            }
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                result = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
            }
        }
        return result;
    }

    public Term constructTerm(Script script, Term lhs, Term rhs) {
        Term result;
        switch (this) {
            case EQ: {
                result = CommuhashUtils.term(script, "=", null, null, lhs, rhs);
                break;
            }
            case DISTINCT: {
                result = SmtUtils.not(script, CommuhashUtils.term(script, "=", null, null, lhs, rhs));
                break;
            }
            case LEQ: {
                result = SmtUtils.leq(script, lhs, rhs);
                break;
            }
            case GEQ: {
                result = SmtUtils.leq(script, rhs, lhs);
                break;
            }
            case LESS: {
                result = SmtUtils.less(script, lhs, rhs);
                break;
            }
            case GREATER: {
                result = SmtUtils.less(script, rhs, lhs);
                break;
            }
            case BVULE: {
                result = SmtUtils.bvule(script, lhs, rhs);
                break;
            }
            case BVULT: {
                result = SmtUtils.bvult(script, lhs, rhs);
                break;
            }
            case BVUGE: {
                result = SmtUtils.bvule(script, rhs, lhs);
                break;
            }
            case BVUGT: {
                result = SmtUtils.bvult(script, rhs, lhs);
                break;
            }
            case BVSLE: {
                result = SmtUtils.bvsle(script, lhs, rhs);
                break;
            }
            case BVSLT: {
                result = SmtUtils.bvslt(script, lhs, rhs);
                break;
            }
            case BVSGE: {
                result = SmtUtils.bvsle(script, rhs, lhs);
                break;
            }
            case BVSGT: {
                result = SmtUtils.bvslt(script, rhs, lhs);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
            }
        }
        return result;
    }

    public boolean isRelationSymbolGE() {
        return this == GEQ || this == BVUGE || this == BVSGE;
    }

    public boolean isRelationSymbolLE() {
        return this == LEQ || this == BVULE || this == BVSLE;
    }

    public boolean isRelationSymbolGT() {
        return this == GREATER || this == BVUGT || this == BVSGT;
    }

    public boolean isRelationSymbolLT() {
        return this == LESS || this == BVULT || this == BVSLT;
    }

    public boolean isStrictRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case BVULE: 
            case BVUGE: 
            case BVSLE: 
            case BVSGE: {
                return false;
            }
            case LESS: 
            case GREATER: 
            case BVULT: 
            case BVUGT: 
            case BVSLT: 
            case BVSGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
    }

    public static RelationSymbol getLessRelationSymbol(boolean strict, Sort sort, BvSignedness sigedness) {
        RelationSymbol result;
        block10: {
            block8: {
                block9: {
                    if (!SmtSortUtils.isBitvecSort(sort)) break block8;
                    if (!strict) break block9;
                    switch (sigedness) {
                        case SIGNED: {
                            result = BVSLT;
                            break block10;
                        }
                        case UNSIGNED: {
                            result = BVULT;
                            break block10;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown value " + (Object)((Object)sigedness)));
                        }
                    }
                }
                switch (sigedness) {
                    case SIGNED: {
                        result = BVSLE;
                        break block10;
                    }
                    case UNSIGNED: {
                        result = BVULE;
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown value " + (Object)((Object)sigedness)));
                    }
                }
            }
            result = strict ? LESS : LEQ;
        }
        return result;
    }

    public static RelationSymbol getGreaterRelationSymbol(boolean strict, Sort sort, BvSignedness sigedness) {
        RelationSymbol result;
        block10: {
            block8: {
                block9: {
                    if (!SmtSortUtils.isBitvecSort(sort)) break block8;
                    if (!strict) break block9;
                    switch (sigedness) {
                        case SIGNED: {
                            result = BVSGT;
                            break block10;
                        }
                        case UNSIGNED: {
                            result = BVUGT;
                            break block10;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown value " + (Object)((Object)sigedness)));
                        }
                    }
                }
                switch (sigedness) {
                    case SIGNED: {
                        result = BVSGE;
                        break block10;
                    }
                    case UNSIGNED: {
                        result = BVUGE;
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)("unknown value " + (Object)((Object)sigedness)));
                    }
                }
            }
            result = strict ? GREATER : GEQ;
        }
        return result;
    }

    public boolean isSignedBvRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return false;
            }
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
    }

    public boolean isUnSignedBvRelation() {
        switch (this) {
            case EQ: 
            case DISTINCT: 
            case LEQ: 
            case GEQ: 
            case LESS: 
            case GREATER: 
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return false;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return true;
            }
        }
        throw new AssertionError((Object)("unknown RelationSymbol " + (Object)((Object)this)));
    }

    public BvSignedness getSignedness() {
        switch (this) {
            case BVSLE: 
            case BVSLT: 
            case BVSGE: 
            case BVSGT: {
                return BvSignedness.SIGNED;
            }
            case BVULE: 
            case BVULT: 
            case BVUGE: 
            case BVUGT: {
                return BvSignedness.UNSIGNED;
            }
        }
        throw new AssertionError((Object)("not a bitvector inequality " + (Object)((Object)this)));
    }

    public static enum BvSignedness {
        SIGNED,
        UNSIGNED;

    }
}

