/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProviderOnDemand;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.EnumSet;

public class SolvedBinaryRelation
implements ITermProviderOnDemand {
    private final Term mLeftHandSide;
    private final Term mRightHandSide;
    private final RelationSymbol mRelationSymbol;
    private final EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> mIntricateOperations;

    public SolvedBinaryRelation(Term leftHandSide, Term rightHandSide, RelationSymbol relationSymbol, MultiCaseSolvedBinaryRelation.IntricateOperation ... intricateOperation) {
        this.mLeftHandSide = leftHandSide;
        this.mRightHandSide = rightHandSide;
        this.mRelationSymbol = relationSymbol;
        if (intricateOperation.length == 0) {
            this.mIntricateOperations = EnumSet.noneOf(MultiCaseSolvedBinaryRelation.IntricateOperation.class);
        } else {
            if (intricateOperation[0] == null) {
                throw new NullPointerException();
            }
            this.mIntricateOperations = EnumSet.copyOf(Arrays.asList(intricateOperation));
        }
    }

    public Term getLeftHandSide() {
        return this.mLeftHandSide;
    }

    public Term getRightHandSide() {
        return this.mRightHandSide;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> getIntricateOperation() {
        assert (this.mIntricateOperations != null);
        return this.mIntricateOperations;
    }

    @Override
    public Term asTerm(Script script) {
        return script.term(this.mRelationSymbol.toString(), new Term[]{this.mLeftHandSide, this.mRightHandSide});
    }

    public String toString() {
        return this.mLeftHandSide + " " + (Object)((Object)this.mRelationSymbol) + " " + this.mRightHandSide;
    }

    public static enum AssumptionForSolvability {
        INTEGER_DIVISIBLE_BY_CONSTANT,
        REAL_DIVISOR_NOT_ZERO,
        INTEGER_DIVISOR_NOT_ZERO,
        INTEGER_DIVISIBLE_BY_VARIABLE;

    }
}

