/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class BvToIntTranslation
extends TermTransformer {
    private final Script mScript;
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";
    private boolean mNutzTransformation;
    private final ManagedScript mMgdScript;
    private final TermVariable[] mFreeVars;
    private final TranslationConstrainer mTc;
    private final LinkedHashMap<Term, Term> mVariableMap;
    private final LinkedHashMap<Term, Term> mReversedVarMap;
    public final LinkedHashMap<Term, Term> mArraySelectConstraintMap;
    private final Set<TermVariable> mOverapproxVariables;
    private boolean mIsOverapproximation;

    public BvToIntTranslation(ManagedScript mgdscript, LinkedHashMap<Term, Term> variableMap, TranslationConstrainer tc, TermVariable[] freeVars) {
        this.mMgdScript = mgdscript;
        this.mScript = mgdscript.getScript();
        this.mNutzTransformation = false;
        this.mFreeVars = freeVars;
        this.mVariableMap = variableMap != null ? variableMap : new LinkedHashMap();
        this.mReversedVarMap = new LinkedHashMap();
        this.mArraySelectConstraintMap = new LinkedHashMap();
        this.mOverapproxVariables = new HashSet<TermVariable>();
        this.mIsOverapproximation = false;
        this.mTc = tc;
    }

    public void setNutzTransformation(boolean bool) {
        this.mNutzTransformation = bool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(Term term) {
        block36: {
            Sort intSort;
            block35: {
                intSort = SmtSortUtils.getIntSort(this.mScript);
                if (term instanceof TermVariable) {
                    TermVariable[] termVariableArray = this.mFreeVars;
                    int n = this.mFreeVars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TermVariable variable = termVariableArray[n2];
                        if (term == variable && SmtSortUtils.isBitvecSort(term.getSort())) {
                            Term intVar = this.translateVars(term, true);
                            assert (SmtSortUtils.isIntSort(intVar.getSort()));
                            this.mTc.varConstraint(term, intVar);
                            this.setResult(intVar);
                            return;
                        }
                        ++n2;
                    }
                    this.setResult(this.translateVars(term, true));
                    return;
                }
                if (!(term instanceof ApplicationTerm)) break block35;
                ApplicationTerm appTerm = (ApplicationTerm)term;
                FunctionSymbol fsym = appTerm.getFunction();
                if (appTerm.getParameters().length == 0 && SmtUtils.isConstant((Term)appTerm)) {
                    Term intVar = this.translateVars(term, true);
                    if (SmtSortUtils.isBitvecSort(term.getSort())) {
                        this.mTc.varConstraint(term, intVar);
                    }
                    this.setResult(intVar);
                    return;
                }
                if (this.mTc.mMode.equals((Object)TranslationConstrainer.ConstraintsForBitwiseOperations.NONE) && this.overaproxWithVars(appTerm)) {
                    Sort newSort = this.translateSort(this.mScript, appTerm.getSort());
                    TermVariable overaproxVar = this.mMgdScript.constructFreshTermVariable("overaproxVar", newSort);
                    this.mOverapproxVariables.add(overaproxVar);
                    this.mIsOverapproximation = true;
                    this.setResult((Term)overaproxVar);
                    return;
                }
                if (!fsym.isIntern()) break block36;
                switch (fsym.getName()) {
                    case "bvor": {
                        Term bvor = this.mScript.term("bvsub", new Term[]{this.mScript.term("bvadd", appTerm.getParameters()), this.mScript.term("bvand", appTerm.getParameters())});
                        this.pushTerm(bvor);
                        return;
                    }
                    case "bvxor": {
                        this.pushTerm(this.mScript.term("bvsub", new Term[]{this.mScript.term("bvsub", new Term[]{this.mScript.term("bvadd", appTerm.getParameters()), this.mScript.term("bvand", appTerm.getParameters())}), this.mScript.term("bvand", appTerm.getParameters())}));
                        return;
                    }
                    case "bvashr": {
                        this.pushTerm(this.bvashrAbbriviation(appTerm));
                        return;
                    }
                    case "sign_extend": {
                        this.pushTerm(this.signextendAbbriviation(appTerm));
                        return;
                    }
                    case "bvsrem": {
                        this.pushTerm(this.bvsremAbbriviation(appTerm));
                        return;
                    }
                    case "bvsdiv": {
                        this.pushTerm(this.bvsdivAbbriviation(appTerm));
                        return;
                    }
                }
                break block36;
            }
            if (term instanceof ConstantTerm) {
                BigInteger constValue;
                if (!SmtSortUtils.isBitvecSort(term.getSort())) throw new UnsupportedOperationException("unexpected constant sort");
                ConstantTerm constTerm = (ConstantTerm)term;
                assert (this.isBitVecSort(constTerm.getSort()));
                if (constTerm.getValue() instanceof String) {
                    String bitString = (String)constTerm.getValue();
                    if (bitString.startsWith("#b")) {
                        bitString = (String)constTerm.getValue();
                        constValue = new BigInteger(bitString.substring(2), 2);
                    } else {
                        if (!bitString.startsWith("#x")) throw new UnsupportedOperationException("Unexpected constant type");
                        constValue = new BigInteger(bitString.substring(2), 16);
                    }
                } else {
                    constValue = (BigInteger)constTerm.getValue();
                }
                Term intConst = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)constValue, (BigInteger)BigInteger.ONE), intSort);
                this.setResult(intConst);
                return;
            }
        }
        super.convert(term);
    }

    private Term bvashrAbbriviation(ApplicationTerm appTerm) {
        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term zeroVec = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term extract = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[0]);
        Term ifTerm = SmtUtils.binaryEquality(this.mScript, extract, zeroVec);
        Term thenTerm = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvlshr", null, appTerm.getParameters());
        Term elseTerm = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvnot", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvlshr", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvnot", null, appTerm.getParameters()[0]), appTerm.getParameters()[1]));
        Term ite = this.mScript.term("ite", new Term[]{ifTerm, thenTerm, elseTerm});
        return ite;
    }

    private Term signextendAbbriviation(ApplicationTerm appTerm) {
        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term repeat = appTerm.getParameters()[0];
        int difference = Integer.valueOf(appTerm.getSort().getIndices()[0]) - Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]);
        int i = 0;
        while (i < difference) {
            repeat = BitvectorUtils.termWithLocalSimplification(this.mScript, "concat", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[0]), repeat);
            ++i;
        }
        return repeat;
    }

    private Term bvsremAbbriviation(ApplicationTerm appTerm) {
        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term msbLhs = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[0]);
        Term msbRhs = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[1]);
        Term zeroVec = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term oneVec = SmtUtils.rational2Term(this.mScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term ifterm1 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, zeroVec, msbLhs), SmtUtils.equality(this.mScript, zeroVec, msbRhs));
        Term ifterm2 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, oneVec, msbLhs), SmtUtils.equality(this.mScript, zeroVec, msbRhs));
        Term ifterm3 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, zeroVec, msbLhs), SmtUtils.equality(this.mScript, oneVec, msbRhs));
        Term bvurem = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, appTerm.getParameters());
        Term thenTerm2 = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[0]), appTerm.getParameters()[1]));
        Term thenTerm3 = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, appTerm.getParameters()[0], BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[1])));
        Term elseTerm = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[0]), BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[1])));
        Term iteChain2 = this.mScript.term("ite", new Term[]{ifterm3, thenTerm3, elseTerm});
        Term iteChain1 = this.mScript.term("ite", new Term[]{ifterm2, thenTerm2, iteChain2});
        Term bvsrem = this.mScript.term("ite", new Term[]{ifterm1, bvurem, iteChain1});
        return bvsrem;
    }

    private Term bvsdivAbbriviation(ApplicationTerm appTerm) {
        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1), BigInteger.valueOf(Integer.valueOf(appTerm.getParameters()[0].getSort().getIndices()[0]) - 1)};
        Term msbLhs = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[0]);
        Term msbRhs = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, appTerm.getParameters()[1]);
        Term zeroVec = SmtUtils.rational2Term(this.mScript, Rational.ZERO, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term oneVec = SmtUtils.rational2Term(this.mScript, Rational.ONE, SmtSortUtils.getBitvectorSort(this.mScript, 1));
        Term ifterm1 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, zeroVec, msbLhs), SmtUtils.equality(this.mScript, zeroVec, msbRhs));
        Term ifterm2 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, oneVec, msbLhs), SmtUtils.equality(this.mScript, zeroVec, msbRhs));
        Term ifterm3 = SmtUtils.and(this.mScript, SmtUtils.equality(this.mScript, zeroVec, msbLhs), SmtUtils.equality(this.mScript, oneVec, msbRhs));
        Term bvudiv = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvudiv", null, appTerm.getParameters());
        Term thenTerm2 = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvudiv", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[0]), appTerm.getParameters()[1]));
        Term thenTerm3 = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvudiv", null, appTerm.getParameters()[0], BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[1])));
        Term elseTerm = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvudiv", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[0]), BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, appTerm.getParameters()[1]));
        Term iteChain2 = this.mScript.term("ite", new Term[]{ifterm3, thenTerm3, elseTerm});
        Term iteChain1 = this.mScript.term("ite", new Term[]{ifterm2, thenTerm2, iteChain2});
        Term bvsdiv = this.mScript.term("ite", new Term[]{ifterm1, bvudiv, iteChain1});
        return bvsdiv;
    }

    private Sort translateArraySort(Sort sort) {
        if (SmtSortUtils.isBitvecSort(sort)) {
            return SmtSortUtils.getIntSort(this.mMgdScript);
        }
        if (SmtSortUtils.isArraySort(sort)) {
            Sort[] newArgsSort = new Sort[sort.getArguments().length];
            int i = 0;
            while (i < sort.getArguments().length) {
                newArgsSort[i] = this.translateArraySort(sort.getArguments()[i]);
                ++i;
            }
            assert (newArgsSort.length == 2);
            Sort domainSort = newArgsSort[0];
            Sort rangeSort = newArgsSort[1];
            return SmtSortUtils.getArraySort(this.mMgdScript.getScript(), domainSort, rangeSort);
        }
        throw new AssertionError((Object)("Unexpected Sort: " + sort));
    }

    private Term translateVars(Term term, boolean addToVarMap) {
        if (this.mVariableMap.containsKey(term)) {
            this.mReversedVarMap.put(this.mVariableMap.get(term), term);
            return this.mVariableMap.get(term);
        }
        Sort sort = term.getSort();
        if (SmtSortUtils.isArraySort(sort)) {
            TermVariable arrayVar = this.mMgdScript.constructFreshTermVariable("arrayVar", this.translateArraySort(sort));
            if (!(term instanceof TermVariable)) {
                arrayVar = SmtUtils.termVariable2constant(this.mScript, arrayVar, true);
            }
            if (addToVarMap) {
                this.mVariableMap.put(term, (Term)arrayVar);
                this.mReversedVarMap.put((Term)arrayVar, term);
            }
            return arrayVar;
        }
        if (SmtSortUtils.isBitvecSort(sort)) {
            TermVariable intVar = this.mMgdScript.constructFreshTermVariable("intVar", SmtSortUtils.getIntSort(this.mScript));
            if (!(term instanceof TermVariable)) {
                intVar = SmtUtils.termVariable2constant(this.mScript, intVar, true);
            }
            if (addToVarMap) {
                this.mVariableMap.put(term, (Term)intVar);
                this.mReversedVarMap.put((Term)intVar, term);
            }
            return intVar;
        }
        return term;
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        HashSet<TermVariable> newTermVars = new HashSet<TermVariable>();
        HashSet<Term> tvConstraints = new HashSet<Term>();
        if (newBody != old.getSubformula()) {
            int i = 0;
            while (i < old.getVariables().length) {
                if (SmtSortUtils.isBitvecSort(old.getVariables()[i].getSort())) {
                    newTermVars.add((TermVariable)this.mVariableMap.get(old.getVariables()[i]));
                    if (!this.getNutzFlag()) {
                        tvConstraints.add(this.mTc.getTvConstraint(old.getVariables()[i], this.mVariableMap.get(old.getVariables()[i])));
                    }
                } else if (SmtSortUtils.isArraySort(old.getVariables()[i].getSort())) {
                    Term newQuantifiedVar = this.mVariableMap.get(old.getVariables()[i]);
                    newTermVars.add((TermVariable)newQuantifiedVar);
                    Term arrayConstraint = this.mArraySelectConstraintMap.get(newQuantifiedVar);
                    if (arrayConstraint != null) {
                        tvConstraints.add(arrayConstraint);
                    }
                    this.mArraySelectConstraintMap.remove(newQuantifiedVar);
                } else {
                    newTermVars.add(old.getVariables()[i]);
                }
                ++i;
            }
            this.setResult(SmtUtils.quantifier(this.mScript, old.getQuantifier(), newTermVars, QuantifierUtils.applyDualFiniteConnective(this.mScript, old.getQuantifier(), newBody, QuantifierUtils.negateIfUniversal(this.mScript, old.getQuantifier(), SmtUtils.and(this.mScript, tvConstraints)))));
            return;
        }
        super.postConvertQuantifier(old, newBody);
    }

    private boolean overaproxWithVars(ApplicationTerm appTerm) {
        block17: {
            FunctionSymbol fsym = appTerm.getFunction();
            if (!fsym.isIntern()) break block17;
            switch (fsym.getName()) {
                case "bvashr": 
                case "bvlshr": 
                case "bvor": 
                case "bvand": 
                case "bvshl": 
                case "bvxor": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[22] lbl159 : CaseStatement: default:\u000a, @NONE, blocks:[22] lbl159 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Term translateExtract(ApplicationTerm appTerm, Term translatedLHS) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        BigInteger two = BigInteger.valueOf(2L);
        int lowerIndex = Integer.parseInt(appTerm.getFunction().getIndices()[1]);
        int upperIndex = Integer.parseInt(appTerm.getFunction().getIndices()[0]);
        Term divby = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)two.pow(lowerIndex), (BigInteger)BigInteger.ONE), intSort);
        Term modby = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)two.pow(upperIndex - lowerIndex + 1), (BigInteger)BigInteger.ONE), intSort);
        return this.mScript.term("mod", new Term[]{this.mScript.term("div", new Term[]{translatedLHS, divby}), modby});
    }

    private Term translateBvudiv(Term translatedLHS, Term translatedRHS, Term maxNumber) {
        Term lhs;
        Term rhs;
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            rhs = this.mScript.term("mod", new Term[]{translatedRHS, maxNumber});
            lhs = this.mScript.term("mod", new Term[]{translatedLHS, maxNumber});
        } else {
            rhs = translatedRHS;
            lhs = translatedLHS;
        }
        Term ifTerm = this.mScript.term("=", new Term[]{rhs, SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort)});
        Term thenTerm = this.mScript.term("-", new Term[]{maxNumber, SmtUtils.rational2Term(this.mScript, Rational.ONE, intSort)});
        Term elseTerm = this.mScript.term("div", new Term[]{lhs, rhs});
        return this.mScript.term("ite", new Term[]{ifTerm, thenTerm, elseTerm});
    }

    private Term translateBvurem(Term translatedLHS, Term translatedRHS, Term maxNumber) {
        Term lhs;
        Term rhs;
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        if (this.mNutzTransformation) {
            rhs = this.mScript.term("mod", new Term[]{translatedRHS, maxNumber});
            lhs = this.mScript.term("mod", new Term[]{translatedLHS, maxNumber});
        } else {
            rhs = translatedRHS;
            lhs = translatedLHS;
        }
        Term ifTerm = this.mScript.term("=", new Term[]{rhs, SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort)});
        Term thenTerm = lhs;
        Term elseTerm = this.mScript.term("mod", new Term[]{lhs, rhs});
        return this.mScript.term("ite", new Term[]{ifTerm, thenTerm, elseTerm});
    }

    private Term translateBvshl(Term translatedLHS, Term translatedRHS, int width, Term maxNumber) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        if (translatedRHS instanceof ConstantTerm) {
            Term shift = this.mScript.term("*", new Term[]{translatedLHS, this.pow2(translatedRHS)});
            return this.mScript.term("mod", new Term[]{shift, maxNumber});
        }
        Term iteChain = SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort);
        int i = width - 1;
        while (i >= 0) {
            if (i == 0) {
                Term constInt = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), intSort);
                iteChain = SmtUtils.ite(this.mScript, SmtUtils.binaryEquality(this.mScript, constInt, translatedRHS), translatedLHS, iteChain);
            } else {
                Rational powResult = Rational.valueOf((long)i, (long)1L);
                Term ifTerm = this.mScript.term("=", new Term[]{translatedRHS, SmtUtils.rational2Term(this.mScript, powResult, intSort)});
                int pow = (int)Math.pow(2.0, i);
                Term thenTerm = this.mScript.term("mod", new Term[]{this.mScript.term("*", new Term[]{SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)pow, (long)1L), intSort), translatedLHS}), maxNumber});
                iteChain = this.mScript.term("ite", new Term[]{ifTerm, thenTerm, iteChain});
            }
            --i;
        }
        return iteChain;
    }

    private Term translateBvlshr(Term translatedLHS, Term translatedRHS, int width, Term maxNumber) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        if (translatedRHS instanceof ConstantTerm) {
            Term shift = this.mScript.term("div", new Term[]{translatedLHS, this.pow2(translatedRHS)});
            return shift;
        }
        Term iteChain = SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort);
        int i = width - 1;
        while (i >= 0) {
            if (i == 0) {
                Term constInt = SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)0L, (long)1L), intSort);
                iteChain = this.mScript.term("ite", new Term[]{this.mScript.term("=", new Term[]{constInt, translatedRHS}), translatedLHS, iteChain});
            } else {
                Rational powResult = Rational.valueOf((long)i, (long)1L);
                Term ifTerm = this.mScript.term("=", new Term[]{translatedRHS, SmtUtils.rational2Term(this.mScript, powResult, intSort)});
                int pow = (int)Math.pow(2.0, i);
                Term thenTerm = this.mScript.term("div", new Term[]{translatedLHS, SmtUtils.rational2Term(this.mScript, Rational.valueOf((long)pow, (long)1L), intSort)});
                iteChain = this.mScript.term("ite", new Term[]{ifTerm, thenTerm, iteChain});
            }
            --i;
        }
        return iteChain;
    }

    private Term translateRelations(FunctionSymbol fsym, Term[] args, Term maxNumberPlusOne, int width) {
        block41: {
            Term[] translatedArgs = new Term[args.length];
            if (this.mNutzTransformation) {
                int i = 0;
                while (i < args.length) {
                    translatedArgs[i] = this.mScript.term("mod", new Term[]{args[i], maxNumberPlusOne});
                    ++i;
                }
            } else {
                translatedArgs = args;
            }
            if (!fsym.isIntern()) break block41;
            switch (fsym.getName()) {
                case "=": {
                    return this.mScript.term("=", translatedArgs);
                }
                case "distinct": {
                    return this.mScript.term("distinct", translatedArgs);
                }
                case "bvult": {
                    return this.mScript.term("<", translatedArgs);
                }
                case "bvule": {
                    return this.mScript.term("<=", translatedArgs);
                }
                case "bvugt": {
                    return this.mScript.term(">", translatedArgs);
                }
                case "bvuge": {
                    return this.mScript.term(">=", translatedArgs);
                }
                case "bvslt": {
                    Term[] utsArgs = args;
                    int i = 0;
                    while (i < args.length) {
                        utsArgs[i] = this.uts(width, args[i]);
                        ++i;
                    }
                    return this.mScript.term("<", utsArgs);
                }
                case "bvsle": {
                    Term[] utsArgs = args;
                    int i = 0;
                    while (i < args.length) {
                        utsArgs[i] = this.uts(width, args[i]);
                        ++i;
                    }
                    return this.mScript.term("<=", utsArgs);
                }
                case "bvsgt": {
                    Term[] utsArgs = args;
                    int i = 0;
                    while (i < args.length) {
                        utsArgs[i] = this.uts(width, args[i]);
                        ++i;
                    }
                    return this.mScript.term(">", utsArgs);
                }
                case "bvsge": {
                    Term[] utsArgs = args;
                    int i = 0;
                    while (i < args.length) {
                        utsArgs[i] = this.uts(width, args[i]);
                        ++i;
                    }
                    return this.mScript.term(">=", utsArgs);
                }
            }
        }
        throw new UnsupportedOperationException("unexpected relation");
    }

    private final Term uts(int width, Term term) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Term two = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L), (BigInteger)BigInteger.ONE), intSort);
        Term twoPowWidth = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(width - 1), (BigInteger)BigInteger.ONE), intSort);
        Term modulo = this.mScript.term("mod", new Term[]{term, twoPowWidth});
        return this.mScript.term("-", new Term[]{this.mScript.term("*", new Term[]{two, modulo}), term});
    }

    private Term pow2(Term term) {
        assert (term.getSort().isNumericSort());
        if (term instanceof ConstantTerm) {
            Term twoPow;
            Sort intSort = SmtSortUtils.getIntSort(this.mScript);
            ConstantTerm constTerm = (ConstantTerm)term;
            if (constTerm.getValue() instanceof Rational) {
                Rational ratint = (Rational)constTerm.getValue();
                twoPow = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(ratint.numerator().intValue()), (BigInteger)BigInteger.ONE), intSort);
            } else {
                BigInteger bigint = (BigInteger)constTerm.getValue();
                twoPow = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(bigint.intValue()), (BigInteger)BigInteger.ONE), intSort);
            }
            return twoPow;
        }
        throw new UnsupportedOperationException("function pow2 not implemented");
    }

    private boolean isBitVecSort(Sort sort) {
        return sort.getName().equals("BitVec");
    }

    private Sort translateSort(Script script, Sort sort) {
        Sort result;
        if (this.isBitVecSort(sort)) {
            result = SmtSortUtils.getIntSort(script);
        } else if (SmtSortUtils.isArraySort(sort)) {
            result = this.translateArraySort(sort);
        } else {
            throw new UnsupportedOperationException("Unsupported sort: " + sort);
        }
        return result;
    }

    public LinkedHashMap<Term, Term> getVarMap() {
        return this.mVariableMap;
    }

    public LinkedHashMap<Term, Term> getReversedVarMap() {
        return this.mReversedVarMap;
    }

    public boolean getNutzFlag() {
        return this.mNutzTransformation;
    }

    public Set<TermVariable> getOverapproxVariables() {
        return this.mOverapproxVariables;
    }

    public boolean wasOverapproximation() {
        return this.mIsOverapproximation;
    }
}

