/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class IntToBvBackTranslation
extends TermTransformer {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final LinkedHashMap<Term, Term> mVariableMap;
    private final Set<Term> mConstraintSet;
    private final FunctionSymbol mIntand;

    public IntToBvBackTranslation(ManagedScript mgdscript, LinkedHashMap<Term, Term> variableMap, Set<Term> constraintSet, FunctionSymbol intand) {
        this.mMgdScript = mgdscript;
        this.mScript = mgdscript.getScript();
        this.mVariableMap = variableMap;
        this.mConstraintSet = constraintSet;
        this.mIntand = intand;
    }

    public void convert(Term term) {
        ApplicationTerm appTerm;
        if (this.mConstraintSet.contains(term)) {
            this.setResult(this.mScript.term("true", new Term[0]));
            return;
        }
        if (this.mVariableMap.containsKey(term)) {
            this.setResult(this.mVariableMap.get(term));
            return;
        }
        if (term instanceof ConstantTerm) {
            this.setResult(this.translateConst((ConstantTerm)term));
            return;
        }
        if (term instanceof TermVariable) {
            throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + term);
        }
        if (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getParameters().length == 0 && SmtUtils.isConstant((Term)appTerm)) {
            throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + term);
        }
        super.convert(term);
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        HashSet<TermVariable> newTermVars = new HashSet<TermVariable>();
        if (newBody != old.getSubformula()) {
            int i = 0;
            while (i < old.getVariables().length) {
                if (this.mVariableMap.containsKey(old.getVariables()[i])) {
                    newTermVars.add((TermVariable)this.mVariableMap.get(old.getVariables()[i]));
                } else {
                    newTermVars.add(old.getVariables()[i]);
                }
                ++i;
            }
            this.setResult(SmtUtils.quantifier(this.mScript, old.getQuantifier(), newTermVars, newBody));
            return;
        }
        super.postConvertQuantifier(old, newBody);
    }

    private Term bringTermToWidth(Term term, int targetwidth, boolean argsigned) {
        if (!SmtSortUtils.isBitvecSort(term.getSort())) {
            return term;
        }
        int oldwidth = Integer.valueOf(term.getSort().getIndices()[0]);
        if (oldwidth == targetwidth) {
            return term;
        }
        if (oldwidth > targetwidth) {
            BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(targetwidth - 1), BigInteger.valueOf(0L)};
            return BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, term);
        }
        int extendby = targetwidth - oldwidth;
        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(extendby)};
        if (!argsigned) {
            return BitvectorUtils.termWithLocalSimplification(this.mScript, "zero_extend", indices, term);
        }
        return BitvectorUtils.termWithLocalSimplification(this.mScript, "sign_extend", indices, term);
    }

    private int getTwoExponent(Rational r) {
        BigInteger i = r.numerator();
        int value = Integer.lowestOneBit(i.intValue());
        if (Integer.highestOneBit(i.intValue()) == value) {
            return i.bitLength() - 1;
        }
        throw new UnsupportedOperationException("Not a power of two");
    }

    /*
     * Unable to fully structure code
     */
    private boolean isPowerOfTwo(Rational r) {
        i = r.numerator();
        if (BigInteger.ZERO.compareTo(i) != 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (i.mod(BigInteger.TWO) != BigInteger.ZERO) {
                return false;
            }
            i = i.divide(BigInteger.TWO);
lbl7:
            // 2 sources

            ** while (BigInteger.ONE.compareTo((BigInteger)i) != 0)
        }
lbl8:
        // 1 sources

        return true;
    }

    private boolean isSigned(Term term) {
        if (this.mVariableMap.containsKey(term)) {
            return false;
        }
        if (term instanceof ConstantTerm) {
            return ((Rational)((ConstantTerm)term).getValue()).isNegative();
        }
        if (term instanceof TermVariable) {
            return false;
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (appTerm.getParameters().length == 0) {
                if (SmtUtils.isConstant((Term)appTerm)) {
                    return false;
                }
                throw new UnsupportedOperationException("Cannot translate AuxVars back to Bitvector Sort " + term);
            }
            if (appTerm.getFunction().getName().equals("-")) {
                return true;
            }
            if (appTerm.getFunction().getName().equals("mod")) {
                return false;
            }
            boolean sign = false;
            int i = 0;
            while (i < appTerm.getParameters().length) {
                Term argument = appTerm.getParameters()[i];
                sign = sign || this.isSigned(argument);
                ++i;
            }
            return sign;
        }
        if (term instanceof QuantifiedFormula) {
            throw new UnsupportedOperationException("Unsupported sign of quantified formula");
        }
        throw new UnsupportedOperationException("Unknown Sign");
    }

    private Term getInnerMostArray(Term appTerm) {
        Term array;
        if (appTerm instanceof TermVariable) {
            return appTerm;
        }
        MultiDimensionalSelect mds = MultiDimensionalSelect.convert(appTerm);
        if (mds != null) {
            array = mds.getArray();
        } else {
            MultiDimensionalSelectOverNestedStore mdsons = MultiDimensionalSelectOverNestedStore.convert(this.mScript, appTerm);
            if (mdsons != null) {
                array = mdsons.getSelect().getArray();
            } else {
                throw new UnsupportedOperationException("unable to compute width: " + appTerm);
            }
        }
        if (array instanceof ApplicationTerm) {
            ApplicationTerm appArray = (ApplicationTerm)array;
            if (appArray.getFunction().getName().equals("select")) {
                array = this.getInnerMostArray(appArray.getParameters()[0]);
            } else if (appArray.getFunction().getName().equals("store")) {
                array = this.getInnerMostArray(appArray.getParameters()[0]);
            }
        }
        return array;
    }

    private Integer getWidth(Term term) {
        block38: {
            int width;
            block40: {
                ApplicationTerm appTerm;
                block39: {
                    width = 0;
                    if (this.mVariableMap.containsKey(term)) {
                        return Integer.valueOf(this.mVariableMap.get(term).getSort().getIndices()[0]);
                    }
                    if (term instanceof ConstantTerm) {
                        Rational value = (Rational)((ConstantTerm)term).getValue();
                        int minWidth = value.abs().numerator().bitLength();
                        width = minWidth == 0 ? 1 : minWidth;
                        return width;
                    }
                    if (term instanceof TermVariable) {
                        throw new UnsupportedOperationException("Unknown width of AuxVar");
                    }
                    if (!(term instanceof ApplicationTerm)) break block38;
                    appTerm = (ApplicationTerm)term;
                    if (appTerm.getParameters().length == 0) {
                        if (SmtUtils.isConstant((Term)appTerm)) {
                            throw new UnsupportedOperationException("Unknown width of AuxVar");
                        }
                        throw new UnsupportedOperationException("Unkexpected term: " + appTerm);
                    }
                    if (appTerm.getParameters().length == 1) {
                        if (appTerm.getFunction().getName().equals("-")) {
                            width = this.getWidth(appTerm.getParameters()[0]);
                        } else {
                            throw new UnsupportedOperationException("Unkexpected term: " + appTerm);
                        }
                    }
                    if (!appTerm.getFunction().getName().equals("select")) break block39;
                    Term array = this.getInnerMostArray((Term)appTerm);
                    Term bvArray = this.mVariableMap.get(array);
                    if (bvArray == null) {
                        throw new UnsupportedOperationException("Unknown Array: " + array);
                    }
                    MultiDimensionalSort mdSort = new MultiDimensionalSort(bvArray.getSort());
                    Sort valueSort = mdSort.getArrayValueSort();
                    width = Integer.valueOf(valueSort.getIndices()[0]);
                    break block40;
                }
                int maxWidth = !SmtSortUtils.isIntSort(appTerm.getParameters()[0].getSort()) ? 1 : this.getWidth(appTerm.getParameters()[0]);
                int i = 1;
                while (i < appTerm.getParameters().length) {
                    Term argument = appTerm.getParameters()[i];
                    int argWidth = this.getWidth(argument);
                    if (argWidth > maxWidth) {
                        maxWidth = argWidth;
                    }
                    ++i;
                }
                width = maxWidth;
                FunctionSymbol fsym = appTerm.getFunction();
                if (!fsym.isIntern()) break block40;
                switch (fsym.getName()) {
                    case "*": {
                        if (appTerm.getParameters().length == 2) {
                            ConstantTerm constTerm;
                            Rational value;
                            if (appTerm.getParameters()[0] instanceof ConstantTerm) {
                                ConstantTerm constTerm2 = (ConstantTerm)appTerm.getParameters()[0];
                                Rational value2 = (Rational)constTerm2.getValue();
                                if (this.isPowerOfTwo(value2)) {
                                    width = this.getWidth(appTerm.getParameters()[1]) + this.getTwoExponent(value2);
                                    break;
                                }
                            } else if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                                width = this.getWidth(appTerm.getParameters()[0]) + this.getTwoExponent(value);
                                break;
                            }
                        }
                        width = maxWidth * 2;
                        break;
                    }
                    case "+": {
                        width = maxWidth + 1;
                        break;
                    }
                    case "-": {
                        if (appTerm.getParameters()[0] instanceof ConstantTerm && this.isPowerOfTwo((Rational)((ConstantTerm)appTerm.getParameters()[0]).getValue())) {
                            width = this.getWidth(appTerm.getParameters()[1]);
                            break;
                        }
                        width = maxWidth + 1;
                        break;
                    }
                    case "mod": {
                        ConstantTerm constTerm;
                        Rational value;
                        if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                            width = this.getTwoExponent(value);
                            break;
                        }
                        width = maxWidth;
                        break;
                    }
                    case "div": {
                        ConstantTerm constTerm;
                        Rational value;
                        if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                            width = this.getWidth(appTerm.getParameters()[0]) - this.getTwoExponent(value);
                            break;
                        }
                        width = maxWidth;
                        break;
                    }
                    default: {
                        width = maxWidth;
                    }
                }
            }
            return width;
        }
        throw new UnsupportedOperationException("Unexpected Term " + term);
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] args) {
        Term[] newargs;
        block81: {
            newargs = new Term[args.length];
            Term[] oldargs = appTerm.getParameters();
            if (this.mConstraintSet.contains(appTerm)) {
                this.setResult(this.mScript.term("true", new Term[0]));
                return;
            }
            FunctionSymbol fsym = appTerm.getFunction();
            if (fsym.equals(this.mIntand) || fsym.getName().equals("intand")) {
                int i = 0;
                while (i < args.length) {
                    newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                    ++i;
                }
                this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvand", null, newargs));
                return;
            }
            if (!fsym.isIntern()) break block81;
            switch (fsym.getName()) {
                case "=": {
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = SmtSortUtils.isIntSort(appTerm.getParameters()[0].getSort()) ? this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i])) : args[i];
                        ++i;
                    }
                    this.setResult(SmtUtils.equality(this.mScript, newargs));
                    return;
                }
                case "<": {
                    if (this.isSigned((Term)appTerm)) {
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                            ++i;
                        }
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvslt", null, newargs));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvult", null, newargs));
                    return;
                }
                case "<=": {
                    if (this.isSigned((Term)appTerm)) {
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                            ++i;
                        }
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsle", null, newargs));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvule", null, newargs));
                    return;
                }
                case ">=": {
                    if (this.isSigned((Term)appTerm)) {
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                            ++i;
                        }
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsge", null, newargs));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvuge", null, newargs));
                    return;
                }
                case ">": {
                    if (this.isSigned((Term)appTerm)) {
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                            ++i;
                        }
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsgt", null, newargs));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvugt", null, newargs));
                    return;
                }
                case "+": {
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(SmtUtils.binaryBitvectorSum(this.mScript, null, newargs));
                    return;
                }
                case "*": {
                    ConstantTerm constTerm;
                    Rational value;
                    if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                        Term extendby = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(this.getTwoExponent(value))));
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "concat", null, args[0], extendby));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvmul", null, newargs));
                    return;
                }
                case "-": {
                    if (appTerm.getParameters().length == 1) {
                        assert (!(args[0] instanceof ConstantTerm));
                        this.setResult(this.mScript.term("bvneg", new Term[]{this.bringTermToWidth(args[0], this.getWidth((Term)appTerm), this.isSigned(oldargs[0]))}));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsub", null, newargs));
                    return;
                }
                case "mod": {
                    ConstantTerm constTerm;
                    Rational value;
                    if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(this.getTwoExponent(value) - 1), BigInteger.valueOf(0L)};
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, args[0]));
                        return;
                    }
                    if (this.isSigned((Term)appTerm)) {
                        int width = this.getWidth((Term)appTerm);
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], width, this.isSigned(oldargs[i]));
                            ++i;
                        }
                        Term one = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(1L)));
                        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(width - 1), BigInteger.valueOf(width - 1)};
                        Term bvsmod = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsmod", null, newargs);
                        Term ifTerm = SmtUtils.binaryEquality(this.mScript, BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, newargs[1]), one);
                        Term thenTerm = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvneg", null, BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsub", null, newargs[1], bvsmod));
                        this.setResult(Util.ite((Script)this.mScript, (Term)ifTerm, (Term)thenTerm, (Term)bvsmod));
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, newargs));
                    return;
                }
                case "div": {
                    ConstantTerm constTerm;
                    Rational value;
                    if (appTerm.getParameters()[1] instanceof ConstantTerm && this.isPowerOfTwo(value = (Rational)(constTerm = (ConstantTerm)appTerm.getParameters()[1]).getValue())) {
                        BigInteger[] indices = new BigInteger[2];
                        int oldwidth = Integer.valueOf(args[0].getSort().getIndices()[0]);
                        int twoExpo = this.getTwoExponent(value);
                        if (twoExpo > oldwidth - 1) {
                            Term zero = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(1L)));
                            this.setResult(zero);
                            return;
                        }
                        indices[0] = BigInteger.valueOf(oldwidth - 1);
                        indices[1] = BigInteger.valueOf(twoExpo);
                        this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, args[0]));
                        return;
                    }
                    if (this.isSigned((Term)appTerm)) {
                        int width = this.getWidth((Term)appTerm);
                        int i = 0;
                        while (i < args.length) {
                            newargs[i] = this.bringTermToWidth(args[i], width, this.isSigned(oldargs[i]));
                            ++i;
                        }
                        Term bvsdiv = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsdiv", null, newargs);
                        Term bvurem = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvurem", null, newargs);
                        Term zeroK = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(width)));
                        Term oneK = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(width)));
                        Term zero = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ZERO, BigInteger.valueOf(1L)));
                        Term one = BitvectorUtils.constructTerm(this.mScript, new BitvectorConstant(BigInteger.ONE, BigInteger.valueOf(1L)));
                        BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(width - 1), BigInteger.valueOf(width - 1)};
                        Term extractLHS = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, newargs[0]);
                        Term extractRHS = BitvectorUtils.termWithLocalSimplification(this.mScript, "extract", indices, newargs[1]);
                        Term bvsub = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvsub", null, bvsdiv, oneK);
                        Term bvadd = BitvectorUtils.termWithLocalSimplification(this.mScript, "bvadd", null, bvsdiv, oneK);
                        Term ifTerm3 = SmtUtils.and(this.mScript, SmtUtils.binaryEquality(this.mScript, extractLHS, one), SmtUtils.binaryEquality(this.mScript, extractRHS, one));
                        Term ite3 = Util.ite((Script)this.mScript, (Term)ifTerm3, (Term)bvadd, (Term)bvsdiv);
                        Term ifTerm2 = SmtUtils.and(this.mScript, SmtUtils.binaryEquality(this.mScript, extractLHS, one), SmtUtils.binaryEquality(this.mScript, extractRHS, zero));
                        Term ite2 = Util.ite((Script)this.mScript, (Term)ifTerm2, (Term)bvsub, (Term)ite3);
                        Term ifTerm = SmtUtils.not(this.mScript, SmtUtils.binaryEquality(this.mScript, bvurem, zeroK));
                        Term thenTerm = ite2;
                        Term ite1 = Util.ite((Script)this.mScript, (Term)ifTerm, (Term)thenTerm, (Term)bvsdiv);
                        this.setResult(ite1);
                        return;
                    }
                    int i = 0;
                    while (i < args.length) {
                        newargs[i] = this.bringTermToWidth(args[i], this.getWidth((Term)appTerm), this.isSigned(oldargs[i]));
                        ++i;
                    }
                    this.setResult(BitvectorUtils.termWithLocalSimplification(this.mScript, "bvudiv", null, newargs));
                    return;
                }
                case "ite": {
                    this.setResult(this.mScript.term("ite", new Term[]{args[0], args[1], args[2]}));
                    return;
                }
                case "select": {
                    if (Integer.parseInt(args[0].getSort().getArguments()[0].getIndices()[0]) != Integer.parseInt(args[1].getSort().getIndices()[0])) {
                        throw new AssertionError((Object)String.format("Cannot access array with %sbit indices via %sbit term.", Integer.parseInt(args[0].getSort().getArguments()[0].getIndices()[0]), Integer.parseInt(args[1].getSort().getIndices()[0])));
                    }
                    this.setResult(this.mScript.term("select", new Term[]{args[0], this.bringTermToWidth(args[1], Integer.parseInt(args[0].getSort().getArguments()[0].getIndices()[0]), false)}));
                    return;
                }
                case "store": {
                    Sort bitVecArraySort = this.getArrayValueSort(args[0].getSort());
                    this.setResult(this.mScript.term("store", new Term[]{args[0], this.bringTermToWidth(args[1], Integer.parseInt(args[0].getSort().getArguments()[0].getIndices()[0]), false), this.bringTermToWidth(args[2], Integer.parseInt(bitVecArraySort.getIndices()[0]), false)}));
                    return;
                }
                case "abs": {
                    throw new UnsupportedOperationException("Unexpected function in back-translation " + fsym.getName());
                }
                case "const": {
                    throw new UnsupportedOperationException("Unable to translate const array back. Don't know width of index. Look-ahead needed.");
                }
            }
            this.setResult(SmtUtils.termWithLocalSimplification(this.mScript, fsym, args));
            return;
        }
        super.convertApplicationTerm(appTerm, newargs);
    }

    private Sort getArrayValueSort(Sort array) {
        assert (SmtSortUtils.isArraySort(array));
        Sort argSort = array.getArguments()[1];
        if (SmtSortUtils.isBitvecSort(argSort)) {
            return argSort;
        }
        if (SmtSortUtils.isArraySort(argSort)) {
            return this.getArrayValueSort(argSort);
        }
        throw new UnsupportedOperationException("Unexpected Array Value Sort");
    }

    private Term translateConst(ConstantTerm value) {
        assert (value.getValue() instanceof Rational);
        if (((Rational)value.getValue()).isNegative()) {
            int width = this.getWidth((Term)value);
            return SmtUtils.rational2Term(this.mScript, (Rational)value.getValue(), SmtSortUtils.getBitvectorSort(this.mScript, width + 1));
        }
        int width = this.getWidth((Term)value);
        return SmtUtils.rational2Term(this.mScript, (Rational)value.getValue(), SmtSortUtils.getBitvectorSort(this.mScript, width));
    }
}

