/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.HashSet;

public class TranslationConstrainer {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private FunctionSymbol mIntand;
    public final ConstraintsForBitwiseOperations mMode;
    private final HashSet<Term> mConstraintSet;
    private final HashSet<Term> mTvConstraintSet;

    public TranslationConstrainer(ManagedScript mgdscript, ConstraintsForBitwiseOperations mode) {
        this.mMgdScript = mgdscript;
        this.mScript = mgdscript.getScript();
        this.mMode = mode;
        this.mConstraintSet = new HashSet();
        this.mTvConstraintSet = new HashSet();
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Sort[] functionsort = new Sort[]{intSort, intSort};
        if (this.mIntand == null) {
            if (this.mScript.getFunctionSymbol("intand") == null) {
                this.mScript.declareFun("intand", functionsort, intSort);
            }
            this.mIntand = this.mScript.getFunctionSymbol("intand");
        }
    }

    public HashSet<Term> getConstraints() {
        return this.mConstraintSet;
    }

    public HashSet<Term> getTvConstraints() {
        return this.mTvConstraintSet;
    }

    public FunctionSymbol getIntAndFunctionSymbol() {
        return this.mIntand;
    }

    private Term getLowerVarBounds(Term bvterm, Term intTerm) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Term translatedVar = intTerm;
        Term lowerBound = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(intSort), translatedVar});
        return lowerBound;
    }

    private Term getUpperVarBounds(Term bvterm, Term intTerm) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        int width = Integer.valueOf(bvterm.getSort().getIndices()[0]);
        Term translatedVar = intTerm;
        Rational twoPowWidth = Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(width), (BigInteger)BigInteger.ONE);
        Rational twoPowWidthSubOne = twoPowWidth.sub(Rational.ONE);
        Term upperBoundPaper = this.mScript.term("<", new Term[]{translatedVar, SmtUtils.rational2Term(this.mScript, twoPowWidth, intSort)});
        this.mScript.term("<=", new Term[]{translatedVar, SmtUtils.rational2Term(this.mScript, twoPowWidthSubOne, intSort)});
        return upperBoundPaper;
    }

    public void varConstraint(Term bvterm, Term intTerm) {
        this.mConstraintSet.add(this.getLowerVarBounds(bvterm, intTerm));
        this.mConstraintSet.add(this.getUpperVarBounds(bvterm, intTerm));
    }

    public Term getTvConstraint(TermVariable bvterm, Term intTerm) {
        Term lowerBound = this.getLowerVarBounds((Term)bvterm, intTerm);
        Term upperBoundPaper = this.getUpperVarBounds((Term)bvterm, intTerm);
        this.mTvConstraintSet.add(lowerBound);
        this.mTvConstraintSet.add(upperBoundPaper);
        return this.mScript.term("and", new Term[]{lowerBound, upperBoundPaper});
    }

    public Term getSelectConstraint(Term bvterm, Term intTerm) {
        Term lowerBound = this.getLowerVarBounds(bvterm, intTerm);
        Term upperBoundPaper = this.getUpperVarBounds(bvterm, intTerm);
        return this.mScript.term("and", new Term[]{lowerBound, upperBoundPaper});
    }

    public boolean bvandConstraint(Term intTerm, int width) {
        if (this.mMode.equals((Object)ConstraintsForBitwiseOperations.NONE)) {
            return true;
        }
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        if (!SmtSortUtils.isIntSort(intTerm.getSort())) {
            throw new UnsupportedOperationException("Cannot create Constraints vor non-Int Sort Terms");
        }
        if (intTerm instanceof ApplicationTerm) {
            Term modeConstraint;
            ApplicationTerm apterm = (ApplicationTerm)intTerm;
            Term translatedLHS = apterm.getParameters()[0];
            Term translatedRHS = apterm.getParameters()[1];
            Rational twoPowWidth = Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(width), (BigInteger)BigInteger.ONE);
            Term lazy = this.mScript.term("true", new Term[0]);
            switch (this.mMode) {
                case SUM: {
                    modeConstraint = this.bvandSUMConstraints(width, translatedLHS, translatedRHS);
                    break;
                }
                case BITWISE: {
                    Term lowerBound = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(intSort), apterm});
                    Term upperBound = this.mScript.term("<", new Term[]{apterm, SmtUtils.rational2Term(this.mScript, twoPowWidth, intSort)});
                    this.mConstraintSet.add(lowerBound);
                    this.mConstraintSet.add(upperBound);
                    modeConstraint = this.bvandBITWISEConstraints(width, translatedLHS, translatedRHS);
                    break;
                }
                case LAZY: {
                    Term lowerBound = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(intSort), apterm});
                    Term upperBound = this.mScript.term("<", new Term[]{apterm, SmtUtils.rational2Term(this.mScript, twoPowWidth, intSort)});
                    lazy = this.bvandLAZYConstraints(width, translatedLHS, translatedRHS);
                    this.mConstraintSet.add(lowerBound);
                    this.mConstraintSet.add(upperBound);
                    this.mConstraintSet.add(lazy);
                    return true;
                }
                case NONE: {
                    throw new UnsupportedOperationException("Deal with this mode at the beginning of this method");
                }
                default: {
                    throw new UnsupportedOperationException("Set Mode for bvand Constraints");
                }
            }
            UnfTransformer unfT = new UnfTransformer(this.mScript);
            Term unfModeConstraint = unfT.transform(modeConstraint);
            this.mConstraintSet.add(unfModeConstraint);
            return false;
        }
        throw new AssertionError((Object)"method must be called on IntAnd");
    }

    private Term bvandSUMConstraints(int width, Term translatedLHS, Term translatedRHS) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        BigInteger two = BigInteger.valueOf(2L);
        Term[] sum = new Term[width];
        int i = 0;
        while (i < width) {
            Term mul;
            Term twoPowI = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)two.pow(i), (BigInteger)BigInteger.ONE), intSort);
            Term one = SmtUtils.rational2Term(this.mScript, Rational.ONE, intSort);
            Term zero = SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort);
            Term ite = this.mScript.term("ite", new Term[]{this.mScript.term("=", new Term[]{this.isel(i, translatedLHS), this.isel(i, translatedRHS), one}), one, zero});
            sum[i] = mul = this.mScript.term("*", new Term[]{twoPowI, ite});
            ++i;
        }
        return this.mScript.term("=", new Term[]{this.mScript.term(this.mIntand.getName(), new Term[]{translatedLHS, translatedRHS}), this.mScript.term("+", sum)});
    }

    private Term bvandBITWISEConstraints(int width, Term translatedLHS, Term translatedRHS) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Term[] and = new Term[width];
        int i = 0;
        while (i < width) {
            Term equals;
            Term one = SmtUtils.rational2Term(this.mScript, Rational.ONE, intSort);
            Term zero = SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort);
            Term ite = this.mScript.term("ite", new Term[]{this.mScript.term("=", new Term[]{this.isel(i, translatedLHS), this.isel(i, translatedRHS), one}), one, zero});
            and[i] = equals = this.mScript.term("=", new Term[]{this.isel(i, this.mScript.term(this.mIntand.getName(), new Term[]{translatedLHS, translatedRHS})), ite});
            ++i;
        }
        return SmtUtils.and(this.mScript, and);
    }

    private Term bvandLAZYConstraints(int width, Term translatedLHS, Term translatedRHS) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Term zero = SmtUtils.rational2Term(this.mScript, Rational.ZERO, intSort);
        Term maxNumber = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(width), (BigInteger)BigInteger.ONE), intSort);
        Term[] lazyConstraints = new Term[8];
        Term intand = this.mScript.term(this.mIntand.getName(), new Term[]{translatedLHS, translatedRHS});
        lazyConstraints[0] = this.mScript.term("<=", new Term[]{intand, translatedLHS});
        lazyConstraints[1] = this.mScript.term("<=", new Term[]{intand, translatedRHS});
        lazyConstraints[2] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{translatedLHS, translatedRHS}), this.mScript.term("=", new Term[]{intand, translatedLHS})});
        lazyConstraints[3] = this.mScript.term("=", new Term[]{intand, this.mScript.term(this.mIntand.getName(), new Term[]{translatedRHS, translatedLHS})});
        lazyConstraints[4] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{translatedLHS, zero}), this.mScript.term("=", new Term[]{intand, zero})});
        lazyConstraints[5] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{zero, translatedRHS}), this.mScript.term("=", new Term[]{intand, zero})});
        lazyConstraints[6] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{translatedLHS, maxNumber}), this.mScript.term("=", new Term[]{intand, translatedRHS})});
        lazyConstraints[7] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{maxNumber, translatedRHS}), this.mScript.term("=", new Term[]{intand, translatedLHS})});
        return this.mScript.term("and", lazyConstraints);
    }

    private Term isel(int i, Term term) {
        Sort intSort = SmtSortUtils.getIntSort(this.mScript);
        Term two = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L), (BigInteger)BigInteger.ONE), intSort);
        Term twoPowI = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(i), (BigInteger)BigInteger.ONE), intSort);
        return this.mScript.term("mod", new Term[]{this.mScript.term("div", new Term[]{term, twoPowI}), two});
    }

    public static enum ConstraintsForBitwiseOperations {
        SUM,
        BITWISE,
        LAZY,
        NONE;

    }
}

