/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.BvToIntTranslation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntToBvBackTranslation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class TranslationManager {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final FunctionSymbol mIntand;
    private LinkedHashMap<Term, Term> mVariableMap;
    private LinkedHashMap<Term, Term> mReversedVarMap;
    private final TranslationConstrainer mTc;
    private final HashSet<Term> mConstraintSet;

    public TranslationManager(ManagedScript mgdscript, TranslationConstrainer.ConstraintsForBitwiseOperations cfbo) {
        this.mMgdScript = mgdscript;
        this.mScript = mgdscript.getScript();
        this.mVariableMap = new LinkedHashMap();
        this.mReversedVarMap = new LinkedHashMap();
        this.mConstraintSet = new HashSet();
        this.mTc = new TranslationConstrainer(this.mMgdScript, cfbo);
        this.mIntand = this.mTc.getIntAndFunctionSymbol();
    }

    public void setReplacementVarMaps(LinkedHashMap replacementVarMap) {
        this.mVariableMap = replacementVarMap;
    }

    public Triple<Term, Set<TermVariable>, Boolean> translateBvtoInt(Term bitvecFromula) {
        BvToIntTranslation bvToInt = new BvToIntTranslation(this.mMgdScript, this.mVariableMap, this.mTc, bitvecFromula.getFreeVars());
        bvToInt.setNutzTransformation(false);
        Term integerFormulaNoConstraint = bvToInt.transform(bitvecFromula);
        this.mVariableMap = bvToInt.getVarMap();
        this.mReversedVarMap = bvToInt.getReversedVarMap();
        Set<TermVariable> overapproxVariables = bvToInt.getOverapproxVariables();
        boolean isOverapproximation = bvToInt.wasOverapproximation();
        if (!bvToInt.getNutzFlag()) {
            this.mConstraintSet.addAll(this.mTc.getConstraints());
            this.mConstraintSet.addAll(bvToInt.mArraySelectConstraintMap.values());
        }
        Term integerFormula = SmtUtils.and(this.mScript, integerFormulaNoConstraint, SmtUtils.and(this.mScript, this.mConstraintSet));
        return new Triple((Object)integerFormula, overapproxVariables, (Object)isOverapproximation);
    }

    public Term translateIntBacktoBv(Term integerFormula) {
        UnfTransformer unfT = new UnfTransformer(this.mScript);
        Term simplifiedInput = unfT.transform(integerFormula);
        HashSet<Term> constraints = this.mConstraintSet;
        constraints.addAll(this.mTc.getTvConstraints());
        IntToBvBackTranslation intToBv = new IntToBvBackTranslation(this.mMgdScript, this.mReversedVarMap, constraints, this.mIntand);
        return intToBv.transform(simplifiedInput);
    }

    public LinkedHashMap<Term, Term> getVarMap() {
        return this.mVariableMap;
    }

    public LinkedHashMap<Term, Term> getReversedVarMap() {
        return this.mReversedVarMap;
    }
}

