/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;

public class CnfTransformer
extends XnfTransformer {
    public CnfTransformer(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    protected NnfTransformer.NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider services) {
        return new CnfTransformerHelper(services);
    }

    protected class CnfTransformerHelper
    extends XnfTransformer.XnfTransformerHelper {
        protected CnfTransformerHelper(IUltimateServiceProvider services) {
            super(CnfTransformer.this, services);
        }

        @Override
        public String innerConnectiveSymbol() {
            return "or";
        }

        @Override
        public String outerConnectiveSymbol() {
            return "and";
        }

        @Override
        public String innerJunctionName() {
            return "disjunction";
        }

        @Override
        public String outerJunctionName() {
            return "conjuction";
        }

        @Override
        public Term innerConnective(Script script, List<Term> params) {
            Term result = SmtUtils.or(CnfTransformer.this.mScript, params);
            return result;
        }

        @Override
        public Term outerConnective(Script script, List<Term> params) {
            Term result = SmtUtils.and(CnfTransformer.this.mScript, params);
            return result;
        }

        @Override
        public Term[] getOuterJuncts(Term term) {
            return SmtUtils.getConjuncts(term);
        }
    }
}

