/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;
import java.util.function.Function;

public class DnfTransformer
extends XnfTransformer {
    public DnfTransformer(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services, (Integer a) -> false);
    }

    public DnfTransformer(ManagedScript script, IUltimateServiceProvider services, Function<Integer, Boolean> funAbortIfExponential) {
        super(script, services, funAbortIfExponential);
    }

    @Override
    protected NnfTransformer.NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider services) {
        return new DnfTransformerHelper(services);
    }

    protected class DnfTransformerHelper
    extends XnfTransformer.XnfTransformerHelper {
        protected DnfTransformerHelper(IUltimateServiceProvider services) {
            super(services);
        }

        @Override
        public String innerConnectiveSymbol() {
            return "and";
        }

        @Override
        public String outerConnectiveSymbol() {
            return "or";
        }

        @Override
        public String innerJunctionName() {
            return "conjuction";
        }

        @Override
        public String outerJunctionName() {
            return "disjunction";
        }

        @Override
        public Term innerConnective(Script script, List<Term> params) {
            Term result = SmtUtils.and(DnfTransformer.this.mScript, params);
            return result;
        }

        @Override
        public Term outerConnective(Script script, List<Term> params) {
            Term result = SmtUtils.or(DnfTransformer.this.mScript, params);
            return result;
        }

        @Override
        public Term[] getOuterJuncts(Term term) {
            return SmtUtils.getDisjuncts(term);
        }
    }
}

