/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class Literal {
    private final Term mAtom;
    private final Polarity mPolarity;

    public Literal(Term input) {
        if (!SmtSortUtils.isBoolSort(input.getSort())) {
            throw new IllegalArgumentException("only applicable to sort Bool");
        }
        Term withoutNegation = null;
        int removedNegationSymbols = 0;
        do {
            if ((withoutNegation = Literal.getParameterOfNotTerm(input)) == null) continue;
            input = withoutNegation;
            ++removedNegationSymbols;
        } while (withoutNegation != null);
        this.mPolarity = removedNegationSymbols % 2 == 0 ? Polarity.POSITIVE : Polarity.NEGATIVE;
        this.mAtom = input;
    }

    public Term getAtom() {
        return this.mAtom;
    }

    public Polarity getPolarity() {
        return this.mPolarity;
    }

    public Term toTerm(Script script) {
        if (this.mPolarity == Polarity.POSITIVE) {
            return this.mAtom;
        }
        return script.term("not", new Term[]{this.mAtom});
    }

    public static Term getParameterOfNotTerm(Term term) {
        ApplicationTerm appTerm;
        if (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName().equals("not")) {
            assert (appTerm.getParameters().length == 1);
            return appTerm.getParameters()[0];
        }
        return null;
    }

    public static enum Polarity {
        POSITIVE,
        NEGATIVE;

    }
}

