/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class NnfTransformer {
    private static final String FRESH_VARIABLE_PREFIX = "nnf";
    private static final boolean DEBUG_CHECK_SOUNDNESS = false;
    protected final Script mScript;
    private final ManagedScript mMgdScript;
    protected final ILogger mLogger;
    private final NnfTransformerHelper mNnfTransformerHelper;
    private List<List<TermVariable>> mQuantifiedVariables;
    protected final QuantifierHandling mQuantifierHandling;
    protected Function<Integer, Boolean> mFunAbortIfExponential;

    public NnfTransformer(ManagedScript mgdScript, IUltimateServiceProvider services, QuantifierHandling quantifierHandling) {
        this(mgdScript, services, quantifierHandling, a -> false);
    }

    public NnfTransformer(ManagedScript mgdScript, IUltimateServiceProvider services, QuantifierHandling quantifierHandling, boolean omitSoundnessCheck) {
        this(mgdScript, services, quantifierHandling, a -> false);
    }

    public NnfTransformer(ManagedScript mgdScript, IUltimateServiceProvider services, QuantifierHandling quantifierHandling, Function<Integer, Boolean> funAbortIfExponential) {
        this.mFunAbortIfExponential = Objects.requireNonNull(funAbortIfExponential);
        this.mQuantifierHandling = quantifierHandling;
        this.mScript = mgdScript.getScript();
        this.mMgdScript = mgdScript;
        this.mLogger = services.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mNnfTransformerHelper = this.getNnfTransformerHelper(services);
    }

    protected NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider services) {
        return new NnfTransformerHelper(services);
    }

    public Term transform(Term term) {
        assert (this.mQuantifiedVariables == null);
        if (this.mQuantifierHandling == QuantifierHandling.PULL) {
            this.mQuantifiedVariables = new ArrayList<List<TermVariable>>();
            ArrayList firstQuantifierBlock = new ArrayList();
            this.mQuantifiedVariables.add(firstQuantifierBlock);
        }
        Term result = this.mNnfTransformerHelper.transform(term);
        if (this.mQuantifierHandling == QuantifierHandling.PULL) {
            int i = 0;
            while (i < this.mQuantifiedVariables.size()) {
                TermVariable[] variables = this.mQuantifiedVariables.get(i).toArray(new TermVariable[this.mQuantifiedVariables.get(i).size()]);
                if (variables.length > 0) {
                    int quantor = i % 2;
                    result = this.mScript.quantifier(quantor, variables, result, (Term[][])new Term[0][]);
                }
                ++i;
            }
            this.mQuantifiedVariables = null;
        }
        return result;
    }

    private static Term[] negateTerms(Script script, Term[] terms) {
        Term[] newTerms = new Term[terms.length];
        int i = 0;
        while (i < terms.length) {
            newTerms[i] = SmtUtils.not(script, terms[i]);
            ++i;
        }
        return newTerms;
    }

    private static Term[] negateLast(Script script, Term[] terms) {
        Term[] newTerms = new Term[terms.length];
        System.arraycopy(terms, 0, newTerms, 0, terms.length - 1);
        newTerms[terms.length - 1] = SmtUtils.not(script, terms[terms.length - 1]);
        return newTerms;
    }

    private static Term[] negateAllButLast(Script script, Term[] terms) {
        Term[] newTerms = new Term[terms.length];
        int i = 0;
        while (i < terms.length - 1) {
            newTerms[i] = SmtUtils.not(script, terms[i]);
            ++i;
        }
        newTerms[terms.length - 1] = terms[terms.length - 1];
        return newTerms;
    }

    public static Term convertIte(Script script, Term condTerm, Term ifTerm, Term elseTerm) {
        Term condImpliesIf = SmtUtils.or(script, SmtUtils.not(script, condTerm), ifTerm);
        Term notCondImpliesElse = SmtUtils.or(script, condTerm, elseTerm);
        Term result = SmtUtils.and(script, condImpliesIf, notCondImpliesElse);
        return result;
    }

    public static boolean isXor(ApplicationTerm appTerm, String functionName) {
        return functionName.equals("xor") || functionName.equals("distinct") && SmtUtils.firstParamIsBool(appTerm);
    }

    public static Term pushNot1StepInside(Script script, Term notParam, QuantifierHandling quantifierHandling) {
        if (notParam instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)notParam;
            String functionName = appTerm.getFunction().getName();
            Term[] params = appTerm.getParameters();
            if (functionName.equals("and")) {
                return SmtUtils.or(script, NnfTransformer.negateTerms(script, params));
            }
            if (functionName.equals("or")) {
                return SmtUtils.and(script, NnfTransformer.negateTerms(script, params));
            }
            if (functionName.equals("not")) {
                assert (appTerm.getParameters().length == 1);
                Term notnotParam = appTerm.getParameters()[0];
                return notnotParam;
            }
            if (functionName.equals("=>")) {
                return SmtUtils.and(script, NnfTransformer.negateLast(script, params));
            }
            if (functionName.equals("=") && SmtUtils.firstParamIsBool(appTerm)) {
                Term[] notParams = appTerm.getParameters();
                if (notParams.length > 2) {
                    Term binarized = SmtUtils.binarize(script, appTerm);
                    return SmtUtils.not(script, binarized);
                }
                assert (notParams.length == 2);
                return SmtUtils.binaryBooleanNotEquals(script, notParams[0], notParams[1]);
            }
            if (NnfTransformer.isXor(appTerm, functionName)) {
                Term[] notParams = appTerm.getParameters();
                if (notParams.length > 2) {
                    Term binarized = SmtUtils.binarize(script, appTerm);
                    return SmtUtils.not(script, binarized);
                }
                assert (notParams.length == 2);
                return SmtUtils.binaryBooleanEquality(script, notParams[0], notParams[1]);
            }
            if (functionName.equals("ite") && SmtUtils.allParamsAreBool(appTerm)) {
                Term[] notParams = appTerm.getParameters();
                assert (params.length == 3);
                Term condTerm = notParams[0];
                Term ifTerm = notParams[1];
                Term elseTerm = notParams[2];
                Term convertedIte = NnfTransformer.convertIte(script, condTerm, ifTerm, elseTerm);
                return SmtUtils.not(script, convertedIte);
            }
            return null;
        }
        if (notParam instanceof QuantifiedFormula) {
            switch (quantifierHandling) {
                case CRASH: {
                    throw new UnsupportedOperationException("quantifier handling set to " + (Object)((Object)quantifierHandling));
                }
                case IS_ATOM: {
                    return null;
                }
                case KEEP: {
                    QuantifiedFormula qformula = (QuantifiedFormula)notParam;
                    Term inner = qformula.getSubformula();
                    Term innerNegated = SmtUtils.not(script, inner);
                    int dualQuantifier = QuantifierUtils.getDualQuantifier(qformula.getQuantifier());
                    Term result = SmtUtils.quantifier(script, dualQuantifier, new HashSet<TermVariable>(Arrays.asList(qformula.getVariables())), innerNegated);
                    return result;
                }
                case PULL: {
                    throw new UnsupportedOperationException("20180601 Matthias: I am not sure if we should still support PULL");
                }
            }
            throw new AssertionError();
        }
        return null;
    }

    protected class NnfTransformerHelper
    extends TermTransformer {
        protected IUltimateServiceProvider mServices;

        protected NnfTransformerHelper(IUltimateServiceProvider services) {
            this.mServices = services;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void convert(Term term) {
            assert (SmtSortUtils.isBoolSort(term.getSort())) : "Input is not Bool";
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                String functionName = appTerm.getFunction().getName();
                if (functionName.equals("and")) {
                    Term flattened = SmtUtils.and(NnfTransformer.this.mScript, appTerm.getParameters());
                    if (SmtUtils.isFunctionApplication(flattened, "and")) {
                        super.convert(flattened);
                        return;
                    }
                    this.convert(flattened);
                    return;
                }
                if (functionName.equals("or")) {
                    Term flattened = SmtUtils.or(NnfTransformer.this.mScript, appTerm.getParameters());
                    if (SmtUtils.isFunctionApplication(flattened, "or")) {
                        super.convert(flattened);
                        return;
                    }
                    this.convert(flattened);
                    return;
                }
                if (functionName.equals("not")) {
                    assert (appTerm.getParameters().length == 1);
                    Term notParam = appTerm.getParameters()[0];
                    this.convertNot(notParam, term);
                    return;
                }
                if (functionName.equals("=>")) {
                    Term[] params = appTerm.getParameters();
                    this.convert(SmtUtils.or(NnfTransformer.this.mScript, NnfTransformer.negateAllButLast(NnfTransformer.this.mScript, params)));
                    return;
                }
                if (functionName.equals("=") && SmtUtils.firstParamIsBool(appTerm)) {
                    Term[] params = appTerm.getParameters();
                    if (params.length > 2) {
                        Term binarized = SmtUtils.binarize(NnfTransformer.this.mScript, appTerm);
                        this.convert(binarized);
                        return;
                    }
                    assert (params.length == 2);
                    this.convert(SmtUtils.binaryBooleanEquality(NnfTransformer.this.mScript, params[0], params[1]));
                    return;
                }
                if (NnfTransformer.isXor(appTerm, functionName)) {
                    Term[] params = appTerm.getParameters();
                    if (params.length > 2) {
                        Term binarized = SmtUtils.binarize(NnfTransformer.this.mScript, appTerm);
                        this.convert(binarized);
                        return;
                    }
                    assert (params.length == 2);
                    this.convert(SmtUtils.binaryBooleanNotEquals(NnfTransformer.this.mScript, params[0], params[1]));
                    return;
                }
                if (functionName.equals("ite") && SmtUtils.allParamsAreBool(appTerm)) {
                    Term[] params = appTerm.getParameters();
                    assert (params.length == 3);
                    Term condTerm = params[0];
                    Term ifTerm = params[1];
                    Term elseTerm = params[2];
                    Term result = NnfTransformer.convertIte(NnfTransformer.this.mScript, condTerm, ifTerm, elseTerm);
                    this.convert(result);
                    return;
                }
                this.setResult(term);
                return;
            }
            if (term instanceof TermVariable) {
                this.setResult(term);
                return;
            }
            if (term instanceof ConstantTerm) {
                this.setResult(term);
                return;
            }
            if (!(term instanceof QuantifiedFormula)) {
                if (!(term instanceof AnnotatedTerm)) return;
                NnfTransformer.this.mLogger.warn((Object)("thrown away annotations " + Arrays.toString(((AnnotatedTerm)term).getAnnotations())));
                this.convert(((AnnotatedTerm)term).getSubterm());
                return;
            }
            switch (NnfTransformer.this.mQuantifierHandling) {
                case CRASH: {
                    throw new UnsupportedOperationException("quantifier handling set to " + (Object)((Object)NnfTransformer.this.mQuantifierHandling));
                }
                case IS_ATOM: {
                    this.setResult(term);
                    return;
                }
                case KEEP: {
                    super.convert(term);
                    return;
                }
                case PULL: {
                    List<Object> variables;
                    QuantifiedFormula qf = (QuantifiedFormula)term;
                    if (NnfTransformer.this.mQuantifiedVariables.size() - 1 == qf.getQuantifier()) {
                        variables = NnfTransformer.this.mQuantifiedVariables.get(NnfTransformer.this.mQuantifiedVariables.size() - 1);
                    } else {
                        variables = new ArrayList();
                        NnfTransformer.this.mQuantifiedVariables.add(variables);
                    }
                    HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
                    TermVariable[] termVariableArray = qf.getVariables();
                    int n = termVariableArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            Term newBody = Substitution.apply(NnfTransformer.this.mMgdScript, substitutionMapping, qf.getSubformula());
                            this.convert(newBody);
                            return;
                        }
                        TermVariable oldTv = termVariableArray[n2];
                        TermVariable freshTv = NnfTransformer.this.mMgdScript.constructFreshTermVariable(NnfTransformer.FRESH_VARIABLE_PREFIX, oldTv.getSort());
                        substitutionMapping.put(oldTv, freshTv);
                        variables.add(freshTv);
                        ++n2;
                    }
                }
            }
            throw new AssertionError((Object)"unknown case");
        }

        private void convertNot(Term notParam, Term notTerm) {
            assert (SmtSortUtils.isBoolSort(notParam.getSort())) : "Input is not Bool";
            Term pushed = NnfTransformer.pushNot1StepInside(NnfTransformer.this.mScript, notParam, NnfTransformer.this.mQuantifierHandling);
            if (pushed == null) {
                this.setResult(notTerm);
            } else {
                this.convert(pushed);
            }
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            Term simplified = SmtUtils.termWithLocalSimplification(NnfTransformer.this.mScript, appTerm.getFunction(), newArgs);
            this.setResult(simplified);
        }
    }

    public static enum QuantifierHandling {
        CRASH,
        KEEP,
        IS_ATOM,
        PULL;

    }
}

