/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class UnfTransformer
extends TermTransformer {
    private final Script mScript;
    private static Set<String> mRelationSymbols = Arrays.stream(RelationSymbol.values()).map(Object::toString).collect(Collectors.toSet());

    public UnfTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (UnfTransformer.isEqualityOrDisequalityWithMoreThanTwoParams(appTerm)) {
                Term binarized = SmtUtils.binarize(this.mScript, appTerm);
                this.convert(binarized);
                return;
            }
            super.convert(term);
        } else {
            if (term instanceof ConstantTerm) {
                ConstantTerm constTerm = (ConstantTerm)term;
                Rational rational = SmtUtils.toRational(constTerm);
                Term normalized = rational.toTerm(term.getSort());
                this.setResult(normalized);
                return;
            }
            super.convert(term);
        }
    }

    private static boolean isEqualityOrDisequalityWithMoreThanTwoParams(ApplicationTerm appTerm) {
        return (appTerm.getFunction().getName().equals("=") || appTerm.getFunction().getName().equals("distinct")) && appTerm.getParameters().length > 2;
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        PolynomialRelation polyPolyRel;
        FunctionSymbol fun = appTerm.getFunction();
        String appString = fun.getApplicationString();
        Term result = SmtUtils.termWithLocalSimplification(this.mScript, fun, newArgs);
        if (mRelationSymbols.contains(appString) && (polyPolyRel = PolynomialRelation.convert(this.mScript, result)) != null) {
            result = polyPolyRel.positiveNormalForm(this.mScript);
        }
        this.setResult(result);
    }
}

