/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.Literal;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XJunction {
    private final Map<Term, Literal.Polarity> mPolarityMap;

    public XJunction(Term[] terms) throws AtomAndNegationException {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>(terms.length);
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            this.addTermWithUnknownPolarity(term);
            ++n2;
        }
    }

    public XJunction(XJunction xJunction) {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>(xJunction.mPolarityMap);
    }

    public XJunction() {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>();
    }

    public XJunction(Term atom, Literal.Polarity polarity) {
        this.mPolarityMap = new HashMap<Term, Literal.Polarity>();
        this.mPolarityMap.put(atom, polarity);
    }

    public boolean addTermWithUnknownPolarity(Term term) throws AtomAndNegationException {
        Literal literal = new Literal(term);
        return this.add(literal.getAtom(), literal.getPolarity());
    }

    boolean add(Term atom, Literal.Polarity polarity) throws AtomAndNegationException {
        boolean containsNegation = this.containsNegation(atom, polarity);
        if (containsNegation) {
            throw new AtomAndNegationException();
        }
        return this.mPolarityMap.put(atom, polarity) == null;
    }

    public boolean contains(Term atom, Literal.Polarity polarity) {
        return this.mPolarityMap.get(atom) == polarity;
    }

    public boolean containsNegation(Term term, Literal.Polarity polarity) {
        Literal.Polarity existing = this.mPolarityMap.get(term);
        if (existing != null) {
            return existing != polarity;
        }
        return false;
    }

    public List<Term> toTermList(Script script) {
        ArrayList<Term> result = new ArrayList<Term>(this.mPolarityMap.size());
        for (Map.Entry<Term, Literal.Polarity> entry : this.mPolarityMap.entrySet()) {
            if (entry.getValue() == Literal.Polarity.POSITIVE) {
                result.add(entry.getKey());
                continue;
            }
            result.add(SmtUtils.not(script, entry.getKey()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XJunction other = (XJunction)obj;
        return !(this.mPolarityMap == null ? other.mPolarityMap != null : !this.mPolarityMap.equals(other.mPolarityMap));
    }

    public int hashCode() {
        return this.mPolarityMap.hashCode();
    }

    public Set<Map.Entry<Term, Literal.Polarity>> entrySet() {
        return Collections.unmodifiableSet(this.mPolarityMap.entrySet());
    }

    public int size() {
        return this.mPolarityMap.size();
    }

    public Literal.Polarity getPolarity(Term atom) {
        return this.mPolarityMap.get(atom);
    }

    public Literal.Polarity remove(Term atom) {
        return this.mPolarityMap.remove(atom);
    }

    public String toString() {
        return this.mPolarityMap.toString();
    }

    public boolean isSubset(XJunction xjunction) {
        if (xjunction.size() < this.size()) {
            return false;
        }
        return xjunction.mPolarityMap.entrySet().containsAll(this.mPolarityMap.entrySet());
    }

    public static XJunction disjointUnion(XJunction xjunction1, XJunction xjunction2) throws AtomAndNegationException {
        XJunction result = new XJunction(xjunction1);
        for (Map.Entry<Term, Literal.Polarity> atom : xjunction2.entrySet()) {
            boolean modified = result.add(atom.getKey(), atom.getValue());
            if (modified) continue;
            throw new IllegalArgumentException("inputs were not disjoint");
        }
        return result;
    }

    public class AtomAndNegationException
    extends Exception {
        private static final long serialVersionUID = -5506932837927008768L;
    }
}

