/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.Literal;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XJunction;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class XnfTransformer
extends NnfTransformer {
    public static final boolean POSET_SIMPLIFICATION = true;

    public XnfTransformer(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services, NnfTransformer.QuantifierHandling.IS_ATOM);
    }

    public XnfTransformer(ManagedScript script, IUltimateServiceProvider services, Function<Integer, Boolean> funAbortIfExponential) {
        super(script, services, NnfTransformer.QuantifierHandling.IS_ATOM, funAbortIfExponential);
    }

    public class AbortBeforeBlowup
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    protected abstract class XnfTransformerHelper
    extends NnfTransformer.NnfTransformerHelper {
        protected XnfTransformerHelper(IUltimateServiceProvider services) {
            super(services);
        }

        public abstract String innerConnectiveSymbol();

        public abstract String outerConnectiveSymbol();

        public abstract String innerJunctionName();

        public abstract String outerJunctionName();

        public abstract Term innerConnective(Script var1, List<Term> var2);

        public abstract Term outerConnective(Script var1, List<Term> var2);

        public abstract Term[] getOuterJuncts(Term var1);

        @Override
        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            Term result;
            String functionSymbolName = appTerm.getFunction().getName();
            if (functionSymbolName.equals(this.innerConnectiveSymbol())) {
                Term[] resOuterJuncts = this.applyDistributivityAndOr(newArgs);
                result = this.outerConnective(XnfTransformer.this.mScript, Arrays.asList(resOuterJuncts));
            } else if (functionSymbolName.equals(this.outerConnectiveSymbol())) {
                result = this.outerConnective(XnfTransformer.this.mScript, Arrays.asList(newArgs));
            } else {
                throw new AssertionError();
            }
            this.setResult(result);
        }

        private Term[] applyDistributivityAndOr(Term[] inputInnerJunction) {
            ResultInnerJunctions first;
            try {
                first = new ResultInnerJunctions(this.convertInnerJunctionOfOuterJunctionsToSet(inputInnerJunction));
            }
            catch (XJunction.AtomAndNegationException atomAndNegationException) {
                return new Term[0];
            }
            int inputSize = first.numberOfUnprocessedOuterJunctions();
            if (inputSize > 5) {
                if (((Boolean)XnfTransformer.this.mFunAbortIfExponential.apply(inputSize)).booleanValue()) {
                    XnfTransformer.this.mLogger.warn((Object)("aborting because of expected exponential blowup for input size " + inputSize));
                    throw new AbortBeforeBlowup();
                }
                XnfTransformer.this.mLogger.warn((Object)("expecting exponential blowup for input size " + inputSize));
            }
            HashSet<XJunction> resOuterJunction = new HashSet<XJunction>();
            ArrayDeque<ResultInnerJunctions> todoStack = new ArrayDeque<ResultInnerJunctions>();
            todoStack.add(first);
            while (!todoStack.isEmpty()) {
                ResultInnerJunctions top = (ResultInnerJunctions)todoStack.pop();
                if (top.isProcessedToInnerJunction()) {
                    resOuterJunction.add(top.getInnerJunction());
                } else {
                    todoStack.addAll(top.processOneOuterJunction());
                }
                if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
                throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "transforming " + inputSize + " " + this.innerJunctionName());
            }
            Set<XJunction> elems = this.simplifyWithPosetMinimalElements(resOuterJunction);
            Term[] resInnerTerms = new Term[elems.size()];
            int i = 0;
            for (XJunction resInnerSet : elems) {
                resInnerTerms[i] = this.innerConnective(XnfTransformer.this.mScript, resInnerSet.toTermList(XnfTransformer.this.mScript));
                ++i;
            }
            assert (i == resInnerTerms.length);
            return resInnerTerms;
        }

        private Set<XJunction> simplifyWithPosetMinimalElements(Set<XJunction> resOuterJunction) {
            boolean timeConsumingSimplification;
            boolean bl = timeConsumingSimplification = resOuterJunction.size() > 5000;
            if (timeConsumingSimplification) {
                XnfTransformer.this.mLogger.warn((Object)("Simplifying " + this.outerJunctionName() + " of " + resOuterJunction.size() + " " + this.innerJunctionName() + "s. " + "This might take some time..."));
            }
            XJunctionPosetMinimalElements pme = new XJunctionPosetMinimalElements();
            for (XJunction resInnerSet : resOuterJunction) {
                if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "XNF transformer was simplifying " + resOuterJunction.size() + " " + this.innerJunctionName() + "s. ");
                }
                pme.add(resInnerSet);
            }
            if (timeConsumingSimplification) {
                XnfTransformer.this.mLogger.info((Object)("Simplified to " + this.outerJunctionName() + " of " + pme.getElements().size() + " " + this.innerJunctionName() + "s. "));
            }
            return pme.getElements();
        }

        private Set<XJunction> convertInnerJunctionOfOuterJunctionsToSet(Term[] inputInnerJunction) {
            HashSet<XJunction> result = new HashSet<XJunction>();
            Term[] termArray = inputInnerJunction;
            int n = inputInnerJunction.length;
            int n2 = 0;
            while (n2 < n) {
                Term inputInnerJunct = termArray[n2];
                Term[] inputOuterJunction = this.getOuterJuncts(inputInnerJunct);
                try {
                    result.add(new XJunction(inputOuterJunction));
                }
                catch (XJunction.AtomAndNegationException atomAndNegationException) {}
                ++n2;
            }
            return result;
        }

        private class ResultInnerJunctions {
            private final XJunction mInnerJuncts;
            private final Set<XJunction> mUnprocessedInnerJunctionOfOuterJunctions;

            public ResultInnerJunctions(Set<XJunction> innerJunctionOfOuterJunctions) throws XJunction.AtomAndNegationException {
                XJunction innerJuncts = new XJunction();
                this.mUnprocessedInnerJunctionOfOuterJunctions = this.moveOutwardsAbsorbeAndMpsimplify(innerJuncts, innerJunctionOfOuterJunctions);
                this.mInnerJuncts = innerJuncts;
            }

            public ResultInnerJunctions(XJunction innerJuncts, Set<XJunction> innerJunctionOfOuterJunctions) throws XJunction.AtomAndNegationException {
                XJunction newInnerJuncts = new XJunction();
                this.mUnprocessedInnerJunctionOfOuterJunctions = this.moveOutwardsAbsorbeAndMpsimplify(newInnerJuncts, innerJunctionOfOuterJunctions);
                this.mInnerJuncts = XJunction.disjointUnion(innerJuncts, newInnerJuncts);
            }

            public boolean isProcessedToInnerJunction() {
                return this.mUnprocessedInnerJunctionOfOuterJunctions.isEmpty();
            }

            public int numberOfUnprocessedOuterJunctions() {
                return this.mUnprocessedInnerJunctionOfOuterJunctions.size();
            }

            public XJunction getInnerJunction() {
                return this.mInnerJuncts;
            }

            public List<ResultInnerJunctions> processOneOuterJunction() {
                Iterator<XJunction> it = this.mUnprocessedInnerJunctionOfOuterJunctions.iterator();
                XJunction next = it.next();
                it.remove();
                ArrayList<ResultInnerJunctions> result = new ArrayList<ResultInnerJunctions>(next.size());
                for (Map.Entry<Term, Literal.Polarity> entry : next.entrySet()) {
                    XJunction singletonInnerJunct = new XJunction(entry.getKey(), entry.getValue());
                    HashSet<XJunction> innerJunctionOfOuterJunctions = new HashSet<XJunction>(this.mUnprocessedInnerJunctionOfOuterJunctions);
                    innerJunctionOfOuterJunctions.add(singletonInnerJunct);
                    XJunction innerJunctions = new XJunction(this.mInnerJuncts);
                    try {
                        ResultInnerJunctions rij = new ResultInnerJunctions(innerJunctions, innerJunctionOfOuterJunctions);
                        result.add(rij);
                    }
                    catch (XJunction.AtomAndNegationException atomAndNegationException) {}
                }
                return result;
            }

            private Set<XJunction> moveOutwardsAbsorbeAndMpsimplify(XJunction innerJunction, Set<XJunction> innerJunctionOfOuterJunctions) throws XJunction.AtomAndNegationException {
                boolean modified;
                while (modified = this.moveSingletonsOutwards(innerJunction, innerJunctionOfOuterJunctions)) {
                    Set<XJunction> newinnerJunctionOfOuterJunctions = this.applyAbsorbeAndMpsimplify(innerJunction, innerJunctionOfOuterJunctions);
                    if (newinnerJunctionOfOuterJunctions == innerJunctionOfOuterJunctions) {
                        return innerJunctionOfOuterJunctions;
                    }
                    innerJunctionOfOuterJunctions = newinnerJunctionOfOuterJunctions;
                }
                return innerJunctionOfOuterJunctions;
            }

            private boolean moveSingletonsOutwards(XJunction innerJunction, Set<XJunction> innerJunctionOfOuterJunctions) throws XJunction.AtomAndNegationException {
                boolean someSingletonContained = false;
                Iterator<XJunction> it = innerJunctionOfOuterJunctions.iterator();
                while (it.hasNext()) {
                    XJunction outerJunction = it.next();
                    if (outerJunction.size() != 1) continue;
                    Map.Entry<Term, Literal.Polarity> singleton = outerJunction.entrySet().iterator().next();
                    innerJunction.add(singleton.getKey(), singleton.getValue());
                    someSingletonContained = true;
                    it.remove();
                }
                return someSingletonContained;
            }

            private Set<XJunction> applyAbsorbeAndMpsimplify(XJunction innerJunction, Set<XJunction> innerJunctionOfOuterJunctions) {
                HashSet<XJunction> newInnerJunctionOfOuterJunctions = new HashSet<XJunction>();
                boolean modified = false;
                for (XJunction outerJunction : innerJunctionOfOuterJunctions) {
                    XJunction newOuterJunction = this.applyAbsorbeAndMpsimplify(innerJunction, outerJunction);
                    if (newOuterJunction == null) {
                        modified = true;
                        continue;
                    }
                    if (outerJunction == newOuterJunction) {
                        newInnerJunctionOfOuterJunctions.add(newOuterJunction);
                        continue;
                    }
                    assert (outerJunction.size() > newOuterJunction.size());
                    newInnerJunctionOfOuterJunctions.add(newOuterJunction);
                }
                if (modified) {
                    return newInnerJunctionOfOuterJunctions;
                }
                return innerJunctionOfOuterJunctions;
            }

            private XJunction applyAbsorbeAndMpsimplify(XJunction innerJunction, XJunction outerJunction) {
                XJunction resultOuterJunction = outerJunction;
                for (Map.Entry<Term, Literal.Polarity> literal : innerJunction.entrySet()) {
                    if (outerJunction.contains(literal.getKey(), literal.getValue())) {
                        return null;
                    }
                    if (!outerJunction.containsNegation(literal.getKey(), literal.getValue())) continue;
                    if (resultOuterJunction == outerJunction) {
                        resultOuterJunction = new XJunction(outerJunction);
                    }
                    resultOuterJunction.remove(literal.getKey());
                }
                return resultOuterJunction;
            }
        }

        class XJunctionPosetMinimalElements {
            private final Set<XJunction> mElements = new HashSet<XJunction>();

            XJunctionPosetMinimalElements() {
            }

            public void add(XJunction xjunction) {
                Iterator<XJunction> it = this.mElements.iterator();
                while (it.hasNext()) {
                    XJunction existing = it.next();
                    if (existing.isSubset(xjunction)) {
                        return;
                    }
                    if (!xjunction.isSubset(existing)) continue;
                    it.remove();
                }
                this.mElements.add(xjunction);
            }

            public Set<XJunction> getElements() {
                return this.mElements;
            }

            public int size() {
                return this.mElements.size();
            }
        }
    }
}

